

<?php $__env->startSection('title', 'แดชบอร์ด'); ?>
<?php $__env->startSection('page-title', 'แดชบอร์ด'); ?>
<?php $__env->startSection('mobile-title', 'หน้าหลัก'); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Card (Mobile Only) -->
<div class="welcome-card">
    <div class="welcome-content">
        <div class="welcome-text">
            <div class="welcome-greeting"><?php echo e(__('dashboard.greeting')); ?></div>
            <div class="welcome-name"><?php echo e(Auth::user()->name); ?></div>
            <div class="welcome-subtitle"><?php echo e(__('dashboard.ready_to_work')); ?></div>
        </div>
        <div class="welcome-actions">
            <form method="POST" action="<?php echo e(route('language.switch')); ?>" class="language-form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="locale" value="<?php echo e(app()->getLocale() === 'th' ? 'en' : 'th'); ?>">
                <button type="submit" class="language-btn-mobile">
                    <i class="fas fa-globe"></i>
                    <?php echo e(app()->getLocale() === 'th' ? 'EN' : 'TH'); ?>

                </button>
            </form>
            <div class="welcome-icon">
                <i class="fas <?php echo e(Auth::user()->role == '2wheel' ? 'fa-motorcycle' : 'fa-truck'); ?>"></i>
            </div>
        </div>
    </div>
</div>

<!-- Today's Summary -->
<div class="today-summary-card">
    <div class="summary-header">
        <div class="summary-title">
            <i class="fas fa-calendar-day"></i>
            <span><?php echo e(__('dashboard.today_summary')); ?></span>
        </div>
        <div class="summary-date"><?php echo e(now()->format('d/m/Y')); ?></div>
    </div>
    <div class="summary-stats">
        <div class="summary-stat">
            <div class="stat-value"><?php echo e(number_format($todayStats['parcels'] ?? 0)); ?></div>
            <div class="stat-label"><?php echo e(__('dashboard.parcels')); ?></div>
        </div>
        <div class="summary-stat">
            <div class="stat-value">฿<?php echo e(number_format($todayStats['commission'] ?? 0, 0)); ?></div>
            <div class="stat-label"><?php echo e(__('dashboard.commission')); ?></div>
        </div>
    </div>
    <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="record-btn">
        <i class="fas fa-plus"></i>
        <?php echo e(__('dashboard.record_delivery')); ?>

    </a>
</div>

<!-- Stats Grid -->
<div class="stats-grid">
    <div class="stat-card week">
        <div class="stat-icon">
            <i class="fas fa-calendar-week"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?php echo e(number_format($weekStats['parcels'] ?? 0)); ?></div>
            <div class="stat-label"><?php echo e(__('dashboard.this_week')); ?></div>
            <div class="stat-detail">
                <span class="detail-badge week">
                    <i class="fas fa-coins"></i>
                    ฿<?php echo e(number_format($weekStats['commission'] ?? 0, 0)); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="stat-card month">
        <div class="stat-icon">
            <i class="fas fa-calendar-alt"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?php echo e(number_format($monthStats['parcels'] ?? 0)); ?></div>
            <div class="stat-label"><?php echo e(__('dashboard.this_month')); ?></div>
            <div class="stat-detail">
                <span class="detail-badge month">
                    <i class="fas fa-coins"></i>
                    ฿<?php echo e(number_format($monthStats['commission'] ?? 0, 0)); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="stat-card average">
        <div class="stat-icon">
            <i class="fas fa-chart-line"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?php echo e(number_format($avgStats['parcels_per_day'] ?? 0, 1)); ?></div>
            <div class="stat-label"><?php echo e(__('dashboard.avg_per_day')); ?></div>
            <div class="stat-detail">
                <span class="detail-badge average">
                    <i class="fas fa-coins"></i>
                    ฿<?php echo e(number_format($avgStats['commission_per_day'] ?? 0, 0)); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="stat-card performance">
        <div class="stat-icon">
            <i class="fas fa-trophy"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?php echo e(number_format((($monthStats['parcels'] ?? 0) / max(1, ($monthStats['days'] ?? 1)) * 100), 0)); ?>%</div>
            <div class="stat-label"><?php echo e(__('dashboard.performance')); ?></div>
            <div class="stat-detail">
                <span class="detail-badge performance">
                    <i class="fas fa-calendar-check"></i>
                    <?php echo e($monthStats['days'] ?? 0); ?> <?php echo e(__('dashboard.days')); ?>

                </span>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="quick-actions-card">
    <div class="actions-header">
        <div class="actions-title"><?php echo e(__('dashboard.quick_actions')); ?></div>
    </div>
    <div class="actions-grid">
        <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="action-item primary">
            <div class="action-icon">
                <i class="fas fa-plus"></i>
            </div>
            <span class="action-label"><?php echo e(__('dashboard.new_record')); ?></span>
        </a>
        <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="action-item secondary">
            <div class="action-icon">
                <i class="fas fa-history"></i>
            </div>
            <span class="action-label"><?php echo e(__('dashboard.history')); ?></span>
        </a>
        <a href="<?php echo e(route('vehicle.calculator')); ?>" class="action-item tertiary">
            <div class="action-icon">
                <i class="fas fa-calculator"></i>
            </div>
            <span class="action-label"><?php echo e(__('dashboard.calculate')); ?></span>
        </a>
        <a href="<?php echo e(route('finance.dashboard')); ?>" class="action-item quaternary">
            <div class="action-icon">
                <i class="fas fa-wallet"></i>
            </div>
            <span class="action-label"><?php echo e(__('dashboard.finance')); ?></span>
        </a>
    </div>
</div>

<!-- Performance Chart -->
<div class="chart-card">
    <div class="chart-header">
        <div class="chart-title">
            <i class="fas fa-chart-line"></i>
            <?php echo e(__('dashboard.performance_chart')); ?>

        </div>
    </div>
    <div class="chart-body">
        <canvas id="performanceChart"></canvas>
    </div>
</div>

<!-- Recent Records -->
<div class="records-card">
    <div class="records-header">
        <div class="records-title">
            <i class="fas fa-history"></i>
            <?php echo e(__('dashboard.recent_deliveries')); ?>

        </div>
        <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="view-all-btn">
            <?php echo e(__('dashboard.view_all')); ?>

            <i class="fas fa-arrow-right"></i>
        </a>
    </div>
    <div class="records-list">
        <?php $__empty_1 = true; $__currentLoopData = $recentRecords ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="record-item">
                <div class="record-icon">
                    <i class="fas fa-box"></i>
                </div>
                <div class="record-content">
                    <div class="record-title"><?php echo e($record->delivery_date->format('d/m/Y')); ?></div>
                    <div class="record-meta">
                        <span class="record-parcels"><?php echo e($record->parcel_count); ?> ชิ้น</span>
                        <span class="record-warehouse"><?php echo e($record->warehouse->name ?? 'N/A'); ?></span>
                    </div>
                </div>
                <div class="record-amount">
                    ฿<?php echo e(number_format($record->commission_amount, 0)); ?>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-records">
                <i class="fas fa-clipboard-list"></i>
                <p>ยังไม่มีการจัดส่งล่าสุด</p>
                <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="add-record-btn">
                    <i class="fas fa-plus"></i>
                    เริ่มบันทึก
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Commission Info -->
<div class="commission-card">
    <div class="commission-header">
        <div class="commission-title">
            <i class="fas fa-info-circle"></i>
            ข้อมูลคอมมิชชั่น
        </div>
    </div>
    <div class="commission-content">
        <div class="commission-info">
            <div class="info-item">
                <i class="fas fa-warehouse"></i>
                <span>คลัง: <?php echo e(auth()->user()->warehouse->name ?? auth()->user()->warehouse_code); ?></span>
            </div>
            <div class="info-item">
                <i class="fas fa-<?php echo e(auth()->user()->role == '2wheel' ? 'motorcycle' : 'truck'); ?>"></i>
                <span>ประเภท: <?php echo e(auth()->user()->role == '2wheel' ? 'รถมอเตอร์ไซค์' : 'รถสี่ล้อ'); ?></span>
            </div>
        </div>
        
        <?php if(isset($commissionRates) && $commissionRates->count() > 0): ?>
            <div class="rates-table">
                <?php $__currentLoopData = $commissionRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="rate-row">
                        <div class="rate-range"><?php echo e($rate->range_display); ?></div>
                        <div class="rate-amount">฿<?php echo e(number_format($rate->rate_per_package, 2)); ?></div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="empty-rates">
                <i class="fas fa-exclamation-circle"></i>
                <p>ไม่มีข้อมูลอัตราคอมมิชชั่น</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Welcome Card */
.welcome-card {
    background: var(--gradient);
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    color: white;
}

.welcome-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.welcome-greeting {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 4px;
}

.welcome-name {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 4px;
}

.welcome-subtitle {
    font-size: 14px;
    opacity: 0.9;
}

.welcome-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

/* Today Summary */
.today-summary-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.summary-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 16px;
}

.summary-title {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
}

.summary-title i {
    color: var(--primary);
}

.summary-date {
    font-size: 14px;
    color: var(--gray-500);
    font-weight: 500;
}

.summary-stats {
    display: flex;
    justify-content: space-around;
    margin-bottom: 20px;
}

.summary-stat {
    text-align: center;
}

.summary-stat .stat-value {
    font-size: 24px;
    font-weight: 700;
    color: var(--primary);
    margin-bottom: 4px;
}

.summary-stat .stat-label {
    font-size: 12px;
    color: var(--gray-500);
    font-weight: 500;
}

.record-btn {
    background: var(--gradient);
    color: white;
    padding: 12px 20px;
    border-radius: 12px;
    text-decoration: none;
    font-weight: 500;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    transition: all 0.3s;
}

.record-btn:active {
    transform: scale(0.98);
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
    margin-bottom: 20px;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 16px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
}

.stat-card.week::before { background: #3B82F6; }
.stat-card.month::before { background: #10B981; }
.stat-card.average::before { background: #8B5CF6; }
.stat-card.performance::before { background: #F59E0B; }

.stat-icon {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 12px;
    font-size: 20px;
}

.stat-card.week .stat-icon {
    background: rgba(59,130,246,0.1);
    color: #3B82F6;
}

.stat-card.month .stat-icon {
    background: rgba(16,185,129,0.1);
    color: #10B981;
}

.stat-card.average .stat-icon {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
}

.stat-card.performance .stat-icon {
    background: rgba(245,158,11,0.1);
    color: #F59E0B;
}

.stat-value {
    font-size: 20px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.stat-label {
    font-size: 12px;
    color: var(--gray-500);
    font-weight: 500;
    margin-bottom: 8px;
}

.stat-detail {
    display: flex;
    align-items: center;
}

.detail-badge {
    background: var(--gray-100);
    color: var(--gray-600);
    padding: 2px 6px;
    border-radius: 6px;
    font-size: 10px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 4px;
}

.detail-badge.week {
    background: rgba(59,130,246,0.1);
    color: #3B82F6;
}

.detail-badge.month {
    background: rgba(16,185,129,0.1);
    color: #10B981;
}

.detail-badge.average {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
}

.detail-badge.performance {
    background: rgba(245,158,11,0.1);
    color: #F59E0B;
}

/* Quick Actions */
.quick-actions-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.actions-header {
    margin-bottom: 16px;
}

.actions-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
}

.actions-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 12px;
}

.action-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 16px 8px;
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s;
    background: var(--gray-50);
}

.action-item:active {
    transform: scale(0.95);
}

.action-icon {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 8px;
    font-size: 18px;
}

.action-item.primary .action-icon {
    background: var(--gradient-soft);
    color: var(--primary);
}

.action-item.secondary .action-icon {
    background: rgba(59,130,246,0.1);
    color: #3B82F6;
}

.action-item.tertiary .action-icon {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
}

.action-item.quaternary .action-icon {
    background: rgba(16,185,129,0.1);
    color: #10B981;
}

.action-label {
    font-size: 11px;
    font-weight: 500;
    color: var(--gray-700);
    text-align: center;
}

/* Chart */
.chart-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.chart-header {
    margin-bottom: 16px;
}

.chart-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    display: flex;
    align-items: center;
    gap: 8px;
}

.chart-title i {
    color: var(--primary);
}

.chart-body {
    position: relative;
    height: 200px;
}

/* Records */
.records-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.records-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 16px;
}

.records-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    display: flex;
    align-items: center;
    gap: 8px;
}

.records-title i {
    color: var(--primary);
}

.view-all-btn {
    color: var(--primary);
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 4px;
}

.record-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 0;
    border-bottom: 1px solid var(--gray-100);
}

.record-item:last-child {
    border-bottom: none;
}

.record-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--gradient-soft);
    color: var(--primary);
    font-size: 16px;
    flex-shrink: 0;
}

.record-content {
    flex: 1;
}

.record-title {
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.record-meta {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 12px;
    color: var(--gray-500);
}

.record-parcels {
    background: var(--gray-100);
    padding: 2px 6px;
    border-radius: 4px;
}

.record-amount {
    font-size: 14px;
    font-weight: 600;
    color: var(--primary);
}

.empty-records {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    text-align: center;
    color: var(--gray-400);
}

.empty-records i {
    font-size: 48px;
    margin-bottom: 12px;
}

.empty-records p {
    margin-bottom: 16px;
    color: var(--gray-500);
}

.add-record-btn {
    background: var(--gradient);
    color: white;
    padding: 8px 16px;
    border-radius: 12px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 6px;
}

/* Commission */
.commission-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 100px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.commission-header {
    margin-bottom: 16px;
}

.commission-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    display: flex;
    align-items: center;
    gap: 8px;
}

.commission-title i {
    color: var(--primary);
}

.commission-info {
    margin-bottom: 16px;
}

.info-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 8px 0;
    font-size: 14px;
    color: var(--gray-700);
}

.info-item i {
    color: var(--primary);
    width: 16px;
}

.rates-table {
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid var(--gray-200);
}

.rate-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 16px;
    border-bottom: 1px solid var(--gray-100);
}

.rate-row:last-child {
    border-bottom: none;
}

.rate-row:nth-child(even) {
    background: var(--gray-50);
}

.rate-range {
    font-size: 14px;
    color: var(--gray-700);
    font-weight: 500;
}

.rate-amount {
    font-size: 14px;
    font-weight: 600;
    color: var(--primary);
}

.empty-rates {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    text-align: center;
    color: var(--gray-400);
}

.empty-rates i {
    font-size: 48px;
    margin-bottom: 12px;
}

.empty-rates p {
    color: var(--gray-500);
}

/* Desktop Styles */
@media (min-width: 769px) {
    .welcome-card {
        display: none;
    }
    
    .stats-grid {
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
    }
    
    .actions-grid {
        grid-template-columns: repeat(6, 1fr);
    }
}

@media (max-width: 380px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .actions-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}



.dashboard-card-main {
    position: relative;
    z-index: 2;
}

.dashboard-card-hover {
    position: absolute;
    inset: 0;
    opacity: 0;
    z-index: 1;
    pointer-events: none;
    border-radius: 1.4rem;
}

.dashboard-card:hover {
    box-shadow: 0 12px 42px 0 #FF6B3522;
    transform: translateY(-5px) scale(1.04);
}

.dashboard-card:hover .dashboard-card-hover {
    opacity: 1;
}

.dashboard-card-orange .dashboard-card-hover {
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    opacity: .07;
}

.dashboard-card-green .dashboard-card-hover {
    background: linear-gradient(135deg, #34d399 0%, #10b981 100%);
    opacity: .07;
}

.dashboard-card-blue .dashboard-card-hover {
    background: linear-gradient(135deg, #60a5fa 0%, #2563eb 100%);
    opacity: .07;
}

.dashboard-card-purple .dashboard-card-hover {
    background: linear-gradient(135deg, #a78bfa 0%, #8b5cf6 100%);
    opacity: .07;
}

.dashboard-card-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1.1rem;
}

.dashboard-card-icon {
    width: 56px;
    height: 56px;
    border-radius: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.dashboard-card-icon-orange {
    background: linear-gradient(135deg, #FFEDD5 0%, #FFD5B3 100%);
    color: #FF6B35;
}

.dashboard-card-icon-green {
    background: linear-gradient(135deg, #d1fae5 0%, #34d399 50%);
    color: #10b981;
}

.dashboard-card-icon-blue {
    background: linear-gradient(135deg, #e0f2fe 0%, #60a5fa 100%);
    color: #2563eb;
}

.dashboard-card-icon-purple {
    background: linear-gradient(135deg, #ede9fe 0%, #a78bfa 100%);
    color: #8b5cf6;
}

.dashboard-card-info {
    text-align: right;
}

.dashboard-card-num {
    font-size: 2.4rem;
    font-weight: 700;
    color: #222;
}

.dashboard-card-label {
    color: #555;
    font-size: 1.06rem;
}

.dashboard-card-row2 {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.dashboard-card-status {
    font-size: .96rem;
    color: #666;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: .5rem;
}

.dashboard-card-status-green {
    color: #16a34a;
}

.dashboard-card-status-blue {
    color: #2563eb;
}

.dashboard-card-status-purple {
    color: #8b5cf6;
}

.dashboard-card-link {
    color: #FF6B35;
    font-size: 1rem;
    font-weight: 500;
    transition: color .15s;
}

.dashboard-card-link:hover {
    color: #ea580c;
}

/* Section grids responsive */
.dashboard-section-grid {
    display: grid;
    grid-template-columns: minmax(280px, 350px) 1fr;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.dashboard-section-grid2 {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 1.5rem;
}

/* Hero adjustments */
.dashboard-hero {
    position: relative;
    background: linear-gradient(135deg, #FF6B35, #FF8C61 80%, #EA5C54);
    border-radius: 2rem;
    padding: 2rem;
    color: #fff;
    box-shadow: 0 4px 32px 0 #FF6B3511;
    margin-bottom: 1.5rem;
}

.dashboard-hero-blur {
    position: absolute;
    inset: 0;
    background: #000;
    opacity: 0.08;
    z-index: 1;
    border-radius: 2rem;
}

.dashboard-hero-white1 {
    position: absolute;
    top: -40px;
    right: -40px;
    width: 150px;
    height: 150px;
    background: #fff;
    opacity: 0.13;
    border-radius: 100%;
    z-index: 1;
}

.dashboard-hero-white2 {
    position: absolute;
    left: -28px;
    bottom: -32px;
    width: 100px;
    height: 100px;
    background: #fff;
    opacity: 0.09;
    border-radius: 100%;
    z-index: 1;
}

.dashboard-hero-main {
    position: relative;
    z-index: 3;
}

.dashboard-hero-row {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 2rem;
}

.dashboard-hero-flex {
    display: flex;
    align-items: center;
    margin-bottom: 1.2rem;
}

.dashboard-hero-crown {
    width: 56px;
    height: 56px;
    background: #fff2;
    border-radius: 1.2rem;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
}

.dashboard-hero-crown i {
    font-size: 2rem;
    color: #ffd600;
}

.dashboard-hero-title {
    font-size: 2.2rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
    letter-spacing: -0.02em;
}

.dashboard-hero-desc {
    color: #fffbe7;
    font-size: 1.1rem;
    opacity: .92;
}

.dashboard-hero-date {
    display: flex;
    align-items: center;
    color: #ffdcb1;
    font-size: 1.05rem;
}

.dashboard-hero-date i {
    margin-right: 0.6rem;
}

.dashboard-hero-time {
    text-align: right;
}

.dashboard-hero-time-box {
    background: #fff4;
    backdrop-filter: blur(3px);
    border-radius: 1.5rem;
    padding: 1.7rem 2.2rem;
    border: 1px solid #fff3;
}

.dashboard-hero-time-label {
    font-size: 1rem;
    color: #ffdcb1;
    margin-bottom: .4rem;
}

.dashboard-hero-time-value {
    font-size: 2.2rem;
    font-family: 'Fira Mono', 'Kanit', monospace;
    font-weight: 700;
    letter-spacing: 0.08em;
}

.dashboard-hero-time-desc {
    color: #ffe6c6;
    font-size: 0.85rem;
    margin-top: 0.25rem;
}

/* Additional styles */
.d-flex {
    display: flex;
}

.align-items-center {
    align-items: center;
}

/* Filter Section */
.filter-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 1.5rem 2rem;
    margin-bottom: 2rem;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--medium-gray);
}

.filter-form {
    display: grid;
    grid-template-columns: 1fr 1fr auto;
    gap: 1rem;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-label {
    font-weight: 500;
    color: var(--dark-gray);
    font-size: 0.9rem;
}

.form-control {
    padding: 0.75rem 1rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    font-family: inherit;
    font-size: 0.95rem;
    transition: var(--transition-fast);
    background: var(--white);
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-orange);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: var(--radius-md);
    font-family: inherit;
    font-weight: 500;
    font-size: 0.95rem;
    cursor: pointer;
    transition: var(--transition-fast);
    text-decoration: none;
    white-space: nowrap;
}

.btn-primary {
    background: var(--primary-gradient);
    color: var(--white);
    box-shadow: var(--shadow-sm);
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.modern-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    overflow: visible;
    height: 100%;
}

.modern-card-header {
    padding: 1.25rem;
    border-bottom: 1px solid var(--medium-gray);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modern-card-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.modern-card-body {
    padding: 1.25rem;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

#dailyChart {
    max-height: 280px !important;
}

/* Quick actions compact */
.quick-action-list {
    padding: 1rem;
    display: grid;
    grid-template-columns: 1fr;
    gap: 0.75rem;
}

@media (min-width: 640px) {
    .quick-action-list {
        grid-template-columns: repeat(2, 1fr);
    }
}

/* Language Switcher in Hero */
.language-switcher-hero {
    text-align: right;
}

.language-btn {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 0.75rem;
    font-size: 0.9rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
}

.language-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.5);
    transform: translateY(-1px);
}

.language-btn i {
    font-size: 1rem;
}

/* Mobile Language Button */
.welcome-actions {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.language-form {
    margin: 0;
}

.language-btn-mobile {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.5rem 0.75rem;
    border-radius: 8px;
    font-size: 0.8rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    min-width: 50px;
    justify-content: center;
}

.language-btn-mobile:hover {
    background: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.5);
    transform: scale(1.05);
}

.language-btn-mobile i {
    font-size: 0.9rem;
}



.see-all-link {
    color: var(--primary-orange);
    text-decoration: none;
    font-size: 0.9rem;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    transition: var(--transition-fast);
}

.see-all-link:hover {
    color: var(--primary-dark);
    transform: translateX(2px);
}

.recent-records-list {
    padding: 0.5rem;
}

.recent-record-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    border-bottom: 1px solid var(--medium-gray);
    transition: var(--transition-fast);
}

.recent-record-item:last-child {
    border-bottom: none;
}

.recent-record-item:hover {
    background: var(--light-gray);
}

.recent-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #FFE5D5 0%, #FFD5B3 100%);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary-orange);
    margin-right: 1rem;
}

.recent-info {
    flex: 1;
}

.recent-date {
    font-weight: 600;
    color: var(--dark-gray);
}

.recent-detail {
    font-size: 0.9rem;
    color: var(--gray);
}

.recent-amount {
    font-size: 1.1rem;
    font-weight: 700;
    color: var(--primary-orange);
}

.commission-info {
    padding: 1.5rem;
}

.commission-warehouse,
.commission-vehicle {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 0;
    font-size: 1rem;
    color: var(--dark-gray);
}

.commission-warehouse i,
.commission-vehicle i {
    color: var(--primary-orange);
    width: 20px;
}

.rate-table {
    margin-top: 1rem;
    overflow: hidden;
    border-radius: var(--radius-md);
    border: 1px solid var(--medium-gray);
}

.rate-table table {
    width: 100%;
    border-collapse: collapse;
}

.rate-table th {
    background: var(--light-gray);
    padding: 0.75rem 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--dark-gray);
    font-size: 0.9rem;
}

.rate-table td {
    padding: 0.75rem 1rem;
    border-top: 1px solid var(--medium-gray);
}

.rate-table tr:hover {
    background: var(--light-gray);
}

.rate-amount {
    text-align: right;
    font-weight: 600;
    color: var(--primary-orange);
}




</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Success message
    <?php if(session('success')): ?>
        if (window.Swal) {
            Swal.fire({
                title: 'บันทึกสำเร็จ!',
                text: '<?php echo e(session("success")); ?>',
                icon: 'success',
                confirmButtonColor: '#FF6B35',
                confirmButtonText: 'ตกลง'
            });
        }
    <?php endif; ?>
    // Performance Chart
    const ctx = document.getElementById('performanceChart');
    if (ctx) {
        const chartData = <?php echo json_encode($chartData ?? [], 15, 512) ?>;
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: chartData.labels || ['จันทร์', 'อังคาร', 'พุธ', 'พฤหัส', 'ศุกร์', 'เสาร์', 'อาทิตย์'],
                datasets: [{
                    label: 'จำนวนชิ้น',
                    data: chartData.parcels || [45, 52, 38, 67, 73, 41, 58],
                    borderColor: '#FF6B35',
                    backgroundColor: 'rgba(255, 107, 53, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointRadius: 4,
                    pointHoverRadius: 6
                }, {
                    label: 'คอมมิชชั่น (บาท)',
                    data: chartData.commissions || [1350, 1560, 1140, 2010, 2190, 1230, 1740],
                    borderColor: '#3B82F6',
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    tension: 0.4,
                    fill: true,
                    pointRadius: 4,
                    pointHoverRadius: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: {
                                size: 12,
                                family: 'Kanit'
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        },
                        ticks: {
                            font: {
                                size: 11,
                                family: 'Kanit'
                            }
                        }
                    },
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.05)'
                        },
                        ticks: {
                            font: {
                                size: 11,
                                family: 'Kanit'
                            }
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                }
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/vehicle/dashboard.blade.php ENDPATH**/ ?>