<?php $__env->startSection('title', 'เป้าหมายการออม'); ?>
<?php $__env->startSection('page-title', 'เป้าหมายการออม'); ?>
<?php $__env->startSection('mobile-title', 'เป้าหมายการออม'); ?>

<?php $__env->startSection('content'); ?>
<div class="goals-container">
    <!-- Header Section -->
    <div class="goals-header">
        <div class="header-content">
            <div class="header-left">
                <div class="header-icon">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <div class="header-text">
                    <h1 class="goals-title">เป้าหมายการออม</h1>
                    <p class="goals-subtitle">จัดการและติดตามเป้าหมายการออมเงินของคุณ</p>
                </div>
            </div>
            <div class="header-actions">
                <a href="<?php echo e(route('finance.goals.create')); ?>" class="action-btn primary">
                    <i class="fas fa-plus"></i>
                    <span>สร้างเป้าหมายใหม่</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Summary Stats -->
    <div class="stats-section">
        <div class="stats-grid">
            <div class="stat-card total">
                <div class="stat-icon">
                    <i class="fas fa-bullseye"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e($stats['total_goals'] ?? 0); ?></div>
                    <div class="stat-label">เป้าหมายทั้งหมด</div>
                </div>
            </div>

            <div class="stat-card active">
                <div class="stat-icon">
                    <i class="fas fa-running"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e($stats['active_goals'] ?? 0); ?></div>
                    <div class="stat-label">กำลังดำเนินการ</div>
                </div>
            </div>

            <div class="stat-card completed">
                <div class="stat-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e($stats['completed_goals'] ?? 0); ?></div>
                    <div class="stat-label">สำเร็จแล้ว</div>
                </div>
            </div>

            <div class="stat-card savings">
                <div class="stat-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">฿<?php echo e(number_format($stats['total_saved'] ?? 0, 0)); ?></div>
                    <div class="stat-label">ออมได้แล้ว</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Goals Management -->
    <div class="goals-management">
        <div class="management-header">
            <div class="header-left">
                <h2 class="section-title">
                    <i class="fas fa-list-ul"></i>
                    รายการเป้าหมาย
                </h2>
                <p class="section-subtitle">ติดตามความคืบหน้าเป้าหมายการออมของคุณ</p>
            </div>
            <div class="header-actions">
                <div class="filter-wrapper">
                    <select class="filter-select" onchange="filterGoals(this.value)">
                        <option value="all">ทั้งหมด</option>
                        <option value="active">กำลังดำเนินการ</option>
                        <option value="completed">สำเร็จแล้ว</option>
                        <option value="cancelled">ยกเลิก</option>
                    </select>
                    <i class="fas fa-chevron-down select-icon"></i>
                </div>
            </div>
        </div>

        <div class="goals-grid">
            <?php $__empty_1 = true; $__currentLoopData = $goals ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="goal-card <?php echo e($goal->status ?? 'active'); ?>" data-status="<?php echo e($goal->status ?? 'active'); ?>">
                    <div class="goal-header">
                        <div class="goal-info">
                            <h3 class="goal-name"><?php echo e($goal->goal_name ?? 'เป้าหมายการออม'); ?></h3>
                            <p class="goal-desc"><?php echo e($goal->description ?? 'เป้าหมายการออมเงิน'); ?></p>
                        </div>
                        <div class="goal-menu">
                            <button class="menu-btn" onclick="toggleMenu(<?php echo e($goal->id ?? 1); ?>)">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <div class="menu-dropdown" id="menu-<?php echo e($goal->id ?? 1); ?>">
                                <a href="<?php echo e(route('finance.goals.edit', $goal->id ?? 1)); ?>" class="menu-item">
                                    <i class="fas fa-edit"></i>
                                    <span>แก้ไข</span>
                                </a>
                                <?php if(($goal->status ?? 'active') === 'active'): ?>
                                    <button onclick="showDepositModal(<?php echo e($goal->id ?? 1); ?>, '<?php echo e($goal->goal_name ?? 'เป้าหมาย'); ?>')" class="menu-item">
                                        <i class="fas fa-plus"></i>
                                        <span>เพิ่มเงิน</span>
                                    </button>
                                    <button onclick="showWithdrawModal(<?php echo e($goal->id ?? 1); ?>, '<?php echo e($goal->goal_name ?? 'เป้าหมาย'); ?>')" class="menu-item">
                                        <i class="fas fa-minus"></i>
                                        <span>ถอนเงิน</span>
                                    </button>
                                <?php endif; ?>
                                <button onclick="confirmDelete(<?php echo e($goal->id ?? 1); ?>)" class="menu-item danger">
                                    <i class="fas fa-trash"></i>
                                    <span>ลบ</span>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="goal-amounts">
                        <div class="amount-row">
                            <div class="amount-item current">
                                <span class="amount-label">ออมได้แล้ว</span>
                                <span class="amount-value">฿<?php echo e(number_format($goal->current_amount ?? 0, 0)); ?></span>
                            </div>
                            <div class="amount-item target">
                                <span class="amount-label">เป้าหมาย</span>
                                <span class="amount-value">฿<?php echo e(number_format($goal->target_amount ?? 100000, 0)); ?></span>
                            </div>
                        </div>
                        <div class="remaining-amount">
                            <span class="remaining-label">เหลืออีก</span>
                            <span class="remaining-value">฿<?php echo e(number_format(max(0, ($goal->target_amount ?? 100000) - ($goal->current_amount ?? 0)), 0)); ?></span>
                        </div>
                    </div>

                    <div class="progress-section">
                        <div class="progress-header">
                            <span class="progress-label">ความคืบหน้า</span>
                            <span class="progress-percentage"><?php echo e(number_format($goal->progress_percentage ?? 0, 1)); ?>%</span>
                        </div>
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: <?php echo e(min($goal->progress_percentage ?? 0, 100)); ?>%"></div>
                        </div>
                    </div>

                    <div class="goal-details">
                        <?php if(isset($goal->target_date)): ?>
                            <div class="detail-item">
                                <i class="fas fa-calendar-alt"></i>
                                <span>เป้าหมาย: <?php echo e($goal->target_date->format('d/m/Y')); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if(isset($goal->days_remaining)): ?>
                            <div class="detail-item <?php echo e(($goal->is_overdue ?? false) ? 'overdue' : ''); ?>">
                                <i class="fas fa-clock"></i>
                                <span>
                                    <?php if($goal->is_overdue ?? false): ?>
                                        เกินกำหนด <?php echo e(abs($goal->days_remaining)); ?> วัน
                                    <?php else: ?>
                                        เหลือ <?php echo e($goal->days_remaining); ?> วัน
                                    <?php endif; ?>
                                </span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if(($goal->status ?? 'active') === 'active' && ($goal->suggested_monthly_saving ?? 0) > 0): ?>
                        <div class="suggestion-box">
                            <i class="fas fa-lightbulb"></i>
                            <span>แนะนำออมเดือนละ ฿<?php echo e(number_format($goal->suggested_monthly_saving, 0)); ?></span>
                        </div>
                    <?php endif; ?>

                    <div class="goal-footer">
                        <div class="status-badge <?php echo e($goal->status ?? 'active'); ?>">
                            <?php switch($goal->status ?? 'active'):
                                case ('active'): ?>
                                    <i class="fas fa-play-circle"></i>
                                    กำลังดำเนินการ
                                    <?php break; ?>
                                <?php case ('completed'): ?>
                                    <i class="fas fa-check-circle"></i>
                                    สำเร็จแล้ว
                                    <?php break; ?>
                                <?php case ('cancelled'): ?>
                                    <i class="fas fa-times-circle"></i>
                                    ยกเลิก
                                    <?php break; ?>
                                <?php default: ?>
                                    <i class="fas fa-play-circle"></i>
                                    กำลังดำเนินการ
                            <?php endswitch; ?>
                        </div>
                        <?php if(($goal->status ?? 'active') === 'active'): ?>
                            <button class="quick-add-btn" onclick="showDepositModal(<?php echo e($goal->id ?? 1); ?>, '<?php echo e($goal->goal_name ?? 'เป้าหมาย'); ?>')">
                                <i class="fas fa-plus"></i>
                                เพิ่มเงิน
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="empty-state">
                    <div class="empty-icon">
                        <i class="fas fa-piggy-bank"></i>
                    </div>
                    <h3>ยังไม่มีเป้าหมายการออม</h3>
                    <p>เริ่มต้นสร้างเป้าหมายการออมเงินของคุณวันนี้</p>
                    <a href="<?php echo e(route('finance.goals.create')); ?>" class="action-btn primary">
                        <i class="fas fa-plus"></i>
                        สร้างเป้าหมายแรก
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Tips Section -->
    <div class="tips-section">
        <div class="tips-header">
            <h3 class="tips-title">
                <i class="fas fa-lightbulb"></i>
                เคล็ดลับการออมเงิน
            </h3>
        </div>
        <div class="tips-grid">
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <h4>ออมอย่างสม่ำเสมอ</h4>
                <p>ตั้งเป้าออมเงินเป็นจำนวนคงที่ทุกเดือน แม้จะเป็นจำนวนเล็กน้อยก็ตาม</p>
            </div>
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <h4>เริ่มต้นจากเป้าหมายเล็ก</h4>
                <p>ตั้งเป้าหมายที่สามารถทำได้จริง แล้วค่อยๆ เพิ่มขึ้นเมื่อเกิดความมั่นใจ</p>
            </div>
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-robot"></i>
                </div>
                <h4>ออมแบบอัตโนมัติ</h4>
                <p>ตั้งค่าการโอนเงินอัตโนมัติเข้าบัญชีออมทรัพย์ทุกวันที่ได้รับเงินเดือน</p>
            </div>
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-eye"></i>
                </div>
                <h4>ติดตามความคืบหน้า</h4>
                <p>ตรวจสอบความคืบหน้าเป้าหมายการออมอย่างสม่ำเสมอเพื่อให้มีแรงจูงใจ</p>
            </div>
        </div>
    </div>
</div>

<!-- Deposit Modal -->
<div class="modal" id="depositModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>เพิ่มเงินออม</h3>
            <button class="modal-close" onclick="closeDepositModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="depositForm" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="goal-info-display" id="goalInfoDisplay"></div>
                <div class="form-group">
                    <label>จำนวนเงิน (บาท)</label>
                    <div class="input-wrapper">
                        <span class="input-prefix">฿</span>
                        <input type="number" name="amount" class="form-control" placeholder="0" step="1" min="1" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>หมายเหตุ</label>
                    <input type="text" name="note" class="form-control" placeholder="เช่น โบนัสเดือนนี้">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="action-btn secondary" onclick="closeDepositModal()">ยกเลิก</button>
                <button type="submit" class="action-btn primary">
                    <i class="fas fa-save"></i>
                    บันทึก
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Withdraw Modal -->
<div class="modal" id="withdrawModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>ถอนเงินออม</h3>
            <button class="modal-close" onclick="closeWithdrawModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="withdrawForm" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="goal-info-display" id="goalInfoDisplayWithdraw"></div>
                <div class="form-group">
                    <label>จำนวนเงิน (บาท)</label>
                    <div class="input-wrapper">
                        <span class="input-prefix">฿</span>
                        <input type="number" name="amount" class="form-control" placeholder="0" step="1" min="1" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>เหตุผล</label>
                    <input type="text" name="note" class="form-control" placeholder="เช่น ค่าใช้จ่ายฉุกเฉิน" required>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="action-btn secondary" onclick="closeWithdrawModal()">ยกเลิก</button>
                <button type="submit" class="action-btn danger">
                    <i class="fas fa-minus"></i>
                    ถอนเงิน
                </button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Container */
.goals-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    min-height: calc(100vh - 140px);
}

/* Header */
.goals-header {
    background: var(--gradient);
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 24px;
    color: white;
    box-shadow: 0 8px 32px rgba(255, 107, 53, 0.2);
    position: relative;
    overflow: hidden;
}

.goals-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 300px;
    height: 300px;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
    border-radius: 50%;
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 24px;
    position: relative;
    z-index: 2;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 20px;
}

.header-icon {
    width: 64px;
    height: 64px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    backdrop-filter: blur(10px);
}

.goals-title {
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 4px;
}

.goals-subtitle {
    font-size: 16px;
    opacity: 0.9;
}

/* Stats Section */
.stats-section {
    margin-bottom: 32px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.stat-card {
    background: white;
    border-radius: 20px;
    padding: 24px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
    gap: 16px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
}

.stat-card.total::before { background: #3B82F6; }
.stat-card.active::before { background: #10B981; }
.stat-card.completed::before { background: #8B5CF6; }
.stat-card.savings::before { background: #F59E0B; }

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
}

.stat-icon {
    width: 56px;
    height: 56px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
}

.stat-card.total .stat-icon { background: linear-gradient(135deg, #3B82F6, #1D4ED8); }
.stat-card.active .stat-icon { background: linear-gradient(135deg, #10B981, #059669); }
.stat-card.completed .stat-icon { background: linear-gradient(135deg, #8B5CF6, #7C3AED); }
.stat-card.savings .stat-icon { background: linear-gradient(135deg, #F59E0B, #D97706); }

.stat-value {
    font-size: 24px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    color: var(--gray-500);
    font-weight: 500;
}

/* Goals Management */
.goals-management {
    background: white;
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 32px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
}

.management-header {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    margin-bottom: 32px;
    gap: 24px;
}

.section-title {
    font-size: 24px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.section-title i {
    color: var(--primary);
}

.section-subtitle {
    font-size: 14px;
    color: var(--gray-500);
}

.filter-wrapper {
    position: relative;
}

.filter-select {
    background: var(--gray-50);
    border: 2px solid var(--gray-200);
    color: var(--gray-700);
    padding: 12px 40px 12px 16px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    appearance: none;
    min-width: 150px;
}

.filter-select:focus {
    outline: none;
    border-color: var(--primary);
}

.select-icon {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    pointer-events: none;
    font-size: 12px;
    color: var(--gray-500);
}

/* Goals Grid */
.goals-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(380px, 1fr));
    gap: 24px;
}

.goal-card {
    background: white;
    border: 2px solid var(--gray-100);
    border-radius: 20px;
    padding: 24px;
    transition: all 0.3s ease;
    position: relative;
}

.goal-card:hover {
    border-color: var(--primary);
    box-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
    transform: translateY(-2px);
}

.goal-card.active { border-color: #10B981; }
.goal-card.completed { 
    border-color: #8B5CF6;
    background: linear-gradient(135deg, #F3E8FF 0%, #FFFFFF 100%);
}
.goal-card.cancelled { 
    opacity: 0.7;
    border-color: var(--gray-300);
}

.goal-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
}

.goal-name {
    font-size: 18px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.goal-desc {
    font-size: 14px;
    color: var(--gray-500);
}

.goal-menu {
    position: relative;
}

.menu-btn {
    width: 32px;
    height: 32px;
    border: none;
    background: var(--gray-100);
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--gray-500);
    transition: all 0.3s ease;
}

.menu-btn:hover {
    background: var(--gray-200);
}

.menu-dropdown {
    position: absolute;
    top: 100%;
    right: 0;
    background: white;
    border: 1px solid var(--gray-200);
    border-radius: 12px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    padding: 8px;
    min-width: 160px;
    z-index: 10;
    display: none;
}

.menu-dropdown.active {
    display: block;
}

.menu-item {
    width: 100%;
    padding: 8px 12px;
    border: none;
    background: none;
    text-align: left;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
    color: var(--gray-700);
    display: flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.menu-item:hover {
    background: var(--gray-50);
}

.menu-item.danger {
    color: #EF4444;
}

.menu-item.danger:hover {
    background: #FEF2F2;
}

/* Goal Amounts */
.goal-amounts {
    background: var(--gray-50);
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
}

.amount-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 12px;
}

.amount-item {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.amount-label {
    font-size: 12px;
    color: var(--gray-500);
    font-weight: 500;
}

.amount-value {
    font-size: 18px;
    font-weight: 700;
}

.amount-item.current .amount-value {
    color: #10B981;
}

.amount-item.target .amount-value {
    color: var(--gray-700);
}

.remaining-amount {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    border-top: 1px solid var(--gray-200);
}

.remaining-label {
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.remaining-value {
    font-size: 16px;
    font-weight: 700;
    color: var(--primary);
}

/* Progress Section */
.progress-section {
    margin-bottom: 20px;
}

.progress-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.progress-label {
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.progress-percentage {
    font-size: 14px;
    font-weight: 700;
    color: var(--gray-900);
}

.progress-bar {
    height: 10px;
    background: var(--gray-200);
    border-radius: 5px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #10B981, #34D399);
    border-radius: 5px;
    transition: width 0.5s ease;
}

/* Goal Details */
.goal-details {
    display: flex;
    gap: 16px;
    margin-bottom: 16px;
    flex-wrap: wrap;
}

.detail-item {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
    color: var(--gray-600);
}

.detail-item.overdue {
    color: #EF4444;
}

/* Suggestion Box */
.suggestion-box {
    background: #EFF6FF;
    border: 1px solid #DBEAFE;
    border-radius: 12px;
    padding: 12px 16px;
    font-size: 14px;
    color: #1E40AF;
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 16px;
}

/* Goal Footer */
.goal-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.status-badge {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
}

.status-badge.active {
    background: #D1FAE5;
    color: #065F46;
}

.status-badge.completed {
    background: #EDE9FE;
    color: #5B21B6;
}

.status-badge.cancelled {
    background: #FEE2E2;
    color: #991B1B;
}

.quick-add-btn {
    background: var(--gradient-soft);
    color: var(--primary);
    border: none;
    padding: 8px 16px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 6px;
    transition: all 0.3s ease;
}

.quick-add-btn:hover {
    background: var(--gradient);
    color: white;
    transform: translateY(-1px);
}

/* Empty State */
.empty-state {
    grid-column: 1 / -1;
    text-align: center;
    padding: 60px 20px;
    color: var(--gray-500);
}

.empty-icon {
    width: 80px;
    height: 80px;
    background: var(--gradient-soft);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    color: var(--primary);
    margin: 0 auto 20px;
}

.empty-state h3 {
    font-size: 20px;
    font-weight: 600;
    color: var(--gray-700);
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 14px;
    margin-bottom: 24px;
}

/* Tips Section */
.tips-section {
    background: var(--gray-50);
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 32px;
}

.tips-title {
    font-size: 20px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.tips-title i {
    color: #F59E0B;
}

.tips-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;
}

.tip-card {
    background: white;
    border-radius: 16px;
    padding: 24px;
    text-align: center;
    border: 1px solid var(--gray-200);
    transition: all 0.3s ease;
}

.tip-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.tip-icon {
    width: 56px;
    height: 56px;
    background: var(--gradient-soft);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: var(--primary);
    margin: 0 auto 16px;
}

.tip-card h4 {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 8px;
}

.tip-card p {
    font-size: 14px;
    color: var(--gray-600);
    line-height: 1.5;
}

/* Modal */
.modal {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    padding: 20px;
}

.modal.active {
    display: flex;
}

.modal-content {
    background: white;
    border-radius: 20px;
    width: 100%;
    max-width: 500px;
    max-height: 90vh;
    overflow-y: auto;
}

.modal-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 24px 24px 0;
    margin-bottom: 24px;
}

.modal-header h3 {
    font-size: 20px;
    font-weight: 600;
    color: var(--gray-900);
}

.modal-close {
    width: 32px;
    height: 32px;
    border: none;
    background: var(--gray-100);
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--gray-500);
}

.modal-body {
    padding: 0 24px;
}

.goal-info-display {
    background: var(--gray-50);
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
    font-weight: 600;
    color: var(--gray-700);
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-700);
    margin-bottom: 8px;
}

.input-wrapper {
    position: relative;
}

.input-prefix {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray-500);
    font-weight: 600;
    z-index: 1;
}

.form-control {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid var(--gray-200);
    border-radius: 12px;
    font-size: 14px;
}

.input-wrapper .form-control {
    padding-left: 40px;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
}

.modal-footer {
    display: flex;
    gap: 12px;
    padding: 24px;
    border-top: 1px solid var(--gray-200);
}

/* Action Buttons */
.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    justify-content: center;
    flex: 1;
}

.action-btn.primary {
    background: var(--gradient);
    color: white;
}

.action-btn.primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.3);
}

.action-btn.secondary {
    background: var(--gray-100);
    color: var(--gray-700);
}

.action-btn.secondary:hover {
    background: var(--gray-200);
}

.action-btn.danger {
    background: #EF4444;
    color: white;
}

.action-btn.danger:hover {
    background: #DC2626;
    transform: translateY(-2px);
}

/* Responsive */
@media (max-width: 768px) {
    .goals-container {
        padding: 16px;
    }

    .goals-header {
        padding: 24px;
    }

    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 20px;
    }

    .header-actions {
        width: 100%;
    }

    .action-btn {
        width: 100%;
        justify-content: center;
    }

    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 16px;
    }

    .goals-management {
        padding: 24px;
    }

    .management-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }

    .goals-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }

    .tips-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }

    .modal-footer {
        flex-direction: column;
    }
}

@media (max-width: 480px) {
    .header-left {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }

    .header-icon {
        width: 48px;
        height: 48px;
        font-size: 20px;
    }

    .goals-title {
        font-size: 24px;
    }

    .stats-grid {
        grid-template-columns: 1fr;
    }

    .amount-row {
        flex-direction: column;
        gap: 12px;
    }

    .goal-footer {
        flex-direction: column;
        gap: 12px;
        align-items: stretch;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Menu Functions
function toggleMenu(goalId) {
    const menu = document.getElementById(`menu-${goalId}`);
    document.querySelectorAll('.menu-dropdown').forEach(m => {
        if (m.id !== `menu-${goalId}`) {
            m.classList.remove('active');
        }
    });
    menu.classList.toggle('active');
}

document.addEventListener('click', function(e) {
    if (!e.target.closest('.goal-menu')) {
        document.querySelectorAll('.menu-dropdown').forEach(m => {
            m.classList.remove('active');
        });
    }
});

// Filter Goals
function filterGoals(status) {
    const cards = document.querySelectorAll('.goal-card');
    cards.forEach(card => {
        if (status === 'all' || card.dataset.status === status) {
            card.style.display = 'block';
        } else {
            card.style.display = 'none';
        }
    });
}

// Deposit Modal
function showDepositModal(goalId, goalName) {
    const modal = document.getElementById('depositModal');
    const form = document.getElementById('depositForm');
    const display = document.getElementById('goalInfoDisplay');
    
    form.action = `/finance/goals/${goalId}/deposit`;
    display.textContent = `เป้าหมาย: ${goalName}`;
    modal.classList.add('active');
    
    document.querySelectorAll('.menu-dropdown').forEach(m => {
        m.classList.remove('active');
    });
}

function closeDepositModal() {
    const modal = document.getElementById('depositModal');
    const form = document.getElementById('depositForm');
    modal.classList.remove('active');
    form.reset();
}

// Withdraw Modal
function showWithdrawModal(goalId, goalName) {
    const modal = document.getElementById('withdrawModal');
    const form = document.getElementById('withdrawForm');
    const display = document.getElementById('goalInfoDisplayWithdraw');
    
    form.action = `/finance/goals/${goalId}/withdraw`;
    display.textContent = `เป้าหมาย: ${goalName}`;
    modal.classList.add('active');
    
    document.querySelectorAll('.menu-dropdown').forEach(m => {
        m.classList.remove('active');
    });
}

function closeWithdrawModal() {
    const modal = document.getElementById('withdrawModal');
    const form = document.getElementById('withdrawForm');
    modal.classList.remove('active');
    form.reset();
}

// Delete Confirmation
function confirmDelete(goalId) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบเป้าหมายนี้ใช่หรือไม่?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#EF4444',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/finance/goals/${goalId}`;
            
            const methodInput = document.createElement('input');
            methodInput.type = 'hidden';
            methodInput.name = '_method';
            methodInput.value = 'DELETE';
            
            const tokenInput = document.createElement('input');
            tokenInput.type = 'hidden';
            tokenInput.name = '_token';
            tokenInput.value = '<?php echo e(csrf_token()); ?>';
            
            form.appendChild(methodInput);
            form.appendChild(tokenInput);
            document.body.appendChild(form);
            form.submit();
        }
    });
    
    document.querySelectorAll('.menu-dropdown').forEach(m => {
        m.classList.remove('active');
    });
}

// Form Submissions
document.getElementById('depositForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('button[type="submit"]');
    
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังบันทึก...';
    
    fetch(this.action, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ!',
                text: 'เพิ่มเงินออมเรียบร้อยแล้ว',
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        } else {
            throw new Error(data.message || 'เกิดข้อผิดพลาด');
        }
    })
    .catch(error => {
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด!',
            text: error.message || 'ไม่สามารถบันทึกได้',
            confirmButtonColor: '#FF6B35'
        });
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-save"></i> บันทึก';
    });
});

document.getElementById('withdrawForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('button[type="submit"]');
    
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังถอน...';
    
    fetch(this.action, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ!',
                text: 'ถอนเงินออมเรียบร้อยแล้ว',
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        } else {
            throw new Error(data.message || 'เกิดข้อผิดพลาด');
        }
    })
    .catch(error => {
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด!',
            text: error.message || 'ไม่สามารถถอนเงินได้',
            confirmButtonColor: '#FF6B35'
        });
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-minus"></i> ถอนเงิน';
    });
});

// Close modals on outside click
document.getElementById('depositModal').addEventListener('click', function(e) {
    if (e.target === this) closeDepositModal();
});

document.getElementById('withdrawModal').addEventListener('click', function(e) {
    if (e.target === this) closeWithdrawModal();
});

// Session Messages
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '<?php echo e(session('success')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'เกิดข้อผิดพลาด!',
        text: '<?php echo e(session('error')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/finance/goals/index.blade.php ENDPATH**/ ?>