<?php $__env->startSection('title', 'รายงานค่าคอมมิชชั่น - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="commission-reports-container">
    <!-- Header Card -->
    <div class="header-card">
        <div class="header-content">
            <div class="header-info">
                <div class="header-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="header-text">
                    <h1 class="header-title">รายงานค่าคอมมิชชั่น</h1>
                    <p class="header-subtitle">การวิเคราะห์ค่าคอมมิชชั่น รายได้ และการกระจายตามระดับ</p>
                </div>
            </div>
            <div class="header-actions">
                <button onclick="exportReport()" class="btn btn-primary">
                    <i class="fas fa-download"></i>
                    <span>ส่งออกรายงาน</span>
                </button>
                <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    <span>กลับ</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="filters-card">
        <div class="filters-header">
            <h3 class="filters-title">
                <i class="fas fa-filter"></i>
                ตัวกรองข้อมูล
            </h3>
            <button onclick="resetFilters()" class="btn-reset">
                <i class="fas fa-undo"></i>
                รีเซ็ต
            </button>
        </div>
        <form method="GET" action="<?php echo e(route('admin.reports.commission')); ?>" class="filters-form">
            <div class="filters-grid">
                <div class="filter-group">
                    <label>วันที่เริ่มต้น</label>
                    <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="filter-input">
                </div>
                <div class="filter-group">
                    <label>วันที่สิ้นสุด</label>
                    <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="filter-input">
                </div>
                <div class="filter-group">
                    <label>คลังสินค้า</label>
                    <select name="warehouse" class="filter-select">
                        <option value="">ทั้งหมด</option>
                        <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($warehouse->code); ?>" <?php echo e($warehouseCode == $warehouse->code ? 'selected' : ''); ?>>
                                <?php echo e($warehouse->code); ?> - <?php echo e($warehouse->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="filter-group">
                    <label>ประเภทรถ</label>
                    <select name="vehicle_type" class="filter-select">
                        <option value="">ทั้งหมด</option>
                        <option value="2wheel" <?php echo e($vehicleType == '2wheel' ? 'selected' : ''); ?>>รถ 2 ล้อ</option>
                        <option value="4wheel" <?php echo e($vehicleType == '4wheel' ? 'selected' : ''); ?>>รถ 4 ล้อ</option>
                    </select>
                </div>
                <div class="filter-actions">
                    <button type="submit" class="btn-filter">
                        <i class="fas fa-search"></i>
                        ค้นหา
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card green">
            <div class="stat-icon">
                <i class="fas fa-coins"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿<?php echo e(number_format($stats['total_commission'], 2)); ?></div>
                <div class="stat-label">ค่าคอมมิชชั่นรวม</div>
            </div>
        </div>

        <div class="stat-card blue">
            <div class="stat-icon">
                <i class="fas fa-boxes"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($stats['total_parcels'])); ?></div>
                <div class="stat-label">จำนวนพัสดุทั้งหมด</div>
            </div>
        </div>

        <div class="stat-card orange">
            <div class="stat-icon">
                <i class="fas fa-calculator"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿<?php echo e(number_format($stats['avg_commission_per_parcel'], 2)); ?></div>
                <div class="stat-label">เฉลี่ยต่อพัสดุ</div>
            </div>
        </div>

        <div class="stat-card purple">
            <div class="stat-icon">
                <i class="fas fa-user-tie"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿<?php echo e(number_format($stats['avg_commission_per_user'], 2)); ?></div>
                <div class="stat-label">เฉลี่ยต่อพนักงาน</div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="charts-section">
        <div class="chart-card">
            <div class="chart-header">
                <h3 class="chart-title">
                    <i class="fas fa-chart-line"></i>
                    แนวโน้มค่าคอมมิชชั่น 12 เดือน
                </h3>
            </div>
            <div class="chart-container">
                <canvas id="monthlyTrendChart"></canvas>
            </div>
        </div>

        <div class="chart-card">
            <div class="chart-header">
                <h3 class="chart-title">
                    <i class="fas fa-chart-pie"></i>
                    การกระจายตาม Tier
                </h3>
            </div>
            <div class="chart-container">
                <canvas id="tierChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Top Earners -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon green">
                <i class="fas fa-trophy"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">พนักงานรายได้สูงสุด</h2>
                <p class="section-subtitle">20 อันดับแรกที่มีค่าคอมมิชชั่นสูงสุด</p>
            </div>
        </div>

        <div class="earners-grid">
            <?php $__currentLoopData = $topEarners->take(20); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $earner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="earner-card <?php echo e($index < 3 ? 'top-' . ($index + 1) : ''); ?>">
                    <div class="earner-rank">
                        <?php if($index < 3): ?>
                            <i class="fas fa-medal"></i>
                        <?php endif; ?>
                        #<?php echo e($index + 1); ?>

                    </div>
                    <div class="earner-info">
                        <h4 class="earner-name"><?php echo e($earner->user->name ?? 'N/A'); ?></h4>
                        <p class="earner-warehouse"><?php echo e($earner->user->warehouse_code ?? 'N/A'); ?></p>
                        <span class="earner-vehicle <?php echo e($earner->user->role ?? ''); ?>">
                            <?php echo e($earner->user->role == '2wheel' ? 'รถ 2 ล้อ' : 'รถ 4 ล้อ'); ?>

                        </span>
                    </div>
                    <div class="earner-stats">
                        <div class="earner-stat primary">
                            <span class="stat-number">฿<?php echo e(number_format($earner->total_commission, 0)); ?></span>
                            <span class="stat-text">คอมมิชชั่น</span>
                        </div>
                        <div class="earner-stat secondary">
                            <span class="stat-number"><?php echo e(number_format($earner->total_parcels)); ?></span>
                            <span class="stat-text">พัสดุ</span>
                        </div>
                        <div class="earner-stat tertiary">
                            <span class="stat-number"><?php echo e(number_format($earner->delivery_count)); ?></span>
                            <span class="stat-text">ครั้ง</span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Warehouse Commission -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon blue">
                <i class="fas fa-warehouse"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">ค่าคอมมิชชั่นตามคลังสินค้า</h2>
                <p class="section-subtitle">เปรียบเทียบประสิทธิภาพแต่ละคลัง</p>
            </div>
        </div>

        <div class="warehouse-grid">
            <?php $__currentLoopData = $warehouseCommission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="warehouse-card">
                    <div class="warehouse-header">
                        <div class="warehouse-code"><?php echo e($warehouse->code); ?></div>
                        <div class="warehouse-name"><?php echo e($warehouse->name); ?></div>
                    </div>
                    <div class="warehouse-stats">
                        <div class="warehouse-stat">
                            <div class="stat-value">฿<?php echo e(number_format($warehouse->total_commission, 0)); ?></div>
                            <div class="stat-label">ค่าคอมมิชชั่น</div>
                        </div>
                        <div class="warehouse-stat">
                            <div class="stat-value"><?php echo e(number_format($warehouse->total_parcels)); ?></div>
                            <div class="stat-label">จำนวนพัสดุ</div>
                        </div>
                        <div class="warehouse-stat">
                            <div class="stat-value"><?php echo e(number_format($warehouse->user_count)); ?></div>
                            <div class="stat-label">พนักงาน</div>
                        </div>
                    </div>
                    <div class="warehouse-avg">
                        <span class="avg-label">เฉลี่ยต่อพนักงาน:</span>
                        <span class="avg-value">฿<?php echo e(number_format($warehouse->user_count > 0 ? $warehouse->total_commission / $warehouse->user_count : 0, 0)); ?></span>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Tier Analysis -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon purple">
                <i class="fas fa-layer-group"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">การวิเคราะห์ตาม Tier</h2>
                <p class="section-subtitle">การกระจายค่าคอมมิชชั่นตามช่วงจำนวนพัสดุ</p>
            </div>
        </div>

        <div class="tier-grid">
            <?php $__currentLoopData = $tierAnalysis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tier-card">
                    <div class="tier-header">
                        <h4 class="tier-name"><?php echo e($tier->tier); ?></h4>
                        <div class="tier-count"><?php echo e(number_format($tier->count)); ?> ครั้ง</div>
                    </div>
                    <div class="tier-stats">
                        <div class="tier-stat">
                            <span class="stat-label">พัสดุรวม</span>
                            <span class="stat-value"><?php echo e(number_format($tier->total_parcels)); ?></span>
                        </div>
                        <div class="tier-stat">
                            <span class="stat-label">คอมมิชชั่น</span>
                            <span class="stat-value">฿<?php echo e(number_format($tier->total_commission, 0)); ?></span>
                        </div>
                        <div class="tier-stat">
                            <span class="stat-label">เฉลี่ยต่อครั้ง</span>
                            <span class="stat-value">฿<?php echo e(number_format($tier->count > 0 ? $tier->total_commission / $tier->count : 0, 0)); ?></span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Container */
.commission-reports-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 50%, #cbd5e1 100%);
    padding: 2rem;
}

/* Header Card */
.header-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.header-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.header-icon {
    width: 64px;
    height: 64px;
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
    box-shadow: 0 10px 25px rgba(16, 185, 129, 0.3);
}

.header-title {
    font-size: 2rem;
    font-weight: 700;
    background: linear-gradient(135deg, #1f2937 0%, #6b7280 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin: 0 0 0.5rem 0;
}

.header-subtitle {
    color: #6b7280;
    margin: 0;
    font-size: 1rem;
}

.header-actions {
    display: flex;
    gap: 0.75rem;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-weight: 500;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
    box-shadow: 0 10px 25px rgba(16, 185, 129, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 35px rgba(16, 185, 129, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.9);
    color: #374151;
    border: 1px solid #e5e7eb;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

/* Filters Card */
.filters-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.filters-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.filters-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.btn-reset {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: #f3f4f6;
    color: #6b7280;
    border: none;
    border-radius: 8px;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-reset:hover {
    background: #e5e7eb;
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-group label {
    font-weight: 500;
    color: #374151;
    font-size: 0.875rem;
}

.filter-input, .filter-select {
    padding: 0.75rem;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    font-size: 0.875rem;
    transition: border-color 0.3s ease;
}

.filter-input:focus, .filter-select:focus {
    outline: none;
    border-color: #10B981;
}

.btn-filter {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
    border: none;
    border-radius: 8px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-filter:hover {
    transform: translateY(-1px);
    box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 16px;
    padding: 2rem;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
    position: relative;
    overflow: hidden;
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
}

.stat-card.green {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
}

.stat-card.blue {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
}

.stat-card.orange {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    color: white;
}

.stat-card.purple {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
    color: white;
}

.stat-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-bottom: 1rem;
}

.stat-value {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.stat-label {
    font-size: 0.875rem;
    opacity: 0.9;
}

/* Charts Section */
.charts-section {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 2rem;
    margin-bottom: 2rem;
}

.chart-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
}

.chart-header {
    margin-bottom: 1.5rem;
}

.chart-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.chart-container {
    height: 300px;
    position: relative;
}

/* Section Cards */
.section-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.section-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.section-icon.green {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
}

.section-icon.blue {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.section-icon.purple {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
}

.section-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.section-subtitle {
    color: #6b7280;
    font-size: 0.9rem;
    margin: 0.25rem 0 0 0;
}

/* Earners Grid */
.earners-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 1.5rem;
}

.earner-card {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 1.5rem;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.earner-card:hover {
    background: white;
    border-color: #10B981;
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.earner-card.top-1 {
    background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
    color: white;
}

.earner-card.top-2 {
    background: linear-gradient(135deg, #C0C0C0 0%, #A9A9A9 100%);
    color: white;
}

.earner-card.top-3 {
    background: linear-gradient(135deg, #CD7F32 0%, #B8860B 100%);
    color: white;
}

.earner-rank {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.earner-name {
    font-size: 1.1rem;
    font-weight: 600;
    margin: 0 0 0.25rem 0;
}

.earner-warehouse {
    font-size: 0.875rem;
    opacity: 0.8;
    margin: 0 0 0.5rem 0;
}

.earner-vehicle {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 500;
}

.earner-vehicle.2wheel {
    background: rgba(139, 92, 246, 0.2);
    color: #7c3aed;
}

.earner-vehicle.4wheel {
    background: rgba(16, 185, 129, 0.2);
    color: #059669;
}

.earner-card.top-1 .earner-vehicle,
.earner-card.top-2 .earner-vehicle,
.earner-card.top-3 .earner-vehicle {
    background: rgba(255, 255, 255, 0.3);
    color: white;
}

.earner-stats {
    display: flex;
    gap: 1rem;
    margin-top: 1rem;
}

.earner-stat {
    display: flex;
    flex-direction: column;
    align-items: center;
    flex: 1;
}

.earner-stat .stat-number {
    font-size: 1.1rem;
    font-weight: 700;
}

.earner-stat .stat-text {
    font-size: 0.75rem;
    opacity: 0.8;
}

/* Warehouse Grid */
.warehouse-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.warehouse-card {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 1.5rem;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.warehouse-card:hover {
    background: white;
    border-color: #3B82F6;
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.warehouse-header {
    margin-bottom: 1rem;
}

.warehouse-code {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

.warehouse-name {
    font-size: 0.875rem;
    color: #6b7280;
}

.warehouse-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    margin-bottom: 1rem;
}

.warehouse-stat {
    text-align: center;
}

.warehouse-stat .stat-value {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1f2937;
}

.warehouse-stat .stat-label {
    font-size: 0.75rem;
    color: #6b7280;
}

.warehouse-avg {
    padding-top: 1rem;
    border-top: 1px solid #e5e7eb;
    text-align: center;
}

.avg-label {
    font-size: 0.875rem;
    color: #6b7280;
}

.avg-value {
    font-weight: 600;
    color: #10B981;
}

/* Tier Grid */
.tier-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
}

.tier-card {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 1.5rem;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.tier-card:hover {
    background: white;
    border-color: #8B5CF6;
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.tier-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.tier-name {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.tier-count {
    font-size: 0.875rem;
    color: #6b7280;
    background: #e5e7eb;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
}

.tier-stats {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.tier-stat {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.tier-stat .stat-label {
    font-size: 0.875rem;
    color: #6b7280;
}

.tier-stat .stat-value {
    font-weight: 600;
    color: #1f2937;
}

/* Responsive */
@media (max-width: 768px) {
    .commission-reports-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .header-actions {
        width: 100%;
        justify-content: stretch;
    }
    
    .btn {
        flex: 1;
        justify-content: center;
    }
    
    .filters-grid {
        grid-template-columns: 1fr;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .charts-section {
        grid-template-columns: 1fr;
    }
    
    .earners-grid {
        grid-template-columns: 1fr;
    }
    
    .warehouse-grid {
        grid-template-columns: 1fr;
    }
    
    .tier-grid {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Monthly Trend Chart
const monthlyTrendCtx = document.getElementById('monthlyTrendChart').getContext('2d');
const monthlyTrendChart = new Chart(monthlyTrendCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode(collect($monthlyTrend)->pluck('month')); ?>,
        datasets: [{
            label: 'ค่าคอมมิชชั่น (บาท)',
            data: <?php echo json_encode(collect($monthlyTrend)->pluck('commission')); ?>,
            borderColor: '#10B981',
            backgroundColor: 'rgba(16, 185, 129, 0.1)',
            tension: 0.4,
            fill: true
        }, {
            label: 'จำนวนพัสดุ',
            data: <?php echo json_encode(collect($monthlyTrend)->pluck('parcels')); ?>,
            borderColor: '#3B82F6',
            backgroundColor: 'rgba(59, 130, 246, 0.1)',
            tension: 0.4,
            fill: true,
            yAxisID: 'y1'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'top',
            }
        },
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                grid: {
                    drawOnChartArea: false,
                },
            }
        }
    }
});

// Tier Analysis Chart
const tierCtx = document.getElementById('tierChart').getContext('2d');
const tierChart = new Chart(tierCtx, {
    type: 'doughnut',
    data: {
        labels: <?php echo json_encode($tierAnalysis->pluck('tier')); ?>,
        datasets: [{
            data: <?php echo json_encode($tierAnalysis->pluck('total_commission')); ?>,
            backgroundColor: [
                '#10B981',
                '#3B82F6',
                '#8B5CF6',
                '#F59E0B',
                '#EF4444'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
            }
        }
    }
});

function exportReport() {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route("admin.reports.commission.export")); ?>';
    
    // Add CSRF token
    const csrfToken = document.createElement('input');
    csrfToken.type = 'hidden';
    csrfToken.name = '_token';
    csrfToken.value = '<?php echo e(csrf_token()); ?>';
    form.appendChild(csrfToken);
    
    // Add current filters
    const params = new URLSearchParams(window.location.search);
    params.forEach((value, key) => {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = key;
        input.value = value;
        form.appendChild(input);
    });
    
    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}

function resetFilters() {
    window.location.href = '<?php echo e(route("admin.reports.commission")); ?>';
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/reports/commission.blade.php ENDPATH**/ ?>