<?php
/**
 * I18n Build Check Script
 * 
 * This script runs during build process to ensure all translations are complete.
 * It will fail the build if there are missing translation keys.
 */

require_once __DIR__ . '/../vendor/autoload.php';

use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Artisan;

// Bootstrap Laravel application
$app = new Application(realpath(__DIR__ . '/../'));
$app->singleton(
    Illuminate\Contracts\Http\Kernel::class,
    App\Http\Kernel::class
);
$app->singleton(
    Illuminate\Contracts\Console\Kernel::class,
    App\Console\Kernel::class
);
$app->singleton(
    Illuminate\Contracts\Debug\ExceptionHandler::class,
    App\Exceptions\Handler::class
);

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "🌐 Checking i18n translations...\n";

// Run translation check in strict mode
$exitCode = Artisan::call('i18n:check', ['--strict' => true]);

if ($exitCode === 0) {
    echo "✅ All translations are complete!\n";
    exit(0);
} else {
    echo "❌ Translation check failed. Missing keys found.\n";
    echo "Run 'php artisan i18n:check --fix' to auto-generate missing keys.\n";
    exit(1);
}