@if ($paginator->hasPages())
<nav class="pagination-nav" aria-label="Page navigation">
    <ul class="pagination-list" style="display: flex; gap: 0.4rem; list-style: none; padding:0; margin:0;">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <li class="pagination-item disabled"><span style="padding:0.4em 1em; border-radius:8px; background:#eee; color:#ccc;">&laquo;</span></li>
        @else
            <li class="pagination-item">
                <a href="{{ $paginator->previousPageUrl() }}" rel="prev" style="padding:0.4em 1em; border-radius:8px; background:#f9f9f9; color:#FF6B35; text-decoration:none;">&laquo;</a>
            </li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <li class="pagination-item disabled"><span style="padding:0.4em 1em; border-radius:8px; color:#ccc;">{{ $element }}</span></li>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li class="pagination-item active"><span style="padding:0.4em 1em; border-radius:8px; background:var(--primary-orange); color:#fff; font-weight:600;">{{ $page }}</span></li>
                    @else
                        <li class="pagination-item"><a href="{{ $url }}" style="padding:0.4em 1em; border-radius:8px; background:#fff; color:#FF6B35; border:1px solid #FFD5B3; text-decoration:none;">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <li class="pagination-item">
                <a href="{{ $paginator->nextPageUrl() }}" rel="next" style="padding:0.4em 1em; border-radius:8px; background:#f9f9f9; color:#FF6B35; text-decoration:none;">&raquo;</a>
            </li>
        @else
            <li class="pagination-item disabled"><span style="padding:0.4em 1em; border-radius:8px; background:#eee; color:#ccc;">&raquo;</span></li>
        @endif
    </ul>
</nav>
@endif
