<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FF6B35">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>@yield('title', 'Money Tracker - ระบบจัดการการเงินส่วนบุคคล')</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- Core Styles -->
    <style>
        :root {
            /* Orange Theme Colors */
            --primary: #FF6B35;
            --primary-light: #FF8F65;
            --primary-dark: #E55A2B;
            --primary-soft: #FFF5F2;
            
            /* Supporting Colors */
            --secondary: #4ECDC4;
            --success: #26C485;
            --danger: #FF5757;
            --warning: #FFB800;
            --info: #3498DB;
            
            /* Neutral Colors */
            --white: #FFFFFF;
            --gray-50: #FAFAFA;
            --gray-100: #F5F5F5;
            --gray-200: #EEEEEE;
            --gray-300: #E0E0E0;
            --gray-400: #BDBDBD;
            --gray-500: #9E9E9E;
            --gray-600: #757575;
            --gray-700: #616161;
            --gray-800: #424242;
            --gray-900: #212121;
            --black: #000000;
            
            /* Gradients */
            --gradient-primary: linear-gradient(135deg, #FF6B35 0%, #FF8F65 100%);
            --gradient-soft: linear-gradient(135deg, #FFF5F2 0%, #FFFFFF 100%);
            --gradient-dark: linear-gradient(135deg, #FF6B35 0%, #E55A2B 100%);
            
            /* Shadows */
            --shadow-xs: 0 1px 2px rgba(0, 0, 0, 0.05);
            --shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.06);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.07);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, 0.1);
            --shadow-orange: 0 4px 14px rgba(255, 107, 53, 0.25);
            
            /* Border Radius */
            --radius-sm: 8px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
            --radius-full: 9999px;
            
            /* Transitions */
            --transition-fast: all 0.2s ease;
            --transition-base: all 0.3s ease;
            --transition-slow: all 0.5s ease;
            
            /* Z-index */
            --z-dropdown: 1000;
            --z-sticky: 1020;
            --z-fixed: 1030;
            --z-modal-backdrop: 1040;
            --z-modal: 1050;
            --z-popover: 1060;
            --z-tooltip: 1070;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Kanit', sans-serif;
            font-weight: 400;
            font-size: 16px;
            line-height: 1.5;
            color: var(--gray-800);
            background: var(--gray-50);
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* Container */
        .app-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Desktop Navigation */
        .navbar-desktop {
            background: var(--white);
            box-shadow: var(--shadow-sm);
            position: sticky;
            top: 0;
            z-index: var(--z-sticky);
            transition: var(--transition-base);
        }

        .navbar-content {
            max-width: 1280px;
            margin: 0 auto;
            padding: 0 1.5rem;
            height: 64px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-decoration: none;
            color: var(--gray-900);
            font-weight: 600;
            font-size: 1.25rem;
        }

        .navbar-logo {
            width: 36px;
            height: 36px;
            background: var(--gradient-primary);
            border-radius: var(--radius-md);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            font-size: 1.25rem;
        }

        .navbar-menu {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .navbar-item {
            padding: 0.5rem 1rem;
            border-radius: var(--radius-sm);
            color: var(--gray-600);
            text-decoration: none;
            font-size: 0.95rem;
            transition: var(--transition-fast);
            position: relative;
        }

        .navbar-item:hover {
            color: var(--primary);
            background: var(--primary-soft);
        }

        .navbar-item.active {
            color: var(--primary);
            background: var(--primary-soft);
            font-weight: 500;
        }

        .navbar-user {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .navbar-notifications {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: var(--radius-full);
            background: var(--gray-100);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--gray-600);
            cursor: pointer;
            transition: var(--transition-fast);
        }

        .navbar-notifications:hover {
            background: var(--primary-soft);
            color: var(--primary);
        }

        .notification-badge {
            position: absolute;
            top: 6px;
            right: 6px;
            width: 8px;
            height: 8px;
            background: var(--danger);
            border-radius: var(--radius-full);
            border: 2px solid var(--white);
        }

        .navbar-avatar {
            width: 40px;
            height: 40px;
            border-radius: var(--radius-full);
            background: var(--gradient-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition-fast);
        }

        .navbar-avatar:hover {
            transform: scale(1.05);
        }

        /* Mobile Navigation */
        .navbar-mobile {
            display: none;
            background: var(--white);
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.05);
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            z-index: var(--z-fixed);
        }

        .navbar-mobile-content {
            display: flex;
            justify-content: space-around;
            padding: 0.5rem 0;
        }

        .mobile-nav-item {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.25rem;
            padding: 0.5rem;
            color: var(--gray-500);
            text-decoration: none;
            transition: var(--transition-fast);
            position: relative;
        }

        .mobile-nav-item i {
            font-size: 1.25rem;
        }

        .mobile-nav-item span {
            font-size: 0.75rem;
            font-weight: 500;
        }

        .mobile-nav-item.active {
            color: var(--primary);
        }

        .mobile-nav-item.active::before {
            content: '';
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 30%;
            height: 3px;
            background: var(--primary);
            border-radius: 0 0 var(--radius-sm) var(--radius-sm);
        }

        /* Main Content */
        .main-content {
            flex: 1;
            max-width: 1280px;
            width: 100%;
            margin: 0 auto;
            padding: 2rem 1.5rem;
            padding-bottom: 100px;
        }

        /* Floating Action Button */
        .fab-container {
            position: fixed;
            bottom: 80px;
            right: 20px;
            z-index: var(--z-fixed);
        }

        .fab-button {
            width: 56px;
            height: 56px;
            border-radius: var(--radius-full);
            background: var(--gradient-primary);
            color: var(--white);
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            box-shadow: var(--shadow-orange);
            transition: var(--transition-base);
        }

        .fab-button:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 20px rgba(255, 107, 53, 0.35);
        }

        .fab-button:active {
            transform: scale(0.95);
        }

        /* Utilities */
        .text-primary { color: var(--primary) !important; }
        .text-success { color: var(--success) !important; }
        .text-danger { color: var(--danger) !important; }
        .text-warning { color: var(--warning) !important; }
        .text-muted { color: var(--gray-500) !important; }

        .bg-primary { background: var(--primary) !important; }
        .bg-primary-soft { background: var(--primary-soft) !important; }
        .bg-success-soft { background: rgba(38, 196, 133, 0.1) !important; }
        .bg-danger-soft { background: rgba(255, 87, 87, 0.1) !important; }
        .bg-warning-soft { background: rgba(255, 184, 0, 0.1) !important; }

        /* Responsive */
        @media (max-width: 768px) {
            .navbar-desktop {
                display: none;
            }

            .navbar-mobile {
                display: block;
            }

            .main-content {
                padding: 1rem;
                padding-bottom: 80px;
            }

            .fab-container {
                bottom: 90px;
                right: 16px;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes slideUp {
            from { transform: translateY(100%); }
            to { transform: translateY(0); }
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }

        .animate-fadeIn { animation: fadeIn 0.5s ease; }
        .animate-slideUp { animation: slideUp 0.3s ease; }
        .animate-pulse { animation: pulse 2s infinite; }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="app-container">
        <!-- Desktop Navigation -->
        <nav class="navbar-desktop">
            <div class="navbar-content">
                <a href="{{ route('finance.dashboard') }}" class="navbar-brand">
                    <div class="navbar-logo">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <span>Money Tracker</span>
                </a>

                <div class="navbar-menu">
                    <a href="{{ route('finance.dashboard') }}" class="navbar-item {{ request()->routeIs('finance.dashboard') ? 'active' : '' }}">
                        <i class="fas fa-home"></i> หน้าหลัก
                    </a>
                    <a href="{{ route('finance.records.index') }}" class="navbar-item {{ request()->routeIs('finance.records.*') ? 'active' : '' }}">
                        <i class="fas fa-list"></i> รายการ
                    </a>
                    <a href="{{ route('finance.budgets.index') }}" class="navbar-item {{ request()->routeIs('finance.budgets.*') ? 'active' : '' }}">
                        <i class="fas fa-calculator"></i> งบประมาณ
                    </a>
                    <a href="{{ route('finance.goals.index') }}" class="navbar-item {{ request()->routeIs('finance.goals.*') ? 'active' : '' }}">
                        <i class="fas fa-bullseye"></i> เป้าหมาย
                    </a>
                    <a href="{{ route('finance.reports.index') }}" class="navbar-item {{ request()->routeIs('finance.reports.*') ? 'active' : '' }}">
                        <i class="fas fa-chart-bar"></i> รายงาน
                    </a>
                </div>

                <div class="navbar-user">
                    <div class="navbar-notifications">
                        <i class="far fa-bell"></i>
                        <span class="notification-badge"></span>
                    </div>
                    <div class="navbar-avatar">
                        {{ substr(auth()->user()->first_name, 0, 1) }}
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="main-content">
            @yield('content')
        </main>

        <!-- Mobile Navigation -->
        <nav class="navbar-mobile">
            <div class="navbar-mobile-content">
                <a href="{{ route('finance.dashboard') }}" class="mobile-nav-item {{ request()->routeIs('finance.dashboard') ? 'active' : '' }}">
                    <i class="fas fa-home"></i>
                    <span>หน้าหลัก</span>
                </a>
                <a href="{{ route('finance.records.index') }}" class="mobile-nav-item {{ request()->routeIs('finance.records.*') ? 'active' : '' }}">
                    <i class="fas fa-list"></i>
                    <span>รายการ</span>
                </a>
                <a href="#" class="mobile-nav-item">
                    <div style="width: 56px; height: 56px;"></div>
                </a>
                <a href="{{ route('finance.goals.index') }}" class="mobile-nav-item {{ request()->routeIs('finance.goals.*') ? 'active' : '' }}">
                    <i class="fas fa-bullseye"></i>
                    <span>เป้าหมาย</span>
                </a>
                <a href="{{ route('finance.reports.index') }}" class="mobile-nav-item {{ request()->routeIs('finance.reports.*') ? 'active' : '' }}">
                    <i class="fas fa-chart-bar"></i>
                    <span>รายงาน</span>
                </a>
            </div>
        </nav>

        <!-- Floating Action Button -->
        <div class="fab-container">
            <button class="fab-button" onclick="openQuickAdd()">
                <i class="fas fa-plus"></i>
            </button>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        function openQuickAdd() {
            // Will be implemented in the modal component
            console.log('Open quick add modal');
        }
    </script>
    
    @stack('scripts')
</body>
</html>