<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('common.dashboard') }} - {{ __('app.name') }}
            </h2>
            <x-language-switcher />
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            
            {{-- Basic Translations --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">{{ __('Basic Translations') }}</h3>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <p><strong>{{ __('common.name') }}:</strong> {{ __('app.name') }}</p>
                            <p><strong>{{ __('common.description') }}:</strong> {{ __('app.description') }}</p>
                            <p><strong>{{ __('common.language') }}:</strong> {{ __('common.' . app()->getLocale()) }}</p>
                        </div>
                        <div>
                            <p><strong>{{ __('common.today') }}:</strong> @localeDate(now())</p>
                            <p><strong>{{ __('common.time') }}:</strong> @localeDateTime(now())</p>
                            <p><strong>{{ __('delivery.commission') }}:</strong> @currency(2500.75)</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Delivery Domain Example --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">{{ __('delivery.dashboard') }}</h3>
                    
                    <div class="grid grid-cols-3 gap-4 mb-6">
                        <div class="bg-blue-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-blue-800">{{ __('delivery.total_parcels') }}</h4>
                            <p class="text-2xl font-bold text-blue-600">@number(1250)</p>
                            <p class="text-sm text-blue-600">{{ __('delivery.this_month') }}</p>
                        </div>
                        <div class="bg-green-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-green-800">{{ __('delivery.commission') }}</h4>
                            <p class="text-2xl font-bold text-green-600">@currency(15750.50)</p>
                            <p class="text-sm text-green-600">{{ __('delivery.this_month') }}</p>
                        </div>
                        <div class="bg-orange-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-orange-800">{{ __('delivery.working_days') }}</h4>
                            <p class="text-2xl font-bold text-orange-600">@number(22)</p>
                            <p class="text-sm text-orange-600">{{ __('delivery.this_month') }}</p>
                        </div>
                    </div>

                    <div class="flex gap-4">
                        <button class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
                            {{ __('delivery.record_delivery') }}
                        </button>
                        <button class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600">
                            {{ __('delivery.view_history') }}
                        </button>
                        <button class="bg-purple-500 text-white px-4 py-2 rounded-lg hover:bg-purple-600">
                            {{ __('delivery.calculate_commission') }}
                        </button>
                    </div>
                </div>
            </div>

            {{-- Finance Domain Example --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">{{ __('finance.dashboard') }}</h3>
                    
                    <div class="grid grid-cols-3 gap-4 mb-6">
                        <div class="bg-green-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-green-800">{{ __('finance.total_income') }}</h4>
                            <p class="text-2xl font-bold text-green-600">@currency(45250.75)</p>
                            <p class="text-sm text-green-600">+12% {{ __('finance.from_last_month') }}</p>
                        </div>
                        <div class="bg-red-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-red-800">{{ __('finance.total_expense') }}</h4>
                            <p class="text-2xl font-bold text-red-600">@currency(28750.25)</p>
                            <p class="text-sm text-red-600">+5% {{ __('finance.from_last_month') }}</p>
                        </div>
                        <div class="bg-blue-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-blue-800">{{ __('finance.net_balance') }}</h4>
                            <p class="text-2xl font-bold text-blue-600">@currency(16500.50)</p>
                            <p class="text-sm text-blue-600">{{ __('finance.savings_rate') }}: 36%</p>
                        </div>
                    </div>

                    <div class="flex gap-4">
                        <button class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600">
                            {{ __('finance.add_income') }}
                        </button>
                        <button class="bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600">
                            {{ __('finance.add_expense') }}
                        </button>
                        <button class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
                            {{ __('finance.reports') }}
                        </button>
                    </div>
                </div>
            </div>

            {{-- Form Example with Validation --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">{{ __('delivery.create_delivery') }}</h3>
                    
                    <form class="space-y-4">
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">
                                    {{ __('delivery.delivery_date') }}
                                </label>
                                <input type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <p class="mt-1 text-sm text-gray-500">{{ __('delivery.select_delivery_date') }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">
                                    {{ __('delivery.parcel_count') }}
                                </label>
                                <input type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" 
                                       placeholder="{{ __('delivery.enter_parcel_count') }}">
                                <p class="mt-1 text-sm text-gray-500">{{ __('delivery.enter_total_parcels') }}</p>
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700">
                                {{ __('delivery.warehouse') }}
                            </label>
                            <select class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <option>{{ __('common.select') }} {{ __('delivery.warehouse') }}</option>
                                <option>{{ __('delivery.warehouse') }} A</option>
                                <option>{{ __('delivery.warehouse') }} B</option>
                            </select>
                        </div>

                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-gray-800 mb-2">{{ __('delivery.estimated_commission') }}</h4>
                            <p class="text-2xl font-bold text-green-600">@currency(850.00)</p>
                            <p class="text-sm text-gray-600">{{ __('delivery.calculating') }}</p>
                        </div>

                        <div class="flex gap-4">
                            <button type="submit" class="bg-blue-500 text-white px-6 py-2 rounded-lg hover:bg-blue-600">
                                {{ __('delivery.save_data') }}
                            </button>
                            <button type="button" class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                                {{ __('common.cancel') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            {{-- JavaScript i18n Example --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">JavaScript i18n Demo</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <button onclick="showJsTranslation()" class="bg-purple-500 text-white px-4 py-2 rounded-lg hover:bg-purple-600">
                                Show JS Translation
                            </button>
                            <div id="js-output" class="mt-2 p-3 bg-gray-100 rounded hidden"></div>
                        </div>
                        
                        <div>
                            <button onclick="formatNumbers()" class="bg-indigo-500 text-white px-4 py-2 rounded-lg hover:bg-indigo-600">
                                Format Numbers
                            </button>
                            <div id="number-output" class="mt-2 p-3 bg-gray-100 rounded hidden"></div>
                        </div>
                        
                        <div>
                            <button onclick="switchLanguageDemo()" class="bg-pink-500 text-white px-4 py-2 rounded-lg hover:bg-pink-600">
                                Switch Language (JS)
                            </button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
    <script src="{{ asset('js/i18n.js') }}"></script>
    <script>
        function showJsTranslation() {
            const output = document.getElementById('js-output');
            output.innerHTML = `
                <p><strong>Current Locale:</strong> ${i18n.getLocale()}</p>
                <p><strong>Common Save:</strong> ${__('common.save')}</p>
                <p><strong>Delivery Dashboard:</strong> ${__('delivery.dashboard')}</p>
                <p><strong>With Parameters:</strong> ${__('common.min_length', {min: 5})}</p>
            `;
            output.classList.remove('hidden');
        }
        
        function formatNumbers() {
            const output = document.getElementById('number-output');
            const amount = 1234567.89;
            const date = new Date();
            
            output.innerHTML = `
                <p><strong>Currency:</strong> ${formatCurrency(amount)}</p>
                <p><strong>Number:</strong> ${formatNumber(amount, 2)}</p>
                <p><strong>Date:</strong> ${formatDate(date)}</p>
                <p><strong>DateTime:</strong> ${formatDateTime(date)}</p>
                <p><strong>Relative Time:</strong> ${formatRelativeTime(new Date(Date.now() - 3600000))}</p>
            `;
            output.classList.remove('hidden');
        }
        
        async function switchLanguageDemo() {
            const currentLocale = i18n.getLocale();
            const newLocale = currentLocale === 'th' ? 'en' : 'th';
            
            try {
                await i18n.switchLanguage(newLocale);
                alert(`Language switched to: ${newLocale}`);
            } catch (error) {
                alert(`Error: ${error.message}`);
            }
        }
        
        // Auto-update elements with data-i18n
        document.addEventListener('DOMContentLoaded', function() {
            // Example of dynamic content update
            setTimeout(() => {
                const dynamicElement = document.createElement('p');
                dynamicElement.setAttribute('data-i18n', 'common.loading');
                dynamicElement.textContent = __('common.loading');
                
                // This would be updated automatically when language changes
            }, 1000);
        });
    </script>
    @endpush
</x-app-layout>