<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>รายงานประจำเดือน</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
        }
        .content {
            padding: 30px;
        }
        .greeting {
            font-size: 16px;
            margin-bottom: 20px;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 30px 0;
        }
        .stat-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            border-left: 4px solid #FF6B35;
        }
        .stat-value {
            font-size: 24px;
            font-weight: 700;
            color: #FF6B35;
            margin-bottom: 5px;
        }
        .stat-label {
            color: #6b7280;
            font-size: 14px;
        }
        .summary {
            background: #f0f9ff;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
            border-left: 4px solid #3b82f6;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #6b7280;
            font-size: 14px;
        }
        .btn {
            display: inline-block;
            background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 500;
            margin: 20px 0;
        }
        @media (max-width: 600px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>รายงานประจำเดือน</h1>
            <p>ระบบจัดการค่าคอมมิชชั่น</p>
            <p>{{ date('d/m/Y', strtotime($startDate)) }} - {{ date('d/m/Y', strtotime($endDate)) }}</p>
        </div>

        <div class="content">
            <div class="greeting">
                สวัสดี คุณ{{ $user->name }},
            </div>

            <p>นี่คือรายงานสรุปประสิทธิภาพการทำงานประจำเดือนของระบบจัดการค่าคอมมิชชั่น</p>

            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-value">{{ number_format($stats['total_deliveries']) }}</div>
                    <div class="stat-label">การจัดส่งทั้งหมด</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ number_format($stats['total_parcels']) }}</div>
                    <div class="stat-label">จำนวนพัสดุ</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">฿{{ number_format($stats['total_commission'], 2) }}</div>
                    <div class="stat-label">ค่าคอมมิชชั่นรวม</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ number_format($stats['active_users']) }}</div>
                    <div class="stat-label">พนักงานที่ใช้งาน</div>
                </div>
            </div>

            <div class="summary">
                <h3 style="margin-top: 0; color: #1f2937;">สรุปผลการดำเนินงาน</h3>
                <ul style="margin: 0; padding-left: 20px;">
                    <li>มีการจัดส่งพัสดุทั้งหมด {{ number_format($stats['total_deliveries']) }} ครั้ง</li>
                    <li>จำนวนพัสดุที่ส่งรวม {{ number_format($stats['total_parcels']) }} ชิ้น</li>
                    <li>ค่าคอมมิชชั่นที่จ่ายรวม {{ number_format($stats['total_commission'], 2) }} บาท</li>
                    <li>พนักงานที่ใช้งานระบบ {{ number_format($stats['active_users']) }} คน</li>
                </ul>
            </div>

            <div style="text-align: center;">
                <a href="{{ url('/admin/reports') }}" class="btn">ดูรายงานเพิ่มเติม</a>
            </div>

            <p style="margin-top: 30px; color: #6b7280; font-size: 14px;">
                รายงานนี้ถูกสร้างขึ้นโดยอัตโนมัติเมื่อ {{ now()->format('d/m/Y H:i:s') }}
            </p>
        </div>

        <div class="footer">
            <p>ระบบจัดการค่าคอมมิชชั่น<br>
            หากมีข้อสงสัยกรุณาติดต่อผู้ดูแลระบบ</p>
        </div>
    </div>
</body>
</html>