<x-guest-layout>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary-orange: #FF6B35;
            --primary-dark: #E85D2F;
            --primary-light: #FF8C61;
            --primary-gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            --white: #FFFFFF;
            --off-white: #FEFEFE;
            --light-gray: #F8F9FA;
            --medium-gray: #E9ECEF;
            --gray: #6C757D;
            --dark-gray: #343A40;
            --success: #22C55E;
            --danger: #EF4444;
            --warning: #F59E0B;
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, 0.1);
            --transition-fast: all 0.15s ease-out;
            --transition-normal: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --radius-sm: 6px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Kanit', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            font-weight: 300;
            line-height: 1.6;
        }
        
        .auth-container {
            min-height: 100vh;
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(255, 255, 255, 0.05) 0%, transparent 50%);
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(1deg); }
        }
        
        .auth-card {
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 500px;
            position: relative;
            z-index: 1;
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            animation: slideUp 0.6s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .auth-logo {
            width: 70px;
            height: 70px;
            background: var(--primary-gradient);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem auto;
            box-shadow: var(--shadow-lg);
            position: relative;
            overflow: hidden;
        }
        
        .auth-logo::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            animation: shine 2s infinite;
        }
        
        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }
        
        .auth-title {
            font-size: 1.875rem;
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }
        
        .auth-subtitle {
            color: var(--gray);
            font-size: 1rem;
            font-weight: 400;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }
        
        .form-grid-full {
            grid-column: 1 / -1;
        }
        
        .form-label {
            display: block;
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
            font-size: 0.95rem;
        }
        
        .form-control {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid var(--medium-gray);
            border-radius: var(--radius-md);
            font-family: inherit;
            font-size: 1rem;
            transition: var(--transition-normal);
            background: var(--white);
            color: var(--dark-gray);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-orange);
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
        }
        
        .form-control.error {
            border-color: var(--danger);
        }
        
        .vehicle-selection {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-top: 0.5rem;
        }
        
        .vehicle-card {
            position: relative;
            cursor: pointer;
        }
        
        .vehicle-input {
            position: absolute;
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .vehicle-label {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 1.5rem 1rem;
            border: 2px solid var(--medium-gray);
            border-radius: var(--radius-md);
            transition: var(--transition-normal);
            background: var(--white);
            text-align: center;
            min-height: 120px;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        
        .vehicle-label::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255, 107, 53, 0.1);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .vehicle-label:hover::before {
            width: 200px;
            height: 200px;
        }
        
        .vehicle-label:hover {
            border-color: var(--primary-orange);
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }
        
        .vehicle-input:checked + .vehicle-label {
            border-color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.05);
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
        }
        
        .vehicle-icon {
            width: 40px;
            height: 40px;
            margin-bottom: 0.75rem;
            color: var(--primary-orange);
            z-index: 1;
            position: relative;
        }
        
        .vehicle-title {
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.25rem;
            z-index: 1;
            position: relative;
        }
        
        .vehicle-desc {
            font-size: 0.85rem;
            color: var(--gray);
            z-index: 1;
            position: relative;
        }
        
        .password-wrapper {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 0.75rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--gray);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: var(--radius-sm);
            transition: var(--transition-fast);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .password-toggle:hover {
            color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.05);
        }
        
        .strength-indicator {
            margin-top: 0.5rem;
        }
        
        .strength-bars {
            display: flex;
            gap: 0.25rem;
            margin-bottom: 0.5rem;
        }
        
        .strength-bar {
            height: 4px;
            flex: 1;
            background: var(--medium-gray);
            border-radius: 2px;
            transition: var(--transition-fast);
        }
        
        .strength-text {
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .terms-checkbox {
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
            margin: 1.5rem 0;
        }
        
        .terms-checkbox input[type="checkbox"] {
            margin-top: 0.125rem;
            width: 18px;
            height: 18px;
            accent-color: var(--primary-orange);
        }
        
        .auth-submit {
            width: 100%;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            padding: 1rem 1.5rem;
            border-radius: var(--radius-md);
            font-family: inherit;
            font-weight: 500;
            font-size: 1rem;
            cursor: pointer;
            transition: var(--transition-normal);
            box-shadow: var(--shadow-md);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-submit::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .auth-submit:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .auth-submit:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }
        
        .auth-submit:active {
            transform: translateY(0);
        }
        
        .auth-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .auth-submit:disabled:hover {
            transform: none;
            box-shadow: var(--shadow-md);
        }
        
        .loading-spinner {
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--medium-gray);
        }
        
        .auth-link {
            color: var(--primary-orange);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-fast);
            position: relative;
        }
        
        .auth-link::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary-orange);
            transition: width 0.3s ease;
        }
        
        .auth-link:hover::after {
            width: 100%;
        }
        
        .auth-link:hover {
            color: var(--primary-dark);
        }
        
        .error-message {
            color: var(--danger);
            font-size: 0.875rem;
            margin-top: 0.25rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .success-message {
            color: var(--success);
            font-size: 0.875rem;
            margin-top: 0.25rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
            gap: 0.5rem;
        }
        
        .step {
            width: 40px;
            height: 4px;
            background: var(--medium-gray);
            border-radius: 2px;
            transition: var(--transition-fast);
        }
        
        .step.active {
            background: var(--primary-orange);
        }
        
        @media (max-width: 640px) {
            .auth-container {
                padding: 1rem;
            }
            
            .auth-card {
                padding: 2rem 1.5rem;
                margin: 0;
            }
            
            .auth-title {
                font-size: 1.5rem;
            }
            
            .form-grid {
                grid-template-columns: 1fr;
            }
            
            .vehicle-selection {
                grid-template-columns: 1fr;
            }
        }
        
        @media (max-width: 480px) {
            .auth-card {
                padding: 1.5rem 1rem;
            }
        }
    </style>

    <div class="auth-container">
        <div class="auth-card">
            <!-- Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <svg width="36" height="36" fill="white" viewBox="0 0 24 24">
                        <path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                </div>
                <h1 class="auth-title">สมัครสมาชิก</h1>
                <p class="auth-subtitle">สร้างบัญชีใหม่เพื่อเข้าใช้งานระบบ</p>
            </div>

            <!-- Progress Steps -->
            <div class="step-indicator">
                <div class="step active"></div>
                <div class="step"></div>
                <div class="step"></div>
            </div>

            <!-- Authentication Failed -->
            @if($errors->has('email') && $errors->first('email') === 'auth.failed')
                <div class="alert alert-error">
                    <svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                    ข้อมูลไม่ถูกต้อง กรุณาตรวจสอบและลองใหม่อีกครั้ง
                </div>
            @endif

            <!-- Form -->
            <form method="POST" action="{{ route('register') }}" id="registerForm">
                @csrf

                <!-- Warehouse Selection -->
                <div class="form-group form-grid-full">
                    <label for="warehouse_code" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path fill-rule="evenodd" d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"/>
                        </svg>
                        เลือกคลัง <span style="color: var(--danger);">*</span>
                    </label>
                    <select id="warehouse_code" name="warehouse_code" class="form-control @error('warehouse_code') error @enderror" required>
                        <option value="">-- เลือกคลังที่สังกัด --</option>
                        @if(isset($warehouses))
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->code }}" 
                                        {{ old('warehouse_code') == $warehouse->code ? 'selected' : '' }}
                                        data-location="{{ $warehouse->location }}">
                                    {{ $warehouse->code }} - {{ $warehouse->name }}
                                    @if($warehouse->location)
                                        ({{ $warehouse->location }})
                                    @endif
                                </option>
                            @endforeach
                        @endif
                    </select>
                    @error('warehouse_code')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Name Fields -->
                <div class="form-grid">
                    <div class="form-group">
                        <label for="first_name" class="form-label">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                            </svg>
                            ชื่อ <span style="color: var(--danger);">*</span>
                        </label>
                        <input type="text" 
                               id="first_name" 
                               name="first_name" 
                               class="form-control @error('first_name') error @enderror"
                               value="{{ old('first_name') }}" 
                               required 
                               autocomplete="given-name"
                               placeholder="กรอกชื่อของคุณ">
                        @error('first_name')
                            <div class="error-message">
                                <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="last_name" class="form-label">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                            </svg>
                            นามสกุล <span style="color: var(--danger);">*</span>
                        </label>
                        <input type="text" 
                               id="last_name" 
                               name="last_name" 
                               class="form-control @error('last_name') error @enderror"
                               value="{{ old('last_name') }}" 
                               required 
                               autocomplete="family-name"
                               placeholder="กรอกนามสกุลของคุณ">
                        @error('last_name')
                            <div class="error-message">
                                <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>

                <!-- Vehicle Type Selection -->
                <div class="form-group form-grid-full">
                    <label class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path d="M8 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM15 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0z"/>
                            <path d="M3 4a1 1 0 00-1 1v10a1 1 0 001 1h1.05a2.5 2.5 0 014.9 0H10a1 1 0 001-1V5a1 1 0 00-1-1H3zM14 7a1 1 0 00-1 1v6.05A2.5 2.5 0 0115.95 16H17a1 1 0 001-1v-5a1 1 0 00-.293-.707L16 7.586A1 1 0 0015.414 7H14z"/>
                        </svg>
                        ประเภทรถ <span style="color: var(--danger);">*</span>
                    </label>
                    <div class="vehicle-selection">
                        <div class="vehicle-card">
                            <input type="radio" 
                                   id="2wheel" 
                                   name="role" 
                                   value="2wheel" 
                                   class="vehicle-input"
                                   {{ old('role') == '2wheel' ? 'checked' : '' }}
                                   required>
                            <label for="2wheel" class="vehicle-label">
                                <svg class="vehicle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                </svg>
                                <div class="vehicle-title">รถ 2 ล้อ</div>
                                <div class="vehicle-desc">มอเตอร์ไซค์</div>
                            </label>
                        </div>

                        <div class="vehicle-card">
                            <input type="radio" 
                                   id="4wheel" 
                                   name="role" 
                                   value="4wheel" 
                                   class="vehicle-input"
                                   {{ old('role') == '4wheel' ? 'checked' : '' }}
                                   required>
                            <label for="4wheel" class="vehicle-label">
                                <svg class="vehicle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l4-4 4 4m0 6l-4 4-4-4"/>
                                </svg>
                                <div class="vehicle-title">รถ 4 ล้อ</div>
                                <div class="vehicle-desc">รถยนต์/รถกระบะ</div>
                            </label>
                        </div>
                    </div>
                    @error('role')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Email -->
                <div class="form-group form-grid-full">
                    <label for="email" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                            <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                        </svg>
                        อีเมล <span style="color: var(--danger);">*</span>
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control @error('email') error @enderror"
                           value="{{ old('email') }}" 
                           required 
                           autocomplete="username"
                           placeholder="กรอกอีเมลของคุณ">
                    @error('email')
                        @if($message !== 'auth.failed')
                            <div class="error-message">
                                <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </div>
                        @endif
                    @enderror
                </div>

                <!-- Password -->
                <div class="form-group form-grid-full">
                    <label for="password" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                        </svg>
                        รหัสผ่าน <span style="color: var(--danger);">*</span>
                    </label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password" 
                               name="password" 
                               class="form-control @error('password') error @enderror"
                               required 
                               autocomplete="new-password"
                               placeholder="อย่างน้อย 8 ตัวอักษร"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                    
                    <!-- Password Strength Indicator -->
                    <div class="strength-indicator">
                        <div class="strength-bars">
                            <div class="strength-bar" id="strength-1"></div>
                            <div class="strength-bar" id="strength-2"></div>
                            <div class="strength-bar" id="strength-3"></div>
                            <div class="strength-bar" id="strength-4"></div>
                        </div>
                        <div class="strength-text" id="strength-text" style="color: var(--gray);">กรอกรหัสผ่าน</div>
                    </div>
                </div>

                <!-- Confirm Password -->
                <div class="form-group form-grid-full">
                    <label for="password_confirmation" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        ยืนยันรหัสผ่าน <span style="color: var(--danger);">*</span>
                    </label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password_confirmation" 
                               name="password_confirmation" 
                               class="form-control @error('password_confirmation') error @enderror"
                               required 
                               autocomplete="new-password"
                               placeholder="กรอกรหัสผ่านอีกครั้ง"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password_confirmation')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password_confirmation-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password_confirmation')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                    <div style="font-size: 0.8rem; margin-top: 0.25rem;" id="password-match"></div>
                </div>

                <!-- Terms and Conditions -->
                <div class="terms-checkbox">
                    <input type="checkbox" 
                           name="terms" 
                           id="terms"
                           required>
                    <label for="terms" style="font-size: 0.9rem; color: var(--gray);">
                        ฉันยอมรับ
                        <a href="#" class="auth-link">ข้อกำหนดและเงื่อนไข</a>
                        และ
                        <a href="#" class="auth-link">นโยบายความเป็นส่วนตัว</a>
                    </label>
                </div>
                @error('terms')
                    <div class="error-message" style="margin-top: -0.5rem;">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                        {{ $message }}
                    </div>
                @enderror

                <!-- Submit Button -->
                <button type="submit" class="auth-submit" id="submitBtn">
                    <span id="submitText">
                        <svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20" style="margin-right: 0.5rem;">
                            <path d="M8 9a3 3 0 100-6 3 3 0 000 6zM8 11a6 6 0 016 6H2a6 6 0 016-6zM16 7a1 1 0 10-2 0v1h-1a1 1 0 100 2h1v1a1 1 0 102 0v-1h1a1 1 0 100-2h-1V7z"/>
                        </svg>
                        สร้างบัญชี
                    </span>
                    <div id="loadingIcon" class="loading-spinner" style="display: none;"></div>
                </button>

                <!-- Footer -->
                <div class="auth-footer">
                    <p style="color: var(--gray); font-size: 0.9rem;">
                        มีบัญชีอยู่แล้ว? 
                        <a href="{{ route('login') }}" class="auth-link">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="margin-right: 0.25rem;">
                                <path fill-rule="evenodd" d="M3 3a1 1 0 000 2v8a2 2 0 002 2h2.586l-1.293 1.293a1 1 0 101.414 1.414L10 15.414l2.293 2.293a1 1 0 001.414-1.414L12.414 15H15a2 2 0 002-2V5a1 1 0 100-2H3zm11.707 4.707a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            เข้าสู่ระบบ
                        </a>
                    </p>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Password visibility toggle
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const eye = document.getElementById(fieldId + '-eye');
            
            if (field.type === 'password') {
                field.type = 'text';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" />
                `;
            } else {
                field.type = 'password';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                `;
            }
        }

        // Password strength checker
        function checkPasswordStrength(password) {
            let strength = 0;
            if (password.length >= 8) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^A-Za-z0-9]/.test(password)) strength++;
            return strength;
        }

        // Update password strength indicator
        document.getElementById('password').addEventListener('input', function() {
            const password = this.value;
            const strength = checkPasswordStrength(password);
            const colors = ['#EF4444', '#F59E0B', '#FFD93D', '#22C55E'];
            const labels = ['อ่อนแอ', 'พอใช้', 'ดี', 'แข็งแกร่ง'];
            
            // Reset all bars
            for (let i = 1; i <= 4; i++) {
                document.getElementById(`strength-${i}`).style.background = '#E9ECEF';
            }

            // Update active bars
            for (let i = 1; i <= strength; i++) {
                document.getElementById(`strength-${i}`).style.background = colors[strength - 1] || '#EF4444';
            }

            const strengthText = document.getElementById('strength-text');
            if (password.length === 0) {
                strengthText.textContent = 'กรอกรหัสผ่าน';
                strengthText.style.color = '#6C757D';
            } else {
                strengthText.textContent = labels[strength - 1] || 'อ่อนแอ';
                strengthText.style.color = colors[strength - 1] || '#EF4444';
            }
        });

        // Password confirmation checker
        document.getElementById('password_confirmation').addEventListener('input', function() {
            const password = document.getElementById('password').value;
            const confirmation = this.value;
            const matchDiv = document.getElementById('password-match');

            if (confirmation.length === 0) {
                matchDiv.textContent = '';
            } else if (password === confirmation) {
                matchDiv.innerHTML = '<span class="success-message"><svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>รหัสผ่านตรงกัน</span>';
            } else {
                matchDiv.innerHTML = '<span class="error-message"><svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>รหัสผ่านไม่ตรงกัน</span>';
            }
        });

        // Form submission handling
        document.getElementById('registerForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const loadingIcon = document.getElementById('loadingIcon');
            
            submitBtn.disabled = true;
            submitText.style.display = 'none';
            loadingIcon.style.display = 'block';
            
            // Update progress steps
            const steps = document.querySelectorAll('.step');
            steps.forEach((step, index) => {
                setTimeout(() => {
                    step.classList.add('active');
                }, index * 200);
            });
        });

        // Form validation and progress
        document.addEventListener('DOMContentLoaded', function() {
            const formInputs = document.querySelectorAll('input, select');
            const steps = document.querySelectorAll('.step');
            
            function updateProgress() {
                const totalFields = formInputs.length - 1; // Exclude submit button
                let filledFields = 0;
                
                formInputs.forEach(input => {
                    if (input.type !== 'submit' && input.value.trim() !== '') {
                        filledFields++;
                    }
                });
                
                const progress = Math.floor((filledFields / totalFields) * 3);
                
                steps.forEach((step, index) => {
                    if (index < progress) {
                        step.classList.add('active');
                    } else {
                        step.classList.remove('active');
                    }
                });
            }
            
            formInputs.forEach(input => {
                input.addEventListener('input', updateProgress);
                input.addEventListener('change', updateProgress);
            });
            
            // Auto-focus first field
            setTimeout(() => {
                document.getElementById('warehouse_code').focus();
            }, 500);
        });

        // Add loading screen effect
        window.addEventListener('load', function() {
            document.body.style.opacity = '0';
            document.body.style.transition = 'opacity 0.5s ease';
            
            setTimeout(() => {
                document.body.style.opacity = '1';
            }, 100);
        });

        // Show toast notification for auth errors
        document.addEventListener('DOMContentLoaded', function() {
            @if($errors->has('email') && $errors->first('email') === 'auth.failed')
                showToast('ข้อมูลไม่ถูกต้อง กรุณาตรวจสอบและลองใหม่อีกครั้ง', 'error', 5000);
            @endif
        });

        // Toast notification function
        function showToast(message, type = 'info', duration = 3000) {
            const toast = document.createElement('div');
            toast.className = `toast-notification ${type}`;
            toast.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: ${type === 'error' ? '#EF4444' : '#22C55E'};
                color: white;
                padding: 1rem 1.5rem;
                border-radius: 12px;
                box-shadow: 0 10px 25px rgba(0,0,0,0.15);
                z-index: 9999;
                font-family: 'Kanit', sans-serif;
                font-size: 0.9rem;
                max-width: 400px;
                animation: slideInRight 0.3s ease-out;
                display: flex;
                align-items: center;
                gap: 0.75rem;
            `;
            
            const icon = type === 'error' ? 
                '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>' :
                '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>';
            
            toast.innerHTML = icon + '<span>' + message + '</span>';
            
            // Add CSS animation
            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideInRight {
                    from { transform: translateX(100%); opacity: 0; }
                    to { transform: translateX(0); opacity: 1; }
                }
                @keyframes slideOutRight {
                    from { transform: translateX(0); opacity: 1; }
                    to { transform: translateX(100%); opacity: 0; }
                }
            `;
            document.head.appendChild(style);
            
            document.body.appendChild(toast);
            
            setTimeout(() => {
                toast.style.animation = 'slideOutRight 0.3s ease-in';
                setTimeout(() => {
                    if (toast.parentElement) {
                        toast.remove();
                    }
                    if (style.parentElement) {
                        style.remove();
                    }
                }, 300);
            }, duration);
        }
    </script>
</x-guest-layout>