@push('styles')
<style>
/* ===== USERS MANAGEMENT STYLES ===== */

/* Root Variables */
:root {
    --primary: #FF6B35;
    --primary-dark: #E85D2F;
    --primary-light: #FF8C61;
    --gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    --gradient-soft: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%);
    
    --success: #22C55E;
    --warning: #F59E0B;
    --danger: #EF4444;
    --info: #3B82F6;
    --purple: #8B5CF6;
    
    --white: #FFFFFF;
    --gray-50: #F8FAFC;
    --gray-100: #F1F5F9;
    --gray-200: #E2E8F0;
    --gray-300: #CBD5E1;
    --gray-400: #94A3B8;
    --gray-500: #64748B;
    --gray-600: #475569;
    --gray-700: #334155;
    --gray-800: #1E293B;
    --gray-900: #0F172A;
    
    --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    --shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    
    --radius-sm: 6px;
    --radius: 8px;
    --radius-md: 12px;
    --radius-lg: 16px;
    --radius-xl: 20px;
    --radius-2xl: 24px;
    --radius-full: 9999px;
    
    --transition: all 0.2s ease;
    --transition-fast: all 0.15s ease;
    --transition-slow: all 0.3s ease;
}

/* Main Container */
.users-management {
    padding: 1.5rem;
    max-width: 100%;
    margin: 0 auto;
    background: var(--gray-50);
    min-height: 100vh;
}

/* ===== PAGE HEADER ===== */
.page-header {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1.5rem;
}

.header-info {
    flex: 1;
}

.header-title {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 0.5rem;
}

.title-icon {
    width: 48px;
    height: 48px;
    background: var(--gradient);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-size: 1.25rem;
    box-shadow: var(--shadow-md);
}

.title-text h1 {
    font-size: 1.875rem;
    font-weight: 700;
    color: var(--gray-900);
    margin: 0;
    line-height: 1.2;
}

.title-text p {
    font-size: 1rem;
    color: var(--gray-600);
    margin: 0;
    line-height: 1.4;
}

.header-actions {
    display: flex;
    gap: 0.75rem;
    flex-shrink: 0;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.25rem;
    border-radius: var(--radius-md);
    font-weight: 600;
    font-size: 0.875rem;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    white-space: nowrap;
}

.primary-btn {
    background: var(--gradient);
    color: var(--white);
    box-shadow: var(--shadow-md);
}

.primary-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--white);
}

.export-btn {
    background: var(--white);
    color: var(--info);
    border: 2px solid var(--info);
}

.export-btn:hover {
    background: var(--info);
    color: var(--white);
    transform: translateY(-2px);
}

/* ===== STATS GRID ===== */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 1.5rem;
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--gradient);
}

.stat-card.total::before { background: var(--gradient); }
.stat-card.active::before { background: linear-gradient(135deg, var(--success) 0%, #16a34a 100%); }
.stat-card.vehicle-2w::before { background: linear-gradient(135deg, var(--info) 0%, #1d4ed8 100%); }
.stat-card.vehicle-4w::before { background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%); }

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: var(--shadow-lg);
}

.stat-card .stat-icon {
    width: 56px;
    height: 56px;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: var(--white);
    margin-bottom: 1rem;
}

.stat-card.total .stat-icon { background: var(--gradient); }
.stat-card.active .stat-icon { background: linear-gradient(135deg, var(--success) 0%, #16a34a 100%); }
.stat-card.vehicle-2w .stat-icon { background: linear-gradient(135deg, var(--info) 0%, #1d4ed8 100%); }
.stat-card.vehicle-4w .stat-icon { background: linear-gradient(135deg, var(--purple) 0%, #7c3aed 100%); }

.stat-content {
    margin-bottom: 1rem;
}

.stat-number {
    font-size: 2.25rem;
    font-weight: 800;
    color: var(--gray-900);
    line-height: 1;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--gray-600);
    margin-bottom: 0.5rem;
}

.stat-trend {
    display: flex;
    align-items: center;
    gap: 0.375rem;
    font-size: 0.75rem;
    color: var(--gray-500);
}

.stat-action {
    display: flex;
    justify-content: flex-end;
}

.stat-link {
    background: none;
    border: none;
    color: var(--primary);
    font-size: 0.875rem;
    font-weight: 600;
    cursor: pointer;
    text-decoration: none;
    transition: var(--transition);
}

.stat-link:hover {
    color: var(--primary-dark);
    text-decoration: underline;
}

/* ===== FILTER SECTION ===== */
.filter-section {
    background: var(--white);
    border-radius: var(--radius-lg);
    margin-bottom: 1.5rem;
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    overflow: hidden;
}

.filter-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid var(--gray-200);
    background: var(--gray-50);
}

.filter-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: var(--gray-900);
}

.filter-title i {
    color: var(--primary);
}

.filter-toggle {
    background: none;
    border: none;
    color: var(--gray-500);
    font-size: 1rem;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: var(--radius);
    transition: var(--transition);
    display: none;
}

.filter-toggle:hover {
    background: var(--gray-100);
    color: var(--gray-700);
}

.filter-content {
    padding: 1.5rem;
}

.filter-form {
    width: 100%;
}

.filter-row {
    display: grid;
    grid-template-columns: 1fr 1fr 1fr auto;
    gap: 1rem;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.filter-label {
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--gray-700);
}

.input-group {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray-400);
    font-size: 0.875rem;
    z-index: 1;
}

.filter-input,
.filter-select {
    width: 100%;
    padding: 0.75rem 1rem 0.75rem 2.5rem;
    border: 2px solid var(--gray-200);
    border-radius: var(--radius-md);
    font-size: 0.875rem;
    background: var(--white);
    transition: var(--transition);
}

.filter-input:focus,
.filter-select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.filter-actions {
    display: flex;
    gap: 0.5rem;
}

.filter-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1rem;
    border-radius: var(--radius-md);
    font-weight: 600;
    font-size: 0.875rem;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    white-space: nowrap;
}

.search-btn {
    background: var(--primary);
    color: var(--white);
}

.search-btn:hover {
    background: var(--primary-dark);
}

.clear-btn {
    background: var(--gray-100);
    color: var(--gray-700);
}

.clear-btn:hover {
    background: var(--gray-200);
    color: var(--gray-900);
}

/* ===== BULK ACTIONS ===== */
.bulk-actions {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 1rem 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
    border-left: 4px solid var(--primary);
}

.bulk-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.bulk-icon {
    color: var(--primary);
    font-size: 1.25rem;
}

.bulk-text {
    font-weight: 600;
    color: var(--gray-900);
}

.bulk-buttons {
    display: flex;
    gap: 0.5rem;
}

.bulk-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    border-radius: var(--radius);
    font-weight: 600;
    font-size: 0.875rem;
    border: none;
    cursor: pointer;
    transition: var(--transition);
}

.activate-btn {
    background: var(--success);
    color: var(--white);
}

.activate-btn:hover {
    background: #16a34a;
}

.deactivate-btn {
    background: var(--warning);
    color: var(--white);
}

.deactivate-btn:hover {
    background: #d97706;
}

.cancel-btn {
    background: var(--gray-200);
    color: var(--gray-700);
}

.cancel-btn:hover {
    background: var(--gray-300);
}

/* ===== USERS CONTAINER ===== */
.users-container {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow);
    border: 1px solid var(--gray-200);
    overflow: hidden;
}

.container-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid var(--gray-200);
    background: var(--gray-50);
}

.container-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: var(--gray-900);
}

.container-title i {
    color: var(--success);
}

.container-count {
    font-size: 0.875rem;
    color: var(--gray-600);
}

.users-content {
    position: relative;
}

/* ===== DESKTOP TABLE ===== */
.desktop-table {
    display: block;
    overflow-x: auto;
}

.users-table {
    width: 100%;
    border-collapse: collapse;
    background: var(--white);
}

.users-table th {
    background: var(--gray-50);
    padding: 1rem 1.5rem;
    text-align: left;
    font-weight: 600;
    font-size: 0.875rem;
    color: var(--gray-700);
    border-bottom: 2px solid var(--gray-200);
    white-space: nowrap;
}

.users-table td {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--gray-100);
    vertical-align: middle;
}

.checkbox-col { width: 50px; }
.user-col { min-width: 250px; }
.role-col { width: 150px; }
.warehouse-col { width: 150px; }
.status-col { width: 120px; }
.date-col { width: 120px; }
.actions-col { width: 180px; }

.table-checkbox {
    width: 18px;
    height: 18px;
    border: 2px solid var(--gray-300);
    border-radius: var(--radius-sm);
    cursor: pointer;
    transition: var(--transition);
}

.table-checkbox:checked {
    background: var(--primary);
    border-color: var(--primary);
}

.user-row {
    transition: var(--transition);
    cursor: pointer;
}

.user-row:hover {
    background: var(--gray-50);
}

.user-row:hover .action-buttons {
    opacity: 1;
}

/* User Info */
.user-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: var(--radius-md);
    background: var(--gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-weight: 700;
    font-size: 0.875rem;
    flex-shrink: 0;
}

.user-details {
    flex: 1;
    min-width: 0;
}

.user-name {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
    line-height: 1.2;
    margin-bottom: 0.125rem;
}

.user-email {
    color: var(--gray-500);
    font-size: 0.75rem;
    line-height: 1.2;
}

/* Role Badge */
.role-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-full);
    font-size: 0.75rem;
    font-weight: 600;
    white-space: nowrap;
}

.role-admin {
    background: linear-gradient(135deg, #ede9fe 0%, #ddd6fe 100%);
    color: #7c3aed;
    border: 1px solid #c4b5fd;
}

.role-2wheel {
    background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
    color: #2563eb;
    border: 1px solid #93c5fd;
}

.role-4wheel {
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    color: #059669;
    border: 1px solid #6ee7b7;
}

.role-unknown {
    background: var(--gray-100);
    color: var(--gray-600);
    border: 1px solid var(--gray-200);
}

/* Warehouse Info */
.warehouse-info {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.warehouse-code {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
}

.warehouse-name {
    color: var(--gray-500);
    font-size: 0.75rem;
}

/* Status Badge */
.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: var(--radius-full);
    font-size: 0.75rem;
    font-weight: 600;
    white-space: nowrap;
}

.status-active {
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    color: #059669;
    border: 1px solid #6ee7b7;
}

.status-inactive {
    background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    color: #dc2626;
    border: 1px solid #fca5a5;
}

/* Date Info */
.date-info {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.date-main {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
}

.date-time {
    color: var(--gray-500);
    font-size: 0.75rem;
}

.no-data {
    color: var(--gray-400);
    font-style: italic;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 0.375rem;
    opacity: 0;
    transition: var(--transition);
}

.action-btn {
    width: 32px;
    height: 32px;
    border-radius: var(--radius);
    border: none;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.875rem;
    text-decoration: none;
}

.edit-btn {
    background: #dbeafe;
    color: #2563eb;
}

.edit-btn:hover {
    background: #2563eb;
    color: var(--white);
    transform: scale(1.1);
}

.toggle-btn {
    background: var(--gray-100);
    color: var(--gray-600);
}

.toggle-btn:hover {
    background: var(--gray-600);
    color: var(--white);
    transform: scale(1.1);
}

.reset-btn {
    background: #fef3c7;
    color: #d97706;
}

.reset-btn:hover {
    background: #d97706;
    color: var(--white);
    transform: scale(1.1);
}

.delete-btn {
    background: #fee2e2;
    color: #dc2626;
}

.delete-btn:hover {
    background: #dc2626;
    color: var(--white);
    transform: scale(1.1);
}

.self-indicator {
    font-size: 0.75rem;
    color: var(--gray-400);
    font-style: italic;
    padding: 0.25rem 0.5rem;
}

/* ===== MOBILE CARDS ===== */
.mobile-cards {
    display: none;
    padding: 1rem;
    gap: 1rem;
    flex-direction: column;
}

.user-card {
    background: var(--white);
    border: 1px solid var(--gray-200);
    border-radius: var(--radius-lg);
    overflow: hidden;
    transition: var(--transition);
}

.user-card:hover {
    box-shadow: var(--shadow-md);
    transform: translateY(-2px);
}

.card-header {
    padding: 1rem;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    position: relative;
    border-bottom: 1px solid var(--gray-100);
}

.card-checkbox {
    width: 18px;
    height: 18px;
    border: 2px solid var(--gray-300);
    border-radius: var(--radius-sm);
    cursor: pointer;
    transition: var(--transition);
}

.card-checkbox:checked {
    background: var(--primary);
    border-color: var(--primary);
}

.card-menu-btn {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: var(--gray-400);
    font-size: 1.125rem;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: var(--radius);
    transition: var(--transition);
}

.card-menu-btn:hover {
    background: var(--gray-100);
    color: var(--gray-600);
}

.card-body {
    padding: 1rem;
}

.card-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.5rem 0;
    border-bottom: 1px solid var(--gray-100);
}

.card-row:last-child {
    border-bottom: none;
}

.row-label {
    color: var(--gray-600);
    font-size: 0.875rem;
    font-weight: 500;
}

.row-value {
    font-weight: 600;
    color: var(--gray-900);
    font-size: 0.875rem;
}

.card-actions {
    border-top: 1px solid var(--gray-200);
    padding: 0.75rem;
    background: var(--gray-50);
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.card-action-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1rem;
    border: none;
    border-radius: var(--radius);
    cursor: pointer;
    transition: var(--transition);
    font-size: 0.875rem;
    text-align: left;
    width: 100%;
    background: var(--white);
    color: var(--gray-700);
    text-decoration: none;
}

.card-action-btn:hover {
    background: var(--gray-100);
}

.card-action-btn.edit {
    color: #2563eb;
}

.card-action-btn.toggle {
    color: var(--gray-600);
}

.card-action-btn.reset {
    color: #d97706;
}

.card-action-btn.delete {
    color: #dc2626;
}

/* ===== EMPTY STATES ===== */
.empty-state {
    padding: 4rem 2rem;
    text-align: center;
}

.empty-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 1rem;
}

.empty-icon {
    font-size: 4rem;
    color: var(--gray-300);
}

.empty-text h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--gray-600);
    margin: 0;
}

.empty-text p {
    font-size: 0.875rem;
    color: var(--gray-500);
    margin: 0.5rem 0 0 0;
}

.empty-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: var(--gradient);
    color: var(--white);
    border-radius: var(--radius-md);
    font-weight: 600;
    text-decoration: none;
    transition: var(--transition);
}

.empty-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--white);
}

.empty-state-mobile {
    padding: 3rem 1rem;
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 1rem;
}

.empty-state-mobile .empty-icon {
    font-size: 3rem;
    color: var(--gray-300);
}

.empty-state-mobile h3 {
    font-size: 1.125rem;
    font-weight: 600;
    color: var(--gray-600);
    margin: 0;
}

.empty-state-mobile p {
    font-size: 0.875rem;
    color: var(--gray-500);
    margin: 0;
}

/* ===== PAGINATION ===== */
.pagination-section {
    padding: 1rem 1.5rem;
    border-top: 1px solid var(--gray-200);
    background: var(--gray-50);
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
}

.pagination-info {
    color: var(--gray-600);
    font-size: 0.875rem;
}

.pagination-links .pagination {
    display: flex;
    gap: 0.25rem;
}

.pagination-links .page-link {
    padding: 0.5rem 0.75rem;
    border: 1px solid var(--gray-300);
    border-radius: var(--radius);
    color: var(--gray-700);
    text-decoration: none;
    transition: var(--transition);
    font-size: 0.875rem;
}

.pagination-links .page-link:hover {
    background: var(--primary);
    color: var(--white);
    border-color: var(--primary);
}

.pagination-links .page-item.active .page-link {
    background: var(--primary);
    color: var(--white);
    border-color: var(--primary);
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1280px) {
    .users-management {
        padding: 1.25rem;
    }
    
    .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    }
}

@media (max-width: 1024px) {
    .users-management {
        padding: 1rem;
    }
    
    .filter-row {
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }
    
    .filter-actions {
        grid-column: 1 / -1;
        justify-content: stretch;
    }
    
    .filter-btn {
        flex: 1;
    }
}

@media (max-width: 768px) {
    .users-management {
        padding: 0.75rem;
    }
    
    /* Header */
    .page-header {
        padding: 1.5rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
        gap: 1rem;
    }
    
    .header-actions {
        width: 100%;
    }
    
    .action-btn {
        flex: 1;
        justify-content: center;
    }
    
    /* Stats */
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    /* Filter */
    .filter-toggle {
        display: block;
    }
    
    .filter-content {
        display: none;
    }
    
    .filter-content.show {
        display: block;
    }
    
    .filter-row {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    /* Bulk Actions */
    .bulk-actions {
        flex-direction: column;
        align-items: stretch;
        gap: 1rem;
    }
    
    .bulk-buttons {
        justify-content: stretch;
    }
    
    .bulk-btn {
        flex: 1;
        justify-content: center;
    }
    
    /* Hide Desktop Table */
    .desktop-table {
        display: none;
    }
    
    /* Show Mobile Cards */
    .mobile-cards {
        display: flex;
    }
    
    /* Pagination */
    .pagination-section {
        flex-direction: column;
        align-items: center;
        gap: 0.75rem;
    }
    
    .pagination-info {
        text-align: center;
    }
}

@media (max-width: 480px) {
    .users-management {
        padding: 0.5rem;
    }
    
    .page-header {
        padding: 1rem;
        border-radius: var(--radius-md);
    }
    
    .title-text h1 {
        font-size: 1.5rem;
    }
    
    .stat-card {
        padding: 1.25rem;
    }
    
    .stat-number {
        font-size: 1.875rem;
    }
    
    .action-btn span {
        display: none;
    }
    
    .bulk-btn span {
        display: none;
    }
}

/* ===== ANIMATIONS ===== */
@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

.filter-content.show {
    animation: slideDown 0.3s ease-out;
}

.bulk-actions {
    animation: slideDown 0.3s ease-out;
}

.user-card {
    animation: fadeIn 0.3s ease-out;
}

/* ===== PRINT STYLES ===== */
@media print {
    .header-actions,
    .filter-section,
    .bulk-actions,
    .action-buttons,
    .card-menu-btn,
    .card-actions,
    .pagination-section {
        display: none !important;
    }
    
    .desktop-table {
        display: block !important;
    }
    
    .mobile-cards {
        display: none !important;
    }
    
    .users-table {
        font-size: 0.75rem;
    }
    
    .action-buttons {
        opacity: 0 !important;
    }
}
</style>
@endpush