<?php
// database/seeders/WarehouseSeeder.php
namespace Database\Seeders;

use App\Models\Warehouse;
use Illuminate\Database\Seeder;

class WarehouseSeeder extends Seeder
{
    public function run()
    {
        $warehouses = [
            [
                'code' => 'WH001',
                'name' => 'คลังกรุงเทพ',
                'location' => 'กรุงเทพมหานคร',
                'is_active' => true,
            ],
            [
                'code' => 'WH002',
                'name' => 'คลังเชียงใหม่',
                'location' => 'เชียงใหม่',
                'is_active' => true,
            ],
            [
                'code' => 'WH003',
                'name' => 'คลังขอนแก่น',
                'location' => 'ขอนแก่น',
                'is_active' => true,
            ],
            [
                'code' => 'WH004',
                'name' => 'คลังสงขลา',
                'location' => 'สงขลา',
                'is_active' => true,
            ],
            [
                'code' => 'WH005',
                'name' => 'คลังชลบุรี',
                'location' => 'ชลบุรี',
                'is_active' => true,
            ],
        ];

        foreach ($warehouses as $warehouse) {
            Warehouse::create($warehouse);
        }
    }
}