<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class VehicleProfileUpdatedNotification extends Notification
{
    use Queueable;

    public function __construct(
        public $vehicle,
        public $updatedFields,
        public $updatedAt
    ) {}

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('แจ้งเตือน: อัปเดตข้อมูล - ' . $this->vehicle->license_plate)
            ->view('emails.vehicle.profile-updated', [
                'vehicle' => $this->vehicle,
                'user' => $notifiable,
                'updatedFields' => $this->updatedFields,
                'updatedAt' => $this->updatedAt
            ]);
    }
}