<?php
// app/Models/Warehouse.php - เพิ่ม relationship
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'name',
        'location',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationship กับ Users
    public function users()
    {
        return $this->hasMany(User::class, 'warehouse_code', 'code');
    }

    // Relationship กับ Commission Rates
    public function commissionRates()
    {
        return $this->hasMany(CommissionRate::class, 'warehouse_code', 'code');
    }

    // Scope สำหรับคลังที่ใช้งานอยู่
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}