<?php

namespace App\Http\Controllers;

use App\Models\WebNotification;
use App\Services\WebNotificationService;
use Illuminate\Http\Request;

class WebNotificationController extends Controller
{
    public function __construct(
        private WebNotificationService $notificationService
    ) {}

    public function index()
    {
        $notifications = $this->notificationService->getRecent(auth()->id(), 50);
        return response()->json($notifications);
    }

    public function unreadCount()
    {
        $count = $this->notificationService->getUnreadCount(auth()->id());
        return response()->json(['count' => (int)$count]);
    }

    public function markAsRead(WebNotification $notification)
    {
        if ($notification->user_id !== auth()->id()) {
            return response()->json(['error' => 'Unauthorized'], 403);
        }
        
        $notification->markAsRead();
        return response()->json(['success' => true]);
    }

    public function markAllAsRead()
    {
        $this->notificationService->markAllAsRead(auth()->id());
        return response()->json(['success' => true]);
    }

    public function destroy(WebNotification $notification)
    {
        if ($notification->user_id !== auth()->id()) {
            return response()->json(['error' => 'Unauthorized'], 403);
        }
        
        $notification->delete();
        return response()->json(['success' => true]);
    }
}