<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Cookie;

class LanguageController extends Controller
{
    public function switch(Request $request)
    {
        $locale = $request->input('locale');
        
        if (in_array($locale, config('app.available_locales', ['th', 'en']))) {
            Session::put('locale', $locale);
            App::setLocale($locale);
            
            // Set cookie for 1 year
            Cookie::queue('locale', $locale, 525600);
            
            // Force session save
            Session::save();
            
            return response()->json([
                'success' => true,
                'locale' => $locale,
                'message' => __('common.language_changed')
            ]);
        }
        
        return response()->json([
            'success' => false,
            'message' => __('common.invalid_language')
        ], 400);
    }
    
    public function switchRedirect(Request $request)
    {
        $locale = $request->input('locale');
        
        if (in_array($locale, config('app.available_locales', ['th', 'en']))) {
            Session::put('locale', $locale);
            App::setLocale($locale);
            Cookie::queue('locale', $locale, 525600);
            Session::save();
            
            return redirect()->back()->with('swal', [
                'title' => 'เปลี่ยนภาษาสำเร็จ!',
                'text' => 'ภาษาได้ถูกเปลี่ยนเรียบร้อยแล้ว',
                'icon' => 'success'
            ]);
        }
        
        return redirect()->back()->with('swal', [
            'title' => 'เกิดข้อผิดพลาด!',
            'text' => 'ไม่สามารถเปลี่ยนภาษาได้',
            'icon' => 'error'
        ]);
    }
}