<?php

namespace App\Helpers;

class SecurityHelper
{
    public static function sanitizeInput($input, $type = 'string')
    {
        if (is_null($input)) {
            return null;
        }

        switch ($type) {
            case 'string':
                return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
            case 'int':
                return (int) $input;
            case 'float':
                return (float) $input;
            case 'email':
                return filter_var($input, FILTER_SANITIZE_EMAIL);
            case 'url':
                return filter_var($input, FILTER_SANITIZE_URL);
            default:
                return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
        }
    }

    public static function validateSqlInput($input)
    {
        $blockedPatterns = config('security.sql_protection.blocked_patterns', []);
        
        foreach ($blockedPatterns as $pattern) {
            if (preg_match('/' . $pattern . '/i', $input)) {
                return false;
            }
        }
        
        return true;
    }

    public static function sanitizeFilename($filename)
    {
        $filename = preg_replace('/[^a-zA-Z0-9._-]/', '', $filename);
        return substr($filename, 0, 255);
    }
}