

<?php $__env->startSection('title', 'เพิ่มคลังใหม่ - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-container">
    <!-- Enhanced Page Header -->
    <div class="page-header">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="page-title">
                    <i class="fas fa-plus-circle text-blue-500 mr-3"></i>
                    เพิ่มคลังใหม่
                </h1>
                <p class="page-subtitle">เพิ่มข้อมูลคลังสินค้าใหม่เข้าสู่ระบบ</p>
            </div>
            <a href="<?php echo e(route('admin.warehouses.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i>กลับไปรายการ
            </a>
        </div>
    </div>

    <!-- Enhanced Form Container -->
    <div class="modern-card">
        <div class="modern-card-header">
            <h3 class="modern-card-title">
                <i class="fas fa-warehouse text-green-500"></i>
                ข้อมูลคลังสินค้า
            </h3>
        </div>
        
        <div class="modern-card-body">
            <form method="POST" action="<?php echo e(route('admin.warehouses.store')); ?>" id="warehouseForm">
                <?php echo csrf_field(); ?>
                
                <div class="form-grid">
                    <!-- รหัสคลัง -->
                    <div class="form-group">
                        <label for="code" class="form-label required">รหัสคลัง</label>
                        <div class="input-with-icon">
                            <i class="fas fa-barcode input-icon"></i>
                            <input type="text" id="code" name="code" value="<?php echo e(old('code')); ?>" 
                                   class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="เช่น WH001, BKK01" required maxlength="10">
                        </div>
                        <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <p class="help-text">รหัสคลังต้องไม่ซ้ำกัน และมีได้สูงสุด 10 ตัวอักษร</p>
                    </div>

                    <!-- ชื่อคลัง -->
                    <div class="form-group">
                        <label for="name" class="form-label required">ชื่อคลัง</label>
                        <div class="input-with-icon">
                            <i class="fas fa-warehouse input-icon"></i>
                            <input type="text" id="name" name="name" value="<?php echo e(old('name')); ?>" 
                                   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   placeholder="เช่น คลังสินค้ากรุงเทพ" required>
                        </div>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- ที่อยู่ -->
                    <div class="form-group full-width">
                        <label for="location" class="form-label">ที่อยู่</label>
                        <div class="textarea-wrapper">
                            <i class="fas fa-map-marker-alt textarea-icon"></i>
                            <textarea id="location" name="location" rows="3" 
                                      class="form-control <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      placeholder="ระบุที่อยู่ของคลังสินค้า"><?php echo e(old('location')); ?></textarea>
                        </div>
                        <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="error-message"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- สถานะ -->
                    <div class="form-group">
                        <label class="form-label">สถานะ</label>
                        <div class="radio-group">
                            <label class="radio-option active">
                                <input type="radio" name="is_active" value="1" 
                                       <?php echo e(old('is_active', '1') === '1' ? 'checked' : ''); ?>>
                                <span class="radio-custom"></span>
                                <span class="radio-label">
                                    <i class="fas fa-check-circle text-green-500"></i>
                                    ใช้งานอยู่
                                </span>
                            </label>
                            <label class="radio-option">
                                <input type="radio" name="is_active" value="0" 
                                       <?php echo e(old('is_active') === '0' ? 'checked' : ''); ?>>
                                <span class="radio-custom"></span>
                                <span class="radio-label">
                                    <i class="fas fa-times-circle text-red-500"></i>
                                    ปิดใช้งาน
                                </span>
                            </label>
                        </div>
                    </div>

                    <!-- ข้อมูลเพิ่มเติม -->
                    <div class="form-group info-box">
                        <div class="info-card">
                            <div class="info-icon">
                                <i class="fas fa-info-circle"></i>
                            </div>
                            <div class="info-content">
                                <h4>ข้อมูลเพิ่มเติม</h4>
                                <p>หลังจากสร้างคลังแล้ว คุณสามารถ:</p>
                                <ul>
                                    <li>กำหนดอัตราค่าคอมมิชชั่นสำหรับคลังนี้</li>
                                    <li>กำหนดผู้ใช้งานให้กับคลัง</li>
                                    <li>ติดตามสถิติการใช้งาน</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Enhanced Submit Section -->
                <div class="form-actions">
                    <div class="actions-left">
                        <div class="progress-indicator">
                            <div class="progress-step active">
                                <i class="fas fa-warehouse"></i>
                                <span>ข้อมูลคลัง</span>
                            </div>
                            <div class="progress-step">
                                <i class="fas fa-percentage"></i>
                                <span>อัตราค่าคอมมิชชั่น</span>
                            </div>
                            <div class="progress-step">
                                <i class="fas fa-users"></i>
                                <span>ผู้ใช้งาน</span>
                            </div>
                        </div>
                    </div>
                    <div class="actions-right">
                        <a href="<?php echo e(route('admin.warehouses.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times"></i>ยกเลิก
                        </a>
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            <i class="fas fa-save"></i>บันทึก
                            <span class="btn-loading" style="display: none;">
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Enhanced Styles -->
<style>
/* Fix Horizontal Scrollbar */
* {
    box-sizing: border-box;
}

.content-container {
    max-width: 100vw;
    overflow-x: hidden;
    padding-left: 1rem;
    padding-right: 1rem;
    box-sizing: border-box;
}

/* Form Grid Layout */
.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
    margin-bottom: 2rem;
}

.form-group.full-width {
    grid-column: 1 / -1;
}

.form-group.info-box {
    grid-column: 1 / -1;
}

/* Enhanced Form Elements */
.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-label {
    font-weight: 600;
    color: var(--dark-gray);
    font-size: 0.95rem;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.form-label.required::after {
    content: '*';
    color: #ef4444;
    font-weight: bold;
}

.input-with-icon {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 1rem;
    color: var(--gray);
    font-size: 1rem;
    z-index: 1;
}

.form-control {
    width: 100%;
    padding: 1rem 1.25rem 1rem 3rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-lg);
    font-family: inherit;
    font-size: 1rem;
    transition: var(--transition-fast);
    background: var(--white);
    line-height: 1.5;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-orange);
    box-shadow: 0 0 0 4px rgba(255, 107, 53, 0.1);
    transform: translateY(-1px);
}

.form-control::placeholder {
    color: var(--gray);
    opacity: 0.7;
}

/* Textarea Styling */
.textarea-wrapper {
    position: relative;
}

.textarea-icon {
    position: absolute;
    top: 1rem;
    left: 1rem;
    color: var(--gray);
    font-size: 1rem;
    z-index: 1;
}

textarea.form-control {
    padding-left: 3rem;
    padding-top: 1rem;
    resize: vertical;
    min-height: 100px;
}

/* Radio Group Styling */
.radio-group {
    display: flex;
    gap: 1.5rem;
    margin-top: 0.5rem;
}

.radio-option {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    cursor: pointer;
    padding: 0.75rem 1rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    transition: var(--transition-fast);
    flex: 1;
    position: relative;
}

.radio-option:hover {
    border-color: var(--primary-orange);
    background: rgba(255, 107, 53, 0.02);
}

.radio-option.active {
    border-color: var(--primary-orange);
    background: rgba(255, 107, 53, 0.05);
}

.radio-option input[type="radio"] {
    display: none;
}

.radio-custom {
    width: 20px;
    height: 20px;
    border: 2px solid var(--medium-gray);
    border-radius: 50%;
    position: relative;
    transition: var(--transition-fast);
}

.radio-option input[type="radio"]:checked + .radio-custom {
    border-color: var(--primary-orange);
    background: var(--primary-orange);
}

.radio-option input[type="radio"]:checked + .radio-custom::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 8px;
    height: 8px;
    background: white;
    border-radius: 50%;
}

.radio-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
    color: var(--dark-gray);
}

/* Info Card Styling */
.info-card {
    display: flex;
    gap: 1rem;
    padding: 1.5rem;
    background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
    border: 1px solid #93c5fd;
    border-radius: var(--radius-lg);
    margin-top: 1rem;
}

.info-icon {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    flex-shrink: 0;
}

.info-content h4 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1e40af;
    margin-bottom: 0.5rem;
}

.info-content p {
    color: #1e40af;
    margin-bottom: 0.75rem;
    font-size: 0.95rem;
}

.info-content ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.info-content li {
    color: #1e40af;
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.info-content li::before {
    content: '✓';
    color: #10b981;
    font-weight: bold;
    width: 16px;
    text-align: center;
}

/* Error Message Styling */
.error-message {
    color: #ef4444;
    font-size: 0.875rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.error-message::before {
    content: '⚠';
    color: #ef4444;
}

/* Help Text Styling */
.help-text {
    color: var(--gray);
    font-size: 0.875rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.help-text::before {
    content: 'ℹ';
    color: #3b82f6;
    font-weight: bold;
}

/* Form Actions */
.form-actions {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 2rem;
    border-top: 2px solid var(--medium-gray);
    margin-top: 2rem;
}

.actions-left {
    flex: 1;
}

.actions-right {
    display: flex;
    gap: 1rem;
}

/* Progress Indicator */
.progress-indicator {
    display: flex;
    gap: 2rem;
}

.progress-step {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    opacity: 0.4;
    transition: var(--transition-fast);
}

.progress-step.active {
    opacity: 1;
}

.progress-step i {
    width: 40px;
    height: 40px;
    background: #e5e7eb;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
    color: #6b7280;
    transition: var(--transition-fast);
}

.progress-step.active i {
    background: var(--primary-gradient);
    color: white;
}

.progress-step span {
    font-size: 0.875rem;
    font-weight: 500;
    color: var(--gray);
    text-align: center;
}

.progress-step.active span {
    color: var(--dark-gray);
    font-weight: 600;
}

/* Button Enhancements */
.btn {
    position: relative;
    overflow: hidden;
}

.btn-loading {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.btn.loading .btn-loading {
    display: block;
}

.btn.loading i:not(.btn-loading i) {
    opacity: 0;
}

.btn-secondary {
    background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
    color: white;
    border: 2px solid transparent;
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #4b5563 0%, #374151 100%);
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
}

/* Responsive Design */
@media (max-width: 1024px) {
    .form-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .progress-indicator {
        display: none;
    }
    
    .form-actions {
        flex-direction: column;
        gap: 1rem;
        align-items: stretch;
    }
    
    .actions-right {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 768px) {
    .content-container {
        padding-left: 0.5rem;
        padding-right: 0.5rem;
    }
    
    .radio-group {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .radio-option {
        justify-content: flex-start;
    }
    
    .info-card {
        flex-direction: column;
        text-align: center;
    }
    
    .info-icon {
        align-self: center;
    }
    
    .form-control {
        padding: 0.875rem 1rem 0.875rem 2.75rem;
    }
    
    .input-icon {
        left: 0.875rem;
        font-size: 0.9rem;
    }
}

@media (max-width: 480px) {
    .content-container {
        padding-left: 0.25rem;
        padding-right: 0.25rem;
    }
    
    .form-grid {
        gap: 1rem;
    }
    
    .actions-right {
        flex-direction: column;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
}
</style>

<!-- Enhanced JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Enhanced functionality
document.addEventListener('DOMContentLoaded', function() {
    initializeForm();
    setupValidation();
    setupInteractions();
});

// Initialize form
function initializeForm() {
    // Auto format warehouse code to uppercase
    const codeInput = document.getElementById('code');
    if (codeInput) {
        codeInput.addEventListener('input', function() {
            this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
            validateField(this);
        });
    }
    
    // Radio button interactions
    const radioOptions = document.querySelectorAll('.radio-option');
    radioOptions.forEach(option => {
        option.addEventListener('click', function() {
            const radio = this.querySelector('input[type="radio"]');
            if (radio) {
                radio.checked = true;
                updateRadioStates();
            }
        });
    });
    
    // Initial radio state
    updateRadioStates();
}

// Setup form validation
function setupValidation() {
    const form = document.getElementById('warehouseForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (validateForm()) {
            submitForm();
        }
    });
    
    // Real-time validation
    const inputs = form.querySelectorAll('input[required], textarea[required]');
    inputs.forEach(input => {
        input.addEventListener('blur', () => validateField(input));
        input.addEventListener('input', () => clearFieldError(input));
    });
}

// Setup interactions
function setupInteractions() {
    // Form field focus effects
    const formControls = document.querySelectorAll('.form-control');
    formControls.forEach(control => {
        control.addEventListener('focus', function() {
            this.parentElement.classList.add('focused');
        });
        
        control.addEventListener('blur', function() {
            this.parentElement.classList.remove('focused');
        });
    });
}

// Validate individual field
function validateField(field) {
    const value = field.value.trim();
    let isValid = true;
    let message = '';
    
    // Required field validation
    if (field.hasAttribute('required') && !value) {
        isValid = false;
        message = 'กรุณากรอกข้อมูลในช่องนี้';
    }
    
    // Specific validations
    if (field.id === 'code' && value) {
        if (value.length < 2) {
            isValid = false;
            message = 'รหัสคลังต้องมีอย่างน้อย 2 ตัวอักษร';
        } else if (value.length > 10) {
            isValid = false;
            message = 'รหัสคลังต้องมีไม่เกิน 10 ตัวอักษร';
        }
    }
    
    if (field.id === 'name' && value && value.length < 3) {
        isValid = false;
        message = 'ชื่อคลังต้องมีอย่างน้อย 3 ตัวอักษร';
    }
    
    // Update field appearance
    if (isValid) {
        field.classList.remove('border-red-500');
        field.classList.add('border-green-500');
        removeFieldError(field);
    } else {
        field.classList.remove('border-green-500');
        field.classList.add('border-red-500');
        showFieldError(field, message);
    }
    
    return isValid;
}

// Clear field error styling
function clearFieldError(field) {
    field.classList.remove('border-red-500', 'border-green-500');
    removeFieldError(field);
}

// Show field error
function showFieldError(field, message) {
    removeFieldError(field);
    
    const errorElement = document.createElement('p');
    errorElement.className = 'error-message';
    errorElement.textContent = message;
    
    field.parentElement.parentElement.appendChild(errorElement);
}

// Remove field error
function removeFieldError(field) {
    const errorElement = field.parentElement.parentElement.querySelector('.error-message');
    if (errorElement) {
        errorElement.remove();
    }
}

// Validate entire form
function validateForm() {
    const code = document.getElementById('code').value.trim();
    const name = document.getElementById('name').value.trim();
    
    let isValid = true;
    
    if (!code) {
        Swal.fire({
            icon: 'error',
            title: 'ข้อมูลไม่ครบถ้วน',
            text: 'กรุณาระบุรหัสคลัง',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('code').focus();
        return false;
    }
    
    if (code.length < 2) {
        Swal.fire({
            icon: 'error',
            title: 'รหัสคลังไม่ถูกต้อง',
            text: 'รหัสคลังต้องมีอย่างน้อย 2 ตัวอักษร',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('code').focus();
        return false;
    }
    
    if (!name) {
        Swal.fire({
            icon: 'error',
            title: 'ข้อมูลไม่ครบถ้วน',
            text: 'กรุณาระบุชื่อคลัง',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('name').focus();
        return false;
    }
    
    if (name.length < 3) {
        Swal.fire({
            icon: 'error',
            title: 'ชื่อคลังไม่ถูกต้อง',
            text: 'ชื่อคลังต้องมีอย่างน้อย 3 ตัวอักษร',
            confirmButtonColor: '#FF6B35'
        });
        document.getElementById('name').focus();
        return false;
    }
    
    return true;
}

// Submit form with loading state
function submitForm() {
    const submitBtn = document.getElementById('submitBtn');
    const form = document.getElementById('warehouseForm');
    
    // Show loading state
    submitBtn.classList.add('loading');
    submitBtn.disabled = true;
    
    // Show confirmation
    Swal.fire({
        title: 'ยืนยันการบันทึก',
        text: 'คุณต้องการบันทึกข้อมูลคลังใหม่นี้หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ยกเลิก',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            return new Promise((resolve) => {
                setTimeout(() => {
                    form.submit();
                    resolve();
                }, 1000);
            });
        }
    }).then((result) => {
        if (!result.isConfirmed) {
            // Reset button state if cancelled
            submitBtn.classList.remove('loading');
            submitBtn.disabled = false;
        }
    });
}

// Update radio button states
function updateRadioStates() {
    const radioOptions = document.querySelectorAll('.radio-option');
    radioOptions.forEach(option => {
        const radio = option.querySelector('input[type="radio"]');
        if (radio && radio.checked) {
            option.classList.add('active');
        } else {
            option.classList.remove('active');
        }
    });
}

// Show success/error messages from session
<?php if(session('success')): ?>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'success',
            title: 'สำเร็จ!',
            text: '<?php echo e(session('success')); ?>',
            confirmButtonColor: '#FF6B35'
        });
    });
<?php endif; ?>

<?php if(session('error')): ?>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด!',
            text: '<?php echo e(session('error')); ?>',
            confirmButtonColor: '#FF6B35'
        });
    });
<?php endif; ?>

// Keyboard shortcuts
document.addEventListener('keydown', function(e) {
    // Ctrl/Cmd + S to save
    if ((e.ctrlKey || e.metaKey) && e.key === 's') {
        e.preventDefault();
        if (validateForm()) {
            submitForm();
        }
    }
    
    // Escape to cancel
    if (e.key === 'Escape') {
        window.location.href = '<?php echo e(route('admin.warehouses.index')); ?>';
    }
});

// Auto-save draft (optional feature)
let autoSaveTimer;
function startAutoSave() {
    clearTimeout(autoSaveTimer);
    autoSaveTimer = setTimeout(() => {
        const formData = new FormData(document.getElementById('warehouseForm'));
        const data = Object.fromEntries(formData);
        localStorage.setItem('warehouse_draft', JSON.stringify(data));
    }, 2000);
}

// Load draft on page load
document.addEventListener('DOMContentLoaded', function() {
    const draft = localStorage.getItem('warehouse_draft');
    if (draft) {
        try {
            const data = JSON.parse(draft);
            Object.keys(data).forEach(key => {
                const field = document.querySelector(`[name="${key}"]`);
                if (field && !field.value) {
                    field.value = data[key];
                    if (field.type === 'radio' && field.value === data[key]) {
                        field.checked = true;
                    }
                }
            });
            updateRadioStates();
        } catch (e) {
            console.log('Could not load draft');
        }
    }
});

// Clear draft on successful submission
window.addEventListener('beforeunload', function() {
    if (document.getElementById('warehouseForm').checkValidity()) {
        localStorage.removeItem('warehouse_draft');
    }
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/admin/warehouses/create.blade.php ENDPATH**/ ?>