<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>รายงานการเงิน - <?php echo e(\Carbon\Carbon::parse($month)->locale('th')->format('F Y')); ?></title>
    <style>
        @font-face {
            font-family: 'THSarabunNew';
            font-style: normal;
            font-weight: normal;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'THSarabunNew', sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #333;
            background: #fff;
        }
        
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* Header */
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #FF6B35;
        }
        
        .header h1 {
            font-size: 32px;
            color: #FF6B35;
            margin-bottom: 10px;
            font-weight: bold;
        }
        
        .header .subtitle {
            font-size: 20px;
            color: #666;
        }
        
        .header .date {
            font-size: 18px;
            color: #888;
            margin-top: 5px;
        }
        
        /* Summary Section */
        .summary {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 30px;
            border: 1px solid #e9ecef;
        }
        
        .summary h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 15px;
            font-weight: bold;
        }
        
        .summary-grid {
            display: table;
            width: 100%;
        }
        
        .summary-item {
            display: table-row;
        }
        
        .summary-label {
            display: table-cell;
            padding: 8px 0;
            font-size: 18px;
            color: #666;
        }
        
        .summary-value {
            display: table-cell;
            text-align: right;
            padding: 8px 0;
            font-size: 20px;
            font-weight: bold;
        }
        
        .income { color: #10b981; }
        .expense { color: #ef4444; }
        .balance { color: #FF6B35; font-size: 22px; }
        
        /* Category Breakdown */
        .category-section {
            margin-bottom: 30px;
        }
        
        .category-section h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e9ecef;
            font-weight: bold;
        }
        
        .category-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .category-table th {
            background: #FF6B35;
            color: white;
            padding: 10px;
            text-align: left;
            font-size: 18px;
            font-weight: bold;
        }
        
        .category-table th:last-child {
            text-align: right;
        }
        
        .category-table td {
            padding: 8px 10px;
            border-bottom: 1px solid #e9ecef;
            font-size: 16px;
        }
        
        .category-table td:last-child {
            text-align: right;
            font-weight: bold;
        }
        
        .category-table tr:nth-child(even) {
            background: #f8f9fa;
        }
        
        /* Transaction Details */
        .transactions {
            margin-top: 40px;
        }
        
        .transactions h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e9ecef;
            font-weight: bold;
        }
        
        .transaction-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }
        
        .transaction-table th {
            background: #6c757d;
            color: white;
            padding: 8px;
            text-align: left;
            font-weight: bold;
            font-size: 16px;
        }
        
        .transaction-table th:nth-child(5),
        .transaction-table td:nth-child(5) {
            text-align: right;
        }
        
        .transaction-table td {
            padding: 6px 8px;
            border-bottom: 1px solid #e9ecef;
        }
        
        .transaction-table tr:nth-child(even) {
            background: #f8f9fa;
        }
        
        .type-income {
            color: #10b981;
            font-weight: bold;
        }
        
        .type-expense {
            color: #ef4444;
            font-weight: bold;
        }
        
        /* Footer */
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 2px solid #e9ecef;
            text-align: center;
            color: #666;
            font-size: 14px;
        }
        
        .footer .generated {
            margin-bottom: 5px;
        }
        
        .footer .company {
            font-weight: bold;
            color: #FF6B35;
        }
        
        /* Page Break */
        .page-break {
            page-break-after: always;
        }
        
        /* Print Styles */
        @media print {
            body {
                font-size: 12pt;
            }
            
            .container {
                padding: 0;
            }
            
            .header {
                margin-bottom: 20px;
            }
            
            .transaction-table {
                font-size: 10pt;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>รายงานการเงิน</h1>
            <div class="subtitle">ประจำเดือน <?php echo e(\Carbon\Carbon::parse($month)->locale('th')->format('F Y')); ?></div>
            <div class="date">พิมพ์เมื่อ: <?php echo e(\Carbon\Carbon::now()->locale('th')->format('d F Y H:i')); ?> น.</div>
        </div>
        
        <!-- Summary -->
        <div class="summary">
            <h2>สรุปภาพรวม</h2>
            <div class="summary-grid">
                <div class="summary-item">
                    <div class="summary-label">รายรับทั้งหมด</div>
                    <div class="summary-value income"><?php echo e(number_format($stats['total_income'], 2)); ?> บาท</div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">รายจ่ายทั้งหมด</div>
                    <div class="summary-value expense"><?php echo e(number_format($stats['total_expense'], 2)); ?> บาท</div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">คงเหลือสุทธิ</div>
                    <div class="summary-value balance"><?php echo e(number_format($stats['net_amount'], 2)); ?> บาท</div>
                </div>
            </div>
        </div>
        
        <!-- Category Breakdown -->
        <?php if(count($stats['expense_by_category']) > 0): ?>
        <div class="category-section">
            <h2>สรุปค่าใช้จ่ายตามหมวดหมู่</h2>
            <table class="category-table">
                <thead>
                    <tr>
                        <th>หมวดหมู่</th>
                        <th style="text-align: center;">จำนวนรายการ</th>
                        <th style="text-align: center;">เปอร์เซ็นต์</th>
                        <th>จำนวนเงิน</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $stats['expense_by_category']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(\App\Models\FinanceCategory::where('slug', $category['category'])->first()->name ?? $category['category']); ?></td>
                        <td style="text-align: center;"><?php echo e($category['count']); ?></td>
                        <td style="text-align: center;"><?php echo e($category['percentage']); ?>%</td>
                        <td><?php echo e(number_format($category['amount'], 2)); ?> บาท</td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
        
        <!-- Transaction Details -->
        <div class="transactions">
            <h2>รายการทั้งหมด</h2>
            <table class="transaction-table">
                <thead>
                    <tr>
                        <th style="width: 15%;">วันที่</th>
                        <th style="width: 12%;">ประเภท</th>
                        <th style="width: 20%;">หมวดหมู่</th>
                        <th style="width: 35%;">รายละเอียด</th>
                        <th style="width: 18%;">จำนวนเงิน</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($record->record_date->format('d/m/Y')); ?></td>
                        <td class="type-<?php echo e($record->type); ?>">
                            <?php echo e($record->type === 'income' ? 'รายรับ' : 'รายจ่าย'); ?>

                        </td>
                        <td><?php echo e($record->categoryInfo ? $record->categoryInfo->name : $record->category); ?></td>
                        <td><?php echo e($record->note ?? '-'); ?></td>
                        <td><?php echo e(number_format($record->amount, 2)); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <div class="generated">
                สร้างรายงานโดย: <?php echo e(auth()->user()->name); ?>

            </div>
            <div class="company">
                ระบบบริหารจัดการการเงิน - Commission Management System
            </div>
        </div>
    </div>
</body>
</html><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/finance/reports/export-pdf.blade.php ENDPATH**/ ?>