
<?php $__env->startSection('title', 'แก้ไขบันทึกการจัดส่งพัสดุ'); ?>

<?php $__env->startSection('content'); ?>
<main class="main-content" style="width:100%;max-width:100vw;min-width:0;margin:0;padding:0;overflow-x:hidden;">
    <div class="content-container" style="width:100%;max-width:100vw;min-width:0;padding:2rem;overflow-x:hidden;">
        
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-edit"></i>
                แก้ไขบันทึกการจัดส่งพัสดุ
            </h1>
            <p class="page-subtitle">แก้ไขข้อมูลการจัดส่งพัสดุของคุณ</p>
        </div>
        
        <!-- Back Button -->
        <div class="mb-3">
            <a href="<?php echo e(route('vehicle.dashboard')); ?>" class="btn" style="background: var(--gray); color: white;">
                <i class="fas fa-arrow-left"></i> กลับหน้าแดชบอร์ด
            </a>
            <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn" style="background: var(--info); color: white; margin-left: 0.5rem;">
                <i class="fas fa-list"></i> ไปหน้าประวัติ
            </a>
        </div>
        
        <!-- Current Record Info -->
        <div class="table-container mb-4">
            <div class="table-header">
                <h3 class="table-title">
                    <i class="fas fa-info-circle"></i> ข้อมูลเดิม
                </h3>
            </div>
            <div style="padding: 1.5rem;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; background: #f8f9fa; padding: 1rem; border-radius: 8px;">
                    <div>
                        <strong>วันที่จัดส่ง:</strong>
                        <div style="color: var(--primary-orange); font-weight: 600;">
                            <?php echo e(\Carbon\Carbon::parse($delivery->delivery_date)->format('d/m/Y')); ?>

                        </div>
                    </div>
                    <div>
                        <strong>จำนวนพัสดุ:</strong>
                        <div style="color: var(--info); font-weight: 600;">
                            <?php echo e(number_format($delivery->parcel_count)); ?> ชิ้น
                        </div>
                    </div>
                    <div>
                        <strong>ค่าคอมมิชชั่น:</strong>
                        <div style="color: var(--success); font-weight: 600;">
                            <?php echo e(number_format($delivery->commission_amount, 2)); ?> บาท
                        </div>
                    </div>
                    <div>
                        <strong>บันทึกเมื่อ:</strong>
                        <div style="color: var(--gray);">
                            <?php echo e(\Carbon\Carbon::parse($delivery->created_at)->format('d/m/Y H:i')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card" style="border-radius: 24px; box-shadow: var(--shadow-lg); overflow: hidden;">
            <div class="card-header" style="background: var(--warning); color: #fff; border-radius: 24px 24px 0 0; padding: 2rem;">
                <h3 style="margin: 0; font-weight: 500;">
                    <i class="fas fa-edit"></i> แก้ไขข้อมูลการจัดส่ง
                </h3>
            </div>
            
            <form method="POST" action="<?php echo e(route('vehicle.deliveries.update', $delivery)); ?>" autocomplete="off" id="delivery-form" style="padding:2rem;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- วันที่จัดส่ง -->
                <div class="form-group mb-3">
                    <label for="delivery_date" class="form-label">
                        <i class="fas fa-calendar-alt"></i> วันที่จัดส่ง <span style="color: #e74c3c;">*</span>
                    </label>
                    <input type="date" name="delivery_date" id="delivery_date"
                        class="form-control <?php $__errorArgs = ['delivery_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        value="<?php echo e(old('delivery_date', $delivery->delivery_date)); ?>" required>
                    <?php $__errorArgs = ['delivery_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="form-text text-muted">
                        <i class="fas fa-exclamation-triangle"></i> 
                        การเปลี่ยนวันที่อาจส่งผลต่อการคำนวณสถิติรายเดือน
                    </small>
                </div>

                <!-- จำนวนพัสดุ -->
                <div class="form-group mb-3">
                    <label for="parcel_count" class="form-label">
                        <i class="fas fa-box"></i> จำนวนพัสดุที่จัดส่งสำเร็จ (ชิ้น) <span style="color: #e74c3c;">*</span>
                    </label>
                    <input type="number" min="1" step="1"
                        class="form-control <?php $__errorArgs = ['parcel_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        id="parcel_count" name="parcel_count" placeholder="กรอกจำนวนพัสดุ"
                        value="<?php echo e(old('parcel_count', $delivery->parcel_count)); ?>" required>
                    <?php $__errorArgs = ['parcel_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- ข้อมูลผู้ใช้ (readonly) -->
                <div class="form-group mb-3">
                    <label class="form-label">
                        <i class="fas fa-user"></i> ข้อมูลของคุณ
                    </label>
                    <div style="background: #f8f9fa; padding: 1.5rem; border-radius: 12px; border: 1px solid var(--medium-gray);">
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                            <div>
                                <strong>ตำแหน่ง:</strong> 
                                <span class="badge" style="background: var(--warning); color: white; margin-left: 0.5rem;">
                                    <?php echo e(auth()->user()->role); ?>

                                </span>
                            </div>
                            <div>
                                <strong>คลัง:</strong> 
                                <span style="color: var(--dark-gray); font-weight: 500;">
                                    <?php echo e(auth()->user()->warehouse->warehouse_name ?? auth()->user()->warehouse_code ?? '-'); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Preview ค่าคอม -->
                <div class="mb-4">
                    <label class="form-label">
                        <i class="fas fa-calculator"></i> การคำนวณค่าคอมมิชชั่นใหม่
                    </label>
                    <div id="commission-preview" style="background: #f8f9fa; border-radius: 12px; border: 1px solid var(--medium-gray); padding: 1.5rem;">
                        <div id="rate-info">
                            <div style="text-align: center; color: var(--gray); padding: 2rem;">
                                <i class="fas fa-calculator" style="font-size: 3rem; margin-bottom: 1rem; display: block; opacity: 0.5;"></i>
                                <p style="margin: 0; font-size: 1.1rem;">กำลังคำนวณค่าคอมมิชชั่น...</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Compare Old vs New -->
                <div class="mb-4" id="comparison-section" style="display: none;">
                    <label class="form-label">
                        <i class="fas fa-exchange-alt"></i> เปรียบเทียบการเปลี่ยนแปลง
                    </label>
                    <div style="background: #e7f3ff; border-radius: 12px; border: 1px solid #b3d9ff; padding: 1.5rem;">
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                            <div style="text-align: center; padding: 1rem; background: white; border-radius: 8px;">
                                <div style="color: var(--gray); font-size: 0.9rem; margin-bottom: 0.5rem;">ค่าคอมมิชชั่นเดิม</div>
                                <div style="color: var(--warning); font-size: 1.5rem; font-weight: 700;">
                                    <?php echo e(number_format($delivery->commission_amount, 2)); ?> บาท
                                </div>
                            </div>
                            <div style="text-align: center; padding: 1rem; background: white; border-radius: 8px;">
                                <div style="color: var(--gray); font-size: 0.9rem; margin-bottom: 0.5rem;">ค่าคอมมิชชั่นใหม่</div>
                                <div id="new-commission" style="color: var(--success); font-size: 1.5rem; font-weight: 700;">
                                    คำนวณ...
                                </div>
                            </div>
                        </div>
                        <div id="difference-info" style="text-align: center; margin-top: 1rem; padding: 0.75rem; border-radius: 8px;">
                            <!-- Difference will be shown here -->
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="mt-4" style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
                    <button type="submit" class="btn btn-primary" 
                            style="min-width: 150px; border-radius: 2rem; font-size: 1.1rem; font-weight:600; padding: 1rem;">
                        <i class="fas fa-save"></i> บันทึกการแก้ไข
                    </button>
                    <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn" 
                       style="background: var(--gray); color: white; min-width: 150px; border-radius: 2rem; font-size: 1.1rem; font-weight:600; padding: 1rem;">
                        <i class="fas fa-times"></i> ยกเลิก
                    </a>
                    <button type="button" class="btn btn-danger" 
                            onclick="deleteRecord(<?php echo e($delivery->id); ?>)"
                            style="min-width: 150px; border-radius: 2rem; font-size: 1.1rem; font-weight:600; padding: 1rem;">
                        <i class="fas fa-trash"></i> ลบบันทึก
                    </button>
                </div>
            </form>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const parcelInput = document.getElementById('parcel_count');
    const rateInfo = document.getElementById('rate-info');
    const comparisonSection = document.getElementById('comparison-section');
    const newCommissionEl = document.getElementById('new-commission');
    const differenceInfo = document.getElementById('difference-info');
    const oldCommission = <?php echo e($delivery->commission_amount); ?>;

    function fetchPreview() {
        const count = parcelInput.value;

        if (!count || count <= 0) {
            rateInfo.innerHTML = `
                <div style="text-align: center; color: var(--gray); padding: 2rem;">
                    <i class="fas fa-calculator" style="font-size: 3rem; margin-bottom: 1rem; display: block; opacity: 0.5;"></i>
                    <p style="margin: 0; font-size: 1.1rem;">กรอกจำนวนพัสดุเพื่อดูการคำนวณค่าคอมมิชชั่น</p>
                </div>
            `;
            comparisonSection.style.display = 'none';
            return;
        }
        
        rateInfo.innerHTML = `
            <div style="text-align: center; color: var(--info); padding: 2rem;">
                <i class="fas fa-spinner fa-spin" style="font-size: 3rem; margin-bottom: 1rem; display: block;"></i>
                <p style="margin: 0; font-size: 1.1rem;">กำลังคำนวณค่าคอมมิชชั่น...</p>
            </div>
        `;
        
        fetch("/commission-preview", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                parcel_count: count
            })
        })
        .then(res => {
            if (!res.ok) throw new Error('Network response was not ok');
            return res.json();
        })
        .then(data => {
            rateInfo.innerHTML = data.preview_html;
            
            // Show comparison
            const newCommission = parseFloat(data.commission);
            newCommissionEl.textContent = newCommission.toLocaleString('th-TH', {minimumFractionDigits: 2}) + ' บาท';
            
            const difference = newCommission - oldCommission;
            let diffHtml = '';
            let diffClass = '';
            
            if (difference > 0) {
                diffHtml = `<i class="fas fa-arrow-up"></i> เพิ่มขึ้น ${difference.toLocaleString('th-TH', {minimumFractionDigits: 2})} บาท`;
                diffClass = 'background: #d4edda; color: #155724; border: 1px solid #c3e6cb;';
            } else if (difference < 0) {
                diffHtml = `<i class="fas fa-arrow-down"></i> ลดลง ${Math.abs(difference).toLocaleString('th-TH', {minimumFractionDigits: 2})} บาท`;
                diffClass = 'background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;';
            } else {
                diffHtml = `<i class="fas fa-equals"></i> ไม่เปลี่ยนแปลง`;
                diffClass = 'background: #e2e3e5; color: #383d41; border: 1px solid #d6d8db;';
            }
            
            differenceInfo.innerHTML = diffHtml;
            differenceInfo.style.cssText = diffClass;
            comparisonSection.style.display = 'block';
        })
        .catch((error) => {
            console.error('Error:', error);
            Swal.fire({
                toast:true, position:'top-end',
                icon: 'error',
                title: 'เกิดข้อผิดพลาด',
                text: 'ไม่สามารถคำนวณค่าคอมมิชชั่นได้ กรุณาลองใหม่อีกครั้ง'
            });
            rateInfo.innerHTML = `
                <div style="text-align: center; color: #F44336; padding: 2rem;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 3rem; margin-bottom: 1rem; display: block;"></i>
                    <p style="margin: 0; font-size: 1.1rem;">เกิดข้อผิดพลาดในการคำนวณ</p>
                    <button onclick="fetchPreview()" class="btn btn-sm" style="background: var(--info); color: white; margin-top: 1rem;">
                        <i class="fas fa-redo"></i> ลองใหม่
                    </button>
                </div>
            `;
        });
    }

    // Event listener for parcel count input
    parcelInput.addEventListener('input', function() {
        clearTimeout(this.timeout);
        this.timeout = setTimeout(fetchPreview, 500); // Debounce 500ms
    });

    // Validate delivery date for duplicates (exclude current record)
    document.getElementById('delivery_date').addEventListener('change', function() {
        const date = this.value;
        if (!date) return;

        fetch("/api/validate-delivery-date", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                delivery_date: date,
                delivery_id: <?php echo e($delivery->id); ?>

            })
        })
        .then(res => res.json())
        .then(data => {
            if (!data.valid) {
                Swal.fire({
                    icon: 'warning',
                    title: 'วันที่ซ้ำ',
                    text: data.message,
                    confirmButtonText: 'เข้าใจแล้ว'
                });
                this.style.borderColor = '#dc3545';
                this.style.boxShadow = '0 0 0 0.2rem rgba(220, 53, 69, 0.25)';
            } else {
                this.style.borderColor = '#28a745';
                this.style.boxShadow = '0 0 0 0.2rem rgba(40, 167, 69, 0.25)';
            }
        })
        .catch(error => {
            console.error('Validation error:', error);
        });
    });

    // Initial calculation
    fetchPreview();
});

// Delete record function
function deleteRecord(id) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบบันทึกการจัดส่งนี้หรือไม่? การลบจะไม่สามารถกู้คืนได้',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก',
        confirmButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/vehicle/deliveries/${id}`;
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            
            form.appendChild(csrfToken);
            form.appendChild(methodField);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Show validation errors
<?php if($errors->any()): ?>
    Swal.fire({
        icon: 'error',
        title: 'ข้อมูลไม่ถูกต้อง',
        html: `<?php echo implode('<br>', $errors->all()); ?>`,
        confirmButtonText: 'ตกลง'
    });
<?php endif; ?>

// Show success message
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'แก้ไขสำเร็จ',
        text: '<?php echo e(session('success')); ?>',
        timer: 2000,
        showConfirmButton: false
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.invalid-feedback {
    display: block;
    width: 100%;
    margin-top: 0.25rem;
    font-size: 0.875rem;
    color: #dc3545;
}

.form-control.is-invalid {
    border-color: #dc3545;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
}

.badge {
    padding: 0.35rem 0.65rem;
    border-radius: 0.375rem;
    font-size: 0.75rem;
    font-weight: 600;
}

.form-text.text-muted {
    margin-top: 0.25rem;
    font-size: 0.875rem;
    color: #6c757d;
}

@media (max-width: 768px) {
    .form-group > div[style*="grid-template-columns"] {
        grid-template-columns: 1fr !important;
        gap: 0.75rem !important;
    }
    
    .mt-4 > div[style*="display: flex"] {
        flex-direction: column !important;
        align-items: stretch !important;
    }
    
    .mt-4 .btn {
        margin-bottom: 0.5rem;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/vehicle/deliveries/edit.blade.php ENDPATH**/ ?>