

<?php $__env->startSection('content'); ?>
<div class="finance-dashboard"><br><br>
    <!-- Header with Month Selector -->
    <div class="dashboard-header">
        <div class="header-content">
            <div class="header-left">
                <h1 class="dashboard-title">
                    <i class="fas fa-chart-line"></i>
                    ภาพรวมการเงิน
                </h1>
                <p class="dashboard-subtitle">
                    <?php echo e(Carbon\Carbon::parse($selectedMonth)->locale('th')->monthName); ?> 
                    <?php echo e(Carbon\Carbon::parse($selectedMonth)->year + 543); ?>

                </p>
            </div>
            <div class="header-right">
                <form method="GET" action="<?php echo e(route('finance.dashboard')); ?>" class="month-selector-form">
                    <select name="month" class="form-select month-selector" onchange="this.form.submit()">
                        <?php $__currentLoopData = $availableMonths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($month['value']); ?>" <?php echo e($selectedMonth == $month['value'] ? 'selected' : ''); ?>>
                                <?php echo e($month['label']); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </form>
                <button class="btn btn-sync" onclick="syncDeliveryData()">
                    <i class="fas fa-sync"></i> ซิงค์ข้อมูลจัดส่ง
                </button>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="summary-cards">
        <div class="summary-card income">
            <div class="card-icon">
                <i class="fas fa-arrow-circle-up"></i>
            </div>
            <div class="card-content">
                <h3 class="card-label">รายรับทั้งหมด</h3>
                <p class="card-value">฿<?php echo e(number_format($monthlyStats['total_income'], 2)); ?></p>
                <div class="card-details">
                    <span class="detail-item">
                        <i class="fas fa-truck"></i> จัดส่ง: ฿<?php echo e(number_format($monthlyStats['income_sources']['delivery'] ?? 0, 2)); ?>

                    </span>
                    <span class="detail-item">
                        <i class="fas fa-plus"></i> อื่นๆ: ฿<?php echo e(number_format($monthlyStats['income_sources']['manual'] ?? 0, 2)); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="summary-card expense">
            <div class="card-icon">
                <i class="fas fa-arrow-circle-down"></i>
            </div>
            <div class="card-content">
                <h3 class="card-label">รายจ่ายทั้งหมด</h3>
                <p class="card-value">฿<?php echo e(number_format($monthlyStats['total_expense'], 2)); ?></p>
                <div class="card-details">
                    <span class="detail-item">
                        <i class="fas fa-chart-pie"></i> <?php echo e(count($monthlyStats['expense_by_category'])); ?> หมวดหมู่
                    </span>
                </div>
            </div>
        </div>

        <div class="summary-card <?php echo e($monthlyStats['is_positive'] ? 'positive' : 'negative'); ?>">
            <div class="card-icon">
                <i class="fas <?php echo e($monthlyStats['is_positive'] ? 'fa-piggy-bank' : 'fa-exclamation-triangle'); ?>"></i>
            </div>
            <div class="card-content">
                <h3 class="card-label">คงเหลือ</h3>
                <p class="card-value">฿<?php echo e(number_format($monthlyStats['net_amount'], 2)); ?></p>
                <div class="card-badge <?php echo e($monthlyStats['is_positive'] ? 'badge-success' : 'badge-danger'); ?>">
                    <?php echo e($monthlyStats['is_positive'] ? 'เงินเหลือ' : 'ติดลบ'); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Recommendations -->
    <?php if(count($recommendations) > 0): ?>
    <div class="recommendations-section">
        <h2 class="section-title">
            <i class="fas fa-lightbulb"></i>
            คำแนะนำการจัดการเงิน
        </h2>
        <div class="recommendations-grid">
            <?php $__currentLoopData = $recommendations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="recommendation-card <?php echo e($rec['type']); ?>">
                <div class="rec-icon">
                    <i class="fas <?php echo e($rec['icon']); ?>"></i>
                </div>
                <div class="rec-content">
                    <h4><?php echo e($rec['message']); ?></h4>
                    <p><?php echo e($rec['suggestion']); ?></p>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Charts Section -->
    <div class="charts-section">
        <div class="chart-container">
            <div class="chart-header">
                <h3 class="chart-title">แนวโน้มรายรับ-รายจ่าย</h3>
                <div class="chart-tabs">
                    <button class="tab-btn active" data-chart="yearly">รายปี</button>
                    <button class="tab-btn" data-chart="daily">รายวัน</button>
                </div>
            </div>
            <div class="chart-body">
                <canvas id="trendChart"></canvas>
            </div>
        </div>

        <div class="chart-container">
            <div class="chart-header">
                <h3 class="chart-title">สัดส่วนค่าใช้จ่าย</h3>
            </div>
            <div class="chart-body">
                <canvas id="expenseChart"></canvas>
            </div>
            <div class="expense-breakdown">
                <?php $__currentLoopData = $monthlyStats['expense_by_category']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $category = \App\Models\FinanceCategory::where('slug', $expense['category'])->first();
                    ?>
                    <div class="expense-item">
                        <div class="expense-info">
                            <i class="fas <?php echo e($category->icon ?? 'fa-circle'); ?>" style="color: <?php echo e($category->color ?? '#6B7280'); ?>"></i>
                            <span class="expense-name"><?php echo e($category->name ?? $expense['category']); ?></span>
                        </div>
                        <div class="expense-amount">
                            <span class="amount">฿<?php echo e(number_format($expense['amount'], 2)); ?></span>
                            <span class="percentage"><?php echo e($expense['percentage']); ?>%</span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- Budget Overview -->
    <?php if($budgets->count() > 0): ?>
    <div class="budget-section">
        <h2 class="section-title">
            <i class="fas fa-bullseye"></i>
            งบประมาณ
        </h2>
        <div class="budget-grid">
            <?php $__currentLoopData = $budgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $percentage = $budget->budget_amount > 0 ? ($budget->spent_amount / $budget->budget_amount) * 100 : 0;
                    $status = $percentage > 100 ? 'over' : ($percentage > 80 ? 'warning' : 'good');
                    $category = \App\Models\FinanceCategory::where('slug', $budget->category)->first();
                ?>
                <div class="budget-card <?php echo e($status); ?>">
                    <div class="budget-header">
                        <span class="budget-category">
                            <i class="fas <?php echo e($category->icon ?? 'fa-circle'); ?>"></i>
                            <?php echo e($category->name ?? $budget->category); ?>

                        </span>
                        <span class="budget-percentage"><?php echo e(number_format($percentage, 0)); ?>%</span>
                    </div>
                    <div class="budget-progress">
                        <div class="progress-bar" style="width: <?php echo e(min($percentage, 100)); ?>%"></div>
                    </div>
                    <div class="budget-amounts">
                        <span>฿<?php echo e(number_format($budget->spent_amount, 0)); ?></span>
                        <span>/</span>
                        <span>฿<?php echo e(number_format($budget->budget_amount, 0)); ?></span>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Recent Transactions -->
    <div class="transactions-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-history"></i>
                รายการล่าสุด
            </h2>
            <a href="<?php echo e(route('finance.records.index')); ?>" class="btn btn-link">
                ดูทั้งหมด <i class="fas fa-arrow-right"></i>
            </a>
        </div>
        <div class="transactions-list">
            <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="transaction-item <?php echo e($transaction->type); ?>">
                <div class="transaction-icon">
                    <i class="fas <?php echo e($transaction->categoryInfo->icon ?? 'fa-circle'); ?>" 
                       style="color: <?php echo e($transaction->categoryInfo->color ?? '#6B7280'); ?>"></i>
                </div>
                <div class="transaction-info">
                    <h4><?php echo e($transaction->note ?? $transaction->categoryInfo->name ?? '-'); ?></h4>
                    <p>
                        <?php echo e($transaction->formatted_date); ?>

                        <?php if($transaction->source === 'delivery'): ?>
                            <span class="badge badge-delivery">จากการจัดส่ง</span>
                        <?php endif; ?>
                    </p>
                </div>
                <div class="transaction-amount <?php echo e($transaction->type); ?>">
                    <?php echo e($transaction->type === 'income' ? '+' : '-'); ?>฿<?php echo e($transaction->formatted_amount); ?>

                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <a href="<?php echo e(route('finance.records.create', ['type' => 'income'])); ?>" class="action-btn income">
            <i class="fas fa-plus-circle"></i>
            เพิ่มรายรับ
        </a>
        <a href="<?php echo e(route('finance.records.create', ['type' => 'expense'])); ?>" class="action-btn expense">
            <i class="fas fa-minus-circle"></i>
            เพิ่มรายจ่าย
        </a>
        <a href="<?php echo e(route('finance.budgets.index')); ?>" class="action-btn budget">
            <i class="fas fa-calculator"></i>
            ตั้งงบประมาณ
        </a>
        <a href="<?php echo e(route('finance.reports.index')); ?>" class="action-btn report">
            <i class="fas fa-file-alt"></i>
            รายงาน
        </a>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.finance-dashboard {
    max-width: 1400px;
    margin: 0 auto;
    padding: 2rem;
}

/* Header Styles */
.dashboard-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 20px;
    padding: 2.5rem;
    margin-bottom: 2rem;
    color: white;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.dashboard-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.dashboard-subtitle {
    font-size: 1.1rem;
    opacity: 0.9;
}

.header-right {
    display: flex;
    gap: 1rem;
    align-items: center;
}

.month-selector {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-size: 1rem;
    cursor: pointer;
}

.month-selector option {
    background: #667eea;
}

.btn-sync {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-sync:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-2px);
}

/* Summary Cards */
.summary-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.summary-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
    gap: 1.5rem;
    transition: transform 0.3s, box-shadow 0.3s;
}

.summary-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
}

.summary-card.income {
    border-top: 4px solid #10b981;
}

.summary-card.expense {
    border-top: 4px solid #ef4444;
}

.summary-card.positive {
    border-top: 4px solid #3b82f6;
}

.summary-card.negative {
    border-top: 4px solid #f59e0b;
}

.card-icon {
    width: 70px;
    height: 70px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.summary-card.income .card-icon {
    background: #10b98120;
    color: #10b981;
}

.summary-card.expense .card-icon {
    background: #ef444420;
    color: #ef4444;
}

.summary-card.positive .card-icon {
    background: #3b82f620;
    color: #3b82f6;
}

.summary-card.negative .card-icon {
    background: #f59e0b20;
    color: #f59e0b;
}

.card-content {
    flex: 1;
}

.card-label {
    font-size: 0.9rem;
    color: #6b7280;
    margin-bottom: 0.5rem;
}

.card-value {
    font-size: 2rem;
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 0.5rem;
}

.card-details {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.detail-item {
    font-size: 0.85rem;
    color: #6b7280;
}

.card-badge {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
}

.badge-success {
    background: #10b98120;
    color: #10b981;
}

.badge-danger {
    background: #ef444420;
    color: #ef4444;
}

/* Recommendations */
.recommendations-section {
    margin-bottom: 2rem;
}

.section-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.recommendations-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
}

.recommendation-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    display: flex;
    gap: 1rem;
    align-items: flex-start;
    border-left: 4px solid;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
}

.recommendation-card.critical {
    border-color: #ef4444;
    background: #fef2f2;
}

.recommendation-card.warning {
    border-color: #f59e0b;
    background: #fffbeb;
}

.recommendation-card.info {
    border-color: #3b82f6;
    background: #eff6ff;
}

.rec-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.recommendation-card.critical .rec-icon {
    background: #ef444420;
    color: #ef4444;
}

.recommendation-card.warning .rec-icon {
    background: #f59e0b20;
    color: #f59e0b;
}

.recommendation-card.info .rec-icon {
    background: #3b82f620;
    color: #3b82f6;
}

.rec-content h4 {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 0.5rem;
    color: #1f2937;
}

.rec-content p {
    font-size: 0.9rem;
    color: #6b7280;
    line-height: 1.5;
}

/* Charts Section */
.charts-section {
    display: grid;
    grid-template-columns: 1.5fr 1fr;
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.chart-container {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
}

.chart-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.chart-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1f2937;
}

.chart-tabs {
    display: flex;
    gap: 0.5rem;
}

.tab-btn {
    padding: 0.5rem 1rem;
    border: none;
    background: #f3f4f6;
    color: #6b7280;
    border-radius: 8px;
    font-size: 0.9rem;
    cursor: pointer;
    transition: all 0.3s;
}

.tab-btn.active {
    background: #667eea;
    color: white;
}

.chart-body {
    height: 300px;
    position: relative;
}

.expense-breakdown {
    margin-top: 1.5rem;
    max-height: 300px;
    overflow-y: auto;
}

.expense-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f3f4f6;
}

.expense-item:last-child {
    border-bottom: none;
}

.expense-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.expense-name {
    font-size: 0.95rem;
    color: #4b5563;
}

.expense-amount {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.amount {
    font-weight: 600;
    color: #1f2937;
}

.percentage {
    font-size: 0.85rem;
    color: #6b7280;
    background: #f3f4f6;
    padding: 0.25rem 0.5rem;
    border-radius: 6px;
}

/* Budget Section */
.budget-section {
    margin-bottom: 2rem;
}

.budget-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 1rem;
}

.budget-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
    border-left: 4px solid;
}

.budget-card.good {
    border-color: #10b981;
}

.budget-card.warning {
    border-color: #f59e0b;
}

.budget-card.over {
    border-color: #ef4444;
}

.budget-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.budget-category {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: #1f2937;
}

.budget-percentage {
    font-size: 1.2rem;
    font-weight: 700;
}

.budget-card.good .budget-percentage {
    color: #10b981;
}

.budget-card.warning .budget-percentage {
    color: #f59e0b;
}

.budget-card.over .budget-percentage {
    color: #ef4444;
}

.budget-progress {
    height: 8px;
    background: #f3f4f6;
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 1rem;
}

.progress-bar {
    height: 100%;
    border-radius: 4px;
    transition: width 0.3s;
}

.budget-card.good .progress-bar {
    background: #10b981;
}

.budget-card.warning .progress-bar {
    background: #f59e0b;
}

.budget-card.over .progress-bar {
    background: #ef4444;
}

.budget-amounts {
    display: flex;
    gap: 0.5rem;
    font-size: 0.9rem;
    color: #6b7280;
}

/* Transactions Section */
.transactions-section {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    margin-bottom: 2rem;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.btn-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    transition: color 0.3s;
}

.btn-link:hover {
    color: #5a5fcd;
}

.transactions-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.transaction-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    border-radius: 12px;
    background: #f9fafb;
    transition: all 0.3s;
}

.transaction-item:hover {
    background: #f3f4f6;
    transform: translateX(5px);
}

.transaction-icon {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.transaction-info {
    flex: 1;
}

.transaction-info h4 {
    font-size: 1rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 0.25rem;
}

.transaction-info p {
    font-size: 0.85rem;
    color: #6b7280;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-delivery {
    background: #ff6b3520;
    color: #ff6b35;
    padding: 0.15rem 0.5rem;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
}

.transaction-amount {
    font-size: 1.1rem;
    font-weight: 700;
}

.transaction-amount.income {
    color: #10b981;
}

.transaction-amount.expense {
    color: #ef4444;
}

/* Quick Actions */
.quick-actions {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    left: 2rem;
    max-width: 600px;
    margin: 0 auto;
    background: white;
    padding: 1.5rem;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
}

.action-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 1rem;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s;
}

.action-btn.income {
    background: #10b98120;
    color: #10b981;
}

.action-btn.income:hover {
    background: #10b981;
    color: white;
    transform: translateY(-3px);
}

.action-btn.expense {
    background: #ef444420;
    color: #ef4444;
}

.action-btn.expense:hover {
    background: #ef4444;
    color: white;
    transform: translateY(-3px);
}

.action-btn.budget {
    background: #f59e0b20;
    color: #f59e0b;
}

.action-btn.budget:hover {
    background: #f59e0b;
    color: white;
    transform: translateY(-3px);
}

.action-btn.report {
    background: #667eea20;
    color: #667eea;
}

.action-btn.report:hover {
    background: #667eea;
    color: white;
    transform: translateY(-3px);
}

/* Responsive */
@media (max-width: 1024px) {
    .charts-section {
        grid-template-columns: 1fr;
    }
    
    .quick-actions {
        position: static;
        max-width: none;
        margin-top: 2rem;
    }
}

@media (max-width: 768px) {
    .finance-dashboard {
        padding: 1rem;
    }
    
    .dashboard-header {
        padding: 1.5rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .header-right {
        width: 100%;
        flex-direction: column;
    }
    
    .month-selector {
        width: 100%;
    }
    
    .summary-cards {
        grid-template-columns: 1fr;
    }
    
    .quick-actions {
        grid-template-columns: 1fr 1fr;
    }
}

/* Scrollbar Styling */
.expense-breakdown::-webkit-scrollbar {
    width: 6px;
}

.expense-breakdown::-webkit-scrollbar-track {
    background: #f3f4f6;
    border-radius: 3px;
}

.expense-breakdown::-webkit-scrollbar-thumb {
    background: #d1d5db;
    border-radius: 3px;
}

.expense-breakdown::-webkit-scrollbar-thumb:hover {
    background: #9ca3af;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Initialize Charts
document.addEventListener('DOMContentLoaded', function() {
    // Trend Chart
    const trendCtx = document.getElementById('trendChart').getContext('2d');
    const yearlyData = <?php echo json_encode($yearlyTrend, 15, 512) ?>;
    
    const trendChart = new Chart(trendCtx, {
        type: 'line',
        data: {
            labels: yearlyData.map(d => d.month_name),
            datasets: [{
                label: 'รายรับ',
                data: yearlyData.map(d => d.income),
                borderColor: '#10b981',
                backgroundColor: '#10b98120',
                tension: 0.4,
                fill: true
            }, {
                label: 'รายจ่าย',
                data: yearlyData.map(d => d.expense),
                borderColor: '#ef4444',
                backgroundColor: '#ef444420',
                tension: 0.4,
                fill: true
            }, {
                label: 'คงเหลือ',
                data: yearlyData.map(d => d.net),
                borderColor: '#3b82f6',
                backgroundColor: '#3b82f620',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '฿' + value.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Expense Pie Chart
    const expenseCtx = document.getElementById('expenseChart').getContext('2d');
    const expenseData = <?php echo json_encode($monthlyStats['expense_by_category'], 15, 512) ?>;
    const categories = <?php echo json_encode(\App\Models\FinanceCategory::expense()->get(), 15, 512) ?>;
    
    const expenseChart = new Chart(expenseCtx, {
        type: 'doughnut',
        data: {
            labels: expenseData.map(d => {
                const cat = categories.find(c => c.slug === d.category);
                return cat ? cat.name : d.category;
            }),
            datasets: [{
                data: expenseData.map(d => d.amount),
                backgroundColor: expenseData.map(d => {
                    const cat = categories.find(c => c.slug === d.category);
                    return cat ? cat.color : '#6B7280';
                })
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });

    // Chart Tab Switching
    const tabBtns = document.querySelectorAll('.tab-btn');
    tabBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            tabBtns.forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            const chartType = this.dataset.chart;
            updateChart(chartType);
        });
    });

    function updateChart(type) {
        fetch(`<?php echo e(route('finance.dashboard.chart')); ?>?type=${type}&period=<?php echo e($selectedMonth); ?>`)
            .then(response => response.json())
            .then(data => {
                if (type === 'daily') {
                    trendChart.data.labels = data.map(d => d.day);
                    trendChart.data.datasets[0].data = data.map(d => d.income);
                    trendChart.data.datasets[1].data = data.map(d => d.expense);
                    trendChart.data.datasets[2].data = data.map(d => d.net);
                } else {
                    trendChart.data.labels = yearlyData.map(d => d.month_name);
                    trendChart.data.datasets[0].data = yearlyData.map(d => d.income);
                    trendChart.data.datasets[1].data = yearlyData.map(d => d.expense);
                    trendChart.data.datasets[2].data = yearlyData.map(d => d.net);
                }
                trendChart.update();
            });
    }
});

// Sync Delivery Data
function syncDeliveryData() {
    const btn = document.querySelector('.btn-sync');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังซิงค์...';
    
    fetch('<?php echo e(route('finance.dashboard.sync')); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({
            month: '<?php echo e($selectedMonth); ?>'
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-sync"></i> ซิงค์ข้อมูลจัดส่ง';
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/finance/dashboard.blade.php ENDPATH**/ ?>