<?php if($paginator->hasPages()): ?>
<nav class="pagination-nav" aria-label="Page navigation">
    <ul class="pagination-list" style="display: flex; gap: 0.4rem; list-style: none; padding:0; margin:0;">
        
        <?php if($paginator->onFirstPage()): ?>
            <li class="pagination-item disabled"><span style="padding:0.4em 1em; border-radius:8px; background:#eee; color:#ccc;">&laquo;</span></li>
        <?php else: ?>
            <li class="pagination-item">
                <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" style="padding:0.4em 1em; border-radius:8px; background:#f9f9f9; color:#FF6B35; text-decoration:none;">&laquo;</a>
            </li>
        <?php endif; ?>

        
        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <?php if(is_string($element)): ?>
                <li class="pagination-item disabled"><span style="padding:0.4em 1em; border-radius:8px; color:#ccc;"><?php echo e($element); ?></span></li>
            <?php endif; ?>

            
            <?php if(is_array($element)): ?>
                <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $paginator->currentPage()): ?>
                        <li class="pagination-item active"><span style="padding:0.4em 1em; border-radius:8px; background:var(--primary-orange); color:#fff; font-weight:600;"><?php echo e($page); ?></span></li>
                    <?php else: ?>
                        <li class="pagination-item"><a href="<?php echo e($url); ?>" style="padding:0.4em 1em; border-radius:8px; background:#fff; color:#FF6B35; border:1px solid #FFD5B3; text-decoration:none;"><?php echo e($page); ?></a></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if($paginator->hasMorePages()): ?>
            <li class="pagination-item">
                <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" style="padding:0.4em 1em; border-radius:8px; background:#f9f9f9; color:#FF6B35; text-decoration:none;">&raquo;</a>
            </li>
        <?php else: ?>
            <li class="pagination-item disabled"><span style="padding:0.4em 1em; border-radius:8px; background:#eee; color:#ccc;">&raquo;</span></li>
        <?php endif; ?>
    </ul>
</nav>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/vendor/pagination/custom.blade.php ENDPATH**/ ?>