

<?php $__env->startSection('content'); ?>
<div class="profile-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">
                <i class="fas fa-user-cog"></i>
                จัดการโปรไฟล์
            </h1>
            <p class="page-subtitle">
                แก้ไขข้อมูลส่วนตัวและตั้งค่าบัญชีของคุณ
            </p>
        </div>
    </div>

    <!-- Profile Grid -->
    <div class="profile-grid">
        <!-- Profile Info Card -->
        <div class="profile-card">
            <div class="card-header">
                <i class="fas fa-user"></i>
                ข้อมูลส่วนตัว
            </div>
            <div class="card-body">
                <!-- Avatar Section -->
                <div class="avatar-section">
                    <div class="avatar-wrapper">
                        <div class="avatar-display">
                            <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

                        </div>
                    </div>
                    <div class="avatar-info">
                        <h3 class="user-name"><?php echo e($user->name); ?></h3>
                        <p class="user-role">
                            <i class="fas fa-<?php echo e($user->role == '2wheel' ? 'motorcycle' : ($user->role == '4wheel' ? 'truck' : 'user-shield')); ?>"></i>
                            <?php echo e($user->role_display_name); ?>

                        </p>
                        <p class="user-warehouse">
                            <i class="fas fa-warehouse"></i>
                            <?php echo e($user->warehouse->name ?? $user->warehouse_code); ?>

                        </p>
                    </div>
                </div>

                <!-- Profile Form -->
                <form id="profileForm" method="post" action="<?php echo e(route('profile.update')); ?>" class="profile-form">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('patch'); ?>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">ชื่อ</label>
                            <input type="text" 
                                   name="first_name" 
                                   value="<?php echo e(old('first_name', $user->first_name)); ?>" 
                                   class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   required>
                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label class="form-label">นามสกุล</label>
                            <input type="text" 
                                   name="last_name" 
                                   value="<?php echo e(old('last_name', $user->last_name)); ?>" 
                                   class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   required>
                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">อีเมล</label>
                        <input type="email" 
                               name="email" 
                               value="<?php echo e(old('email', $user->email)); ?>" 
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               required>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-message"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                            <div class="email-verification-notice">
                                <i class="fas fa-exclamation-circle"></i>
                                อีเมลของคุณยังไม่ได้รับการยืนยัน
                                <button type="button" class="btn-link" onclick="sendVerification()">
                                    ส่งอีเมลยืนยันอีกครั้ง
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        บันทึกการเปลี่ยนแปลง
                    </button>
                </form>
            </div>
        </div>

        <!-- Security Settings Card -->
        <div class="security-card">
            <!-- Password Update -->
            <div class="card-section">
                <div class="card-header">
                    <i class="fas fa-lock"></i>
                    เปลี่ยนรหัสผ่าน
                </div>
                <div class="card-body">
                    <form id="passwordForm" method="post" action="<?php echo e(route('password.update')); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>

                        <div class="form-group">
                            <label class="form-label">รหัสผ่านปัจจุบัน</label>
                            <div class="password-input">
                                <input type="password" 
                                       name="current_password" 
                                       class="form-control <?php $__errorArgs = ['current_password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       autocomplete="current-password">
                                <button type="button" class="toggle-password" onclick="togglePassword(this)">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['current_password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label class="form-label">รหัสผ่านใหม่</label>
                            <div class="password-input">
                                <input type="password" 
                                       name="password" 
                                       class="form-control <?php $__errorArgs = ['password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       autocomplete="new-password">
                                <button type="button" class="toggle-password" onclick="togglePassword(this)">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label class="form-label">ยืนยันรหัสผ่านใหม่</label>
                            <div class="password-input">
                                <input type="password" 
                                       name="password_confirmation" 
                                       class="form-control <?php $__errorArgs = ['password_confirmation', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       autocomplete="new-password">
                                <button type="button" class="toggle-password" onclick="togglePassword(this)">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password_confirmation', 'updatePassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-key"></i>
                            อัปเดตรหัสผ่าน
                        </button>
                    </form>
                </div>
            </div>

            <!-- Account Deletion -->
            <div class="card-section danger-zone">
                <div class="card-header">
                    <i class="fas fa-exclamation-triangle"></i>
                    โซนอันตราย
                </div>
                <div class="card-body">
                    <p class="danger-text">
                        การลบบัญชีจะทำให้ข้อมูลทั้งหมดของคุณถูกลบอย่างถาวรและไม่สามารถกู้คืนได้
                    </p>
                    <button type="button" class="btn btn-danger" onclick="confirmDeleteAccount()">
                        <i class="fas fa-trash"></i>
                        ลบบัญชีผู้ใช้
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Account Info Card -->
    <div class="info-card">
        <div class="card-header">
            <i class="fas fa-info-circle"></i>
            ข้อมูลบัญชี
        </div>
        <div class="card-body">
            <div class="info-grid">
                <div class="info-item">
                    <span class="info-label">รหัสพนักงาน</span>
                    <span class="info-value"><?php echo e($user->id); ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">สถานะบัญชี</span>
                    <span class="info-value status-badge <?php echo e($user->is_active ? 'active' : 'inactive'); ?>">
                        <?php echo e($user->is_active ? 'ใช้งาน' : 'ปิดใช้งาน'); ?>

                    </span>
                </div>
                <div class="info-item">
                    <span class="info-label">วันที่สมัคร</span>
                    <span class="info-value"><?php echo e($user->created_at->format('d/m/Y')); ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">อัปเดตล่าสุด</span>
                    <span class="info-value"><?php echo e($user->updated_at->diffForHumans()); ?></span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Account Modal Form -->
<form id="deleteAccountForm" method="post" action="<?php echo e(route('profile.destroy')); ?>" style="display: none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('delete'); ?>
    <input type="password" name="password" id="deletePassword">
</form>

<?php $__env->startPush('styles'); ?>
<style>
/* Container */
.profile-container {
    max-width: 100%;
    margin: 0;
    padding: 1rem;
    width: 100%;
    box-sizing: border-box;
}

/* Page Header */
.page-header {
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: var(--shadow-sm);
}

.page-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.page-subtitle {
    font-size: 0.9rem;
    color: var(--gray);
    margin: 0.25rem 0 0 0;
}

/* Grid Layout */
.profile-grid {
    display: grid;
    grid-template-columns: 1fr minmax(300px, 400px);
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

/* Cards */
.profile-card,
.security-card,
.info-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, rgba(255, 107, 53, 0.05) 0%, rgba(255, 140, 97, 0.05) 100%);
    padding: 1rem 1.25rem;
    font-weight: 600;
    font-size: 1.05rem;
    color: var(--dark-gray);
    border-bottom: 1px solid var(--medium-gray);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.card-body {
    padding: 1.5rem;
}

.card-section {
    border-bottom: 1px solid var(--medium-gray);
}

.card-section:last-child {
    border-bottom: none;
}

/* Avatar Section */
.avatar-section {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid var(--medium-gray);
}

.avatar-display {
    width: 80px;
    height: 80px;
    border-radius: var(--radius-full);
    background: var(--primary-gradient);
    color: var(--white);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    font-weight: 700;
}

.user-name {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0 0 0.5rem 0;
}

.user-role,
.user-warehouse {
    font-size: 0.9rem;
    color: var(--gray);
    margin: 0.25rem 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

/* Forms */
.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.form-group {
    margin-bottom: 1.25rem;
}

.form-label {
    display: block;
    font-weight: 500;
    color: var(--dark-gray);
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.form-control {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 2px solid var(--medium-gray);
    border-radius: var(--radius-md);
    font-family: inherit;
    font-size: 0.95rem;
    transition: var(--transition-fast);
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-orange);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-control.is-invalid {
    border-color: var(--danger);
}

.error-message {
    display: block;
    color: var(--danger);
    font-size: 0.875rem;
    margin-top: 0.25rem;
}

/* Password Input */
.password-input {
    position: relative;
}

.toggle-password {
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: var(--gray);
    cursor: pointer;
    padding: 0.5rem;
}

.toggle-password:hover {
    color: var(--dark-gray);
}

/* Email Verification Notice */
.email-verification-notice {
    background: #fef3c7;
    border: 1px solid #fbbf24;
    border-radius: var(--radius-md);
    padding: 0.75rem;
    margin-top: 0.5rem;
    font-size: 0.875rem;
    color: #92400e;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-link {
    background: none;
    border: none;
    color: #d97706;
    text-decoration: underline;
    cursor: pointer;
    font-size: inherit;
}

/* Buttons */
.btn {
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: var(--radius-md);
    font-weight: 500;
    font-size: 0.95rem;
    cursor: pointer;
    transition: var(--transition-fast);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-primary {
    background: var(--primary-gradient);
    color: var(--white);
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-danger {
    background: #dc2626;
    color: var(--white);
}

.btn-danger:hover {
    background: #b91c1c;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

/* Danger Zone */
.danger-zone .card-header {
    background: #fee2e2;
    color: #dc2626;
}

.danger-text {
    color: #7f1d1d;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

/* Info Card */
.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.info-label {
    font-size: 0.875rem;
    color: var(--gray);
}

.info-value {
    font-weight: 500;
    color: var(--dark-gray);
}

.status-badge {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    border-radius: var(--radius-full);
    font-size: 0.875rem;
    font-weight: 500;
}

.status-badge.active {
    background: #d1fae5;
    color: #065f46;
}

.status-badge.inactive {
    background: #fee2e2;
    color: #7f1d1d;
}

/* Responsive */
@media (max-width: 992px) {
    .profile-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .profile-container {
        padding: 0.75rem;
    }
    
    .page-header {
        padding: 1rem;
    }
    
    .page-title {
        font-size: 1.25rem;
    }
    
    .card-body {
        padding: 1rem;
    }
    
    .avatar-section {
        flex-direction: column;
        text-align: center;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
}

/* Ensure content fits viewport */
* {
    box-sizing: border-box;
}

.main-content {
    overflow-x: hidden;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Toggle password visibility
function togglePassword(button) {
    const input = button.parentElement.querySelector('input');
    const icon = button.querySelector('i');
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Profile form submission
document.getElementById('profileForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    Swal.fire({
        title: 'ยืนยันการบันทึก?',
        text: 'ต้องการบันทึกการเปลี่ยนแปลงข้อมูลส่วนตัว',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});

// Password form submission
document.getElementById('passwordForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    Swal.fire({
        title: 'ยืนยันการเปลี่ยนรหัสผ่าน?',
        text: 'คุณจะต้องเข้าสู่ระบบใหม่ด้วยรหัสผ่านใหม่',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'เปลี่ยนรหัสผ่าน',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});

// Delete account confirmation
function confirmDeleteAccount() {
    Swal.fire({
        title: 'คุณแน่ใจหรือไม่?',
        html: `
            <div style="text-align: left;">
                <p style="color: #dc2626; font-weight: 600;">⚠️ คำเตือน: การดำเนินการนี้ไม่สามารถย้อนกลับได้</p>
                <ul style="text-align: left; color: #666;">
                    <li>ข้อมูลทั้งหมดของคุณจะถูกลบอย่างถาวร</li>
                    <li>ประวัติการจัดส่งทั้งหมดจะหายไป</li>
                    <li>คุณจะไม่สามารถเข้าสู่ระบบได้อีก</li>
                </ul>
                <p style="margin-top: 1rem;">กรุณากรอกรหัสผ่านเพื่อยืนยัน:</p>
            </div>
        `,
        input: 'password',
        inputPlaceholder: 'กรอกรหัสผ่านของคุณ',
        inputAttributes: {
            autocapitalize: 'off',
            autocorrect: 'off'
        },
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc2626',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'ลบบัญชี',
        cancelButtonText: 'ยกเลิก',
        showLoaderOnConfirm: true,
        preConfirm: (password) => {
            if (!password) {
                Swal.showValidationMessage('กรุณากรอกรหัสผ่าน');
                return false;
            }
            return password;
        }
    }).then((result) => {
        if (result.isConfirmed) {
            // Double confirmation
            Swal.fire({
                title: 'ยืนยันอีกครั้ง',
                text: 'นี่คือการยืนยันครั้งสุดท้าย คุณแน่ใจหรือไม่ที่จะลบบัญชี?',
                icon: 'error',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'ใช่, ลบบัญชี',
                cancelButtonText: 'ไม่, เก็บบัญชีไว้'
            }).then((finalResult) => {
                if (finalResult.isConfirmed) {
                    document.getElementById('deletePassword').value = result.value;
                    document.getElementById('deleteAccountForm').submit();
                }
            });
        }
    });
}

// Send email verification
function sendVerification() {
    Swal.fire({
        title: 'ส่งอีเมลยืนยัน',
        text: 'ต้องการส่งอีเมลยืนยันใหม่หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'ส่งอีเมล',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            // Create form and submit
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '<?php echo e(route("verification.send")); ?>';
            
            const token = document.createElement('input');
            token.type = 'hidden';
            token.name = '_token';
            token.value = '<?php echo e(csrf_token()); ?>';
            form.appendChild(token);
            
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Show success/error messages from session
<?php if(session('status') === 'profile-updated'): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: 'อัปเดตข้อมูลส่วนตัวเรียบร้อยแล้ว',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('status') === 'password-updated'): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: 'เปลี่ยนรหัสผ่านเรียบร้อยแล้ว',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('status') === 'verification-link-sent'): ?>
    Swal.fire({
        icon: 'success',
        title: 'ส่งอีเมลแล้ว!',
        text: 'ลิงก์ยืนยันอีเมลถูกส่งไปยังอีเมลของคุณแล้ว',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/profile/edit.blade.php ENDPATH**/ ?>