

<?php $__env->startSection('content'); ?>
<div class="budget-container">
    <!-- Header -->
    <div class="budget-header">
        <div class="header-content">
            <h1 class="budget-title">
                <i class="fas fa-calculator"></i>
                งบประมาณรายเดือน
            </h1>
            <p class="budget-subtitle">
                <?php echo e(Carbon\Carbon::parse($selectedMonth)->locale('th')->monthName); ?> 
                <?php echo e(Carbon\Carbon::parse($selectedMonth)->year + 543); ?>

            </p>
        </div>
        <div class="header-actions">
            <form method="GET" action="<?php echo e(route('finance.budgets.index')); ?>" class="month-form">
                <select name="month" class="form-select" onchange="this.form.submit()">
                    <?php $__currentLoopData = $availableMonths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($month['value']); ?>" <?php echo e($selectedMonth == $month['value'] ? 'selected' : ''); ?>>
                            <?php echo e($month['label']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
            <button class="btn btn-copy" onclick="copyFromPreviousMonth()">
                <i class="fas fa-copy"></i> คัดลอกจากเดือนก่อน
            </button>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="budget-summary">
        <div class="summary-card total">
            <div class="card-icon">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="card-info">
                <h3>งบประมาณรวม</h3>
                <p class="amount">฿<?php echo e(number_format($totalBudget, 2)); ?></p>
            </div>
        </div>
        <div class="summary-card spent">
            <div class="card-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="card-info">
                <h3>ใช้ไปแล้ว</h3>
                <p class="amount">฿<?php echo e(number_format($totalSpent, 2)); ?></p>
                <span class="percentage"><?php echo e($totalBudget > 0 ? number_format(($totalSpent / $totalBudget) * 100, 1) : 0); ?>%</span>
            </div>
        </div>
        <div class="summary-card <?php echo e($totalRemaining >= 0 ? 'remaining' : 'over'); ?>">
            <div class="card-icon">
                <i class="fas <?php echo e($totalRemaining >= 0 ? 'fa-piggy-bank' : 'fa-exclamation-triangle'); ?>"></i>
            </div>
            <div class="card-info">
                <h3><?php echo e($totalRemaining >= 0 ? 'คงเหลือ' : 'ใช้เกิน'); ?></h3>
                <p class="amount">฿<?php echo e(number_format(abs($totalRemaining), 2)); ?></p>
            </div>
        </div>
    </div>

    <!-- Budget List -->
    <div class="budget-list">
        <div class="list-header">
            <h2>งบประมาณตามหมวดหมู่</h2>
            <button class="btn btn-edit" onclick="toggleEditMode()">
                <i class="fas fa-edit"></i> แก้ไขทั้งหมด
            </button>
        </div>

        <form id="budgetForm" method="POST" action="<?php echo e(route('finance.budgets.bulk-update')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="month" value="<?php echo e($selectedMonth); ?>">
            
            <div class="budget-items">
                <?php $__currentLoopData = $budgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="budget-item <?php echo e($budget->status); ?>">
                        <div class="item-header">
                            <div class="category-info">
                                <i class="fas <?php echo e($budget->categoryInfo->icon ?? 'fa-circle'); ?>" 
                                   style="color: <?php echo e($budget->categoryInfo->color ?? '#6B7280'); ?>"></i>
                                <h4><?php echo e($budget->categoryInfo->name ?? $budget->category); ?></h4>
                            </div>
                            <div class="item-actions">
                                <span class="status-badge <?php echo e($budget->status); ?>">
                                    <?php if($budget->status === 'over'): ?>
                                        เกินงบ <?php echo e(number_format($budget->usage_percentage - 100, 0)); ?>%
                                    <?php elseif($budget->status === 'warning'): ?>
                                        ใกล้หมด
                                    <?php else: ?>
                                        ปกติ
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="progress-container">
                            <div class="progress-bar">
                                <div class="progress-fill <?php echo e($budget->status); ?>" 
                                     style="width: <?php echo e(min($budget->usage_percentage, 100)); ?>%"></div>
                            </div>
                            <div class="progress-info">
                                <span class="used">฿<?php echo e(number_format($budget->spent_amount, 0)); ?></span>
                                <span class="separator">/</span>
                                <span class="budget-amount">
                                    <span class="view-mode">฿<?php echo e(number_format($budget->budget_amount, 0)); ?></span>
                                    <input type="hidden" name="budgets[<?php echo e($loop->index); ?>][id]" value="<?php echo e($budget->id); ?>">
                                    <input type="number" 
                                           name="budgets[<?php echo e($loop->index); ?>][amount]" 
                                           class="edit-mode budget-input"
                                           value="<?php echo e($budget->budget_amount); ?>"
                                           min="0"
                                           step="100"
                                           style="display: none;">
                                </span>
                            </div>
                        </div>
                        
                        <div class="item-footer">
                            <span class="remaining">
                                <?php if($budget->remaining_amount >= 0): ?>
                                    เหลือ ฿<?php echo e(number_format($budget->remaining_amount, 0)); ?>

                                <?php else: ?>
                                    ใช้เกิน ฿<?php echo e(number_format(abs($budget->remaining_amount), 0)); ?>

                                <?php endif; ?>
                            </span>
                            <span class="percentage"><?php echo e(number_format($budget->usage_percentage, 0)); ?>%</span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="form-actions edit-mode" style="display: none;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> บันทึกการแก้ไข
                </button>
                <button type="button" class="btn btn-secondary" onclick="cancelEdit()">
                    <i class="fas fa-times"></i> ยกเลิก
                </button>
            </div>
        </form>
    </div>

    <!-- Tips -->
    <div class="budget-tips">
        <h3><i class="fas fa-lightbulb"></i> เคล็ดลับการตั้งงบประมาณ</h3>
        <div class="tips-grid">
            <div class="tip-card">
                <i class="fas fa-percentage"></i>
                <h4>กฎ 50/30/20</h4>
                <p>50% ค่าใช้จ่ายจำเป็น, 30% ความต้องการ, 20% ออมและลงทุน</p>
            </div>
            <div class="tip-card">
                <i class="fas fa-chart-line"></i>
                <h4>ติดตามสม่ำเสมอ</h4>
                <p>ตรวจสอบการใช้จ่ายทุกสัปดาห์เพื่อควบคุมงบให้อยู่ในแผน</p>
            </div>
            <div class="tip-card">
                <i class="fas fa-piggy-bank"></i>
                <h4>เผื่อฉุกเฉิน</h4>
                <p>ควรมีงบสำรองอย่างน้อย 10% ของรายได้สำหรับเหตุการณ์ไม่คาดคิด</p>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.budget-container {
    max-width: 1000px;
    margin: 2rem auto;
    padding: 0 1rem;
}

/* Header */
.budget-header {
    background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);
    border-radius: 20px;
    padding: 2.5rem;
    color: white;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(245, 158, 11, 0.3);
}

.header-content {
    margin-bottom: 1.5rem;
}

.budget-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.budget-subtitle {
    font-size: 1.2rem;
    opacity: 0.9;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.month-form .form-select {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-size: 1rem;
    cursor: pointer;
}

.month-form .form-select option {
    background: #f59e0b;
}

.btn-copy {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-copy:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-2px);
}

/* Summary Cards */
.budget-summary {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.summary-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.summary-card .card-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.summary-card.total .card-icon {
    background: #3b82f620;
    color: #3b82f6;
}

.summary-card.spent .card-icon {
    background: #f59e0b20;
    color: #f59e0b;
}

.summary-card.remaining .card-icon {
    background: #10b98120;
    color: #10b981;
}

.summary-card.over .card-icon {
    background: #ef444420;
    color: #ef4444;
}

.card-info h3 {
    font-size: 0.9rem;
    color: #6b7280;
    margin-bottom: 0.25rem;
}

.card-info .amount {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

.card-info .percentage {
    display: inline-block;
    margin-left: 0.5rem;
    padding: 0.25rem 0.5rem;
    background: #f3f4f6;
    border-radius: 6px;
    font-size: 0.875rem;
    color: #6b7280;
    font-weight: 600;
}

/* Budget List */
.budget-list {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    margin-bottom: 2rem;
}

.list-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.list-header h2 {
    font-size: 1.3rem;
    font-weight: 600;
    color: #1f2937;
}

.btn-edit {
    background: #f3f4f6;
    border: none;
    color: #6b7280;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-edit:hover {
    background: #e5e7eb;
}

/* Budget Items */
.budget-items {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.budget-item {
    border: 1px solid #e5e7eb;
    border-radius: 12px;
    padding: 1.5rem;
    transition: all 0.3s;
}

.budget-item:hover {
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
}

.budget-item.over {
    border-color: #fecaca;
    background: #fef2f2;
}

.budget-item.warning {
    border-color: #fed7aa;
    background: #fff7ed;
}

.item-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.category-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.category-info i {
    font-size: 1.2rem;
}

.category-info h4 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1f2937;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
}

.status-badge.good {
    background: #d1fae5;
    color: #065f46;
}

.status-badge.warning {
    background: #fed7aa;
    color: #92400e;
}

.status-badge.over {
    background: #fecaca;
    color: #991b1b;
}

/* Progress Bar */
.progress-container {
    margin-bottom: 1rem;
}

.progress-bar {
    height: 12px;
    background: #f3f4f6;
    border-radius: 6px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.progress-fill {
    height: 100%;
    border-radius: 6px;
    transition: width 0.5s ease;
}

.progress-fill.good {
    background: linear-gradient(90deg, #10b981 0%, #34d399 100%);
}

.progress-fill.warning {
    background: linear-gradient(90deg, #f59e0b 0%, #fbbf24 100%);
}

.progress-fill.over {
    background: linear-gradient(90deg, #ef4444 0%, #f87171 100%);
}

.progress-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.95rem;
}

.progress-info .used {
    font-weight: 600;
    color: #6b7280;
}

.progress-info .separator {
    color: #d1d5db;
}

.budget-input {
    padding: 0.375rem 0.75rem;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    font-size: 0.95rem;
    font-weight: 600;
    width: 120px;
    text-align: right;
}

.budget-input:focus {
    outline: none;
    border-color: #f59e0b;
}

/* Item Footer */
.item-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 0.75rem;
    padding-top: 0.75rem;
    border-top: 1px solid #e5e7eb;
}

.remaining {
    font-size: 0.875rem;
    color: #6b7280;
}

.percentage {
    font-size: 1.2rem;
    font-weight: 700;
}

.budget-item.good .percentage {
    color: #10b981;
}

.budget-item.warning .percentage {
    color: #f59e0b;
}

.budget-item.over .percentage {
    color: #ef4444;
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid #e5e7eb;
}

.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 12px;
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-primary {
    background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(245, 158, 11, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(245, 158, 11, 0.4);
}

.btn-secondary {
    background: #f3f4f6;
    color: #6b7280;
}

.btn-secondary:hover {
    background: #e5e7eb;
}

/* Tips Section */
.budget-tips {
    background: #f9fafb;
    border-radius: 20px;
    padding: 2rem;
}

.budget-tips h3 {
    font-size: 1.2rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.tips-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.tip-card {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    text-align: center;
    border: 1px solid #e5e7eb;
}

.tip-card i {
    font-size: 2rem;
    color: #f59e0b;
    margin-bottom: 1rem;
}

.tip-card h4 {
    font-size: 1rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 0.5rem;
}

.tip-card p {
    font-size: 0.875rem;
    color: #6b7280;
    line-height: 1.5;
}

/* Responsive */
@media (max-width: 768px) {
    .budget-header {
        padding: 1.5rem;
    }
    
    .budget-title {
        font-size: 1.5rem;
    }
    
    .header-actions {
        flex-direction: column;
        width: 100%;
    }
    
    .month-form .form-select,
    .btn-copy {
        width: 100%;
    }
    
    .budget-summary {
        grid-template-columns: 1fr;
    }
    
    .tips-grid {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.getElementById('budgetForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    fetch(form.action, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ',
                text: data.message || 'บันทึกงบประมาณเรียบร้อยแล้ว',
                confirmButtonText: 'ตกลง',
                confirmButtonColor: '#f97316'
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'เกิดข้อผิดพลาด',
                text: data.message || 'ไม่สามารถบันทึกงบประมาณได้',
                confirmButtonText: 'ตกลง'
            });
        }
    })
    .catch(error => {
        console.error(error);
        Swal.fire({
            icon: 'error',
            title: 'ข้อผิดพลาด',
            text: 'เกิดข้อผิดพลาดในการเชื่อมต่อเซิร์ฟเวอร์',
            confirmButtonText: 'ตกลง'
        });
    });
});

let editMode = false;

function toggleEditMode() {
    editMode = !editMode;
    
    document.querySelectorAll('.view-mode').forEach(el => {
        el.style.display = editMode ? 'none' : 'inline';
    });
    
    document.querySelectorAll('.edit-mode').forEach(el => {
        el.style.display = editMode ? 'inline' : 'none';
    });
    
    document.querySelector('.btn-edit').innerHTML = editMode 
        ? '<i class="fas fa-times"></i> ยกเลิก' 
        : '<i class="fas fa-edit"></i> แก้ไขทั้งหมด';
}

function cancelEdit() {
    location.reload();
}

function copyFromPreviousMonth() {
    if (!confirm('คุณต้องการคัดลอกงบประมาณจากเดือนที่แล้วใช่หรือไม่?')) {
        return;
    }
    
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route('finance.budgets.copy')); ?>';
    
    const csrfInput = document.createElement('input');
    csrfInput.type = 'hidden';
    csrfInput.name = '_token';
    csrfInput.value = '<?php echo e(csrf_token()); ?>';
    
    const monthInput = document.createElement('input');
    monthInput.type = 'hidden';
    monthInput.name = 'month';
    monthInput.value = '<?php echo e($selectedMonth); ?>';
    
    form.appendChild(csrfInput);
    form.appendChild(monthInput);
    document.body.appendChild(form);
    form.submit();
}

// Auto-save on input change
document.querySelectorAll('.budget-input').forEach(input => {
    let timeout;
    input.addEventListener('input', function() {
        clearTimeout(timeout);
        timeout = setTimeout(() => {
            // Show saving indicator
            const item = this.closest('.budget-item');
            const badge = item.querySelector('.status-badge');
            const originalText = badge.textContent;
            badge.textContent = 'กำลังบันทึก...';
            
            // Here you could implement auto-save via AJAX
            // For now, we'll just restore the text after a delay
            setTimeout(() => {
                badge.textContent = originalText;
            }, 1000);
        }, 500);
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.finance', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/finance/budgets/index.blade.php ENDPATH**/ ?>