@extends('layouts.app')

@section('content')
<div class="deliveries-container"><br><br>
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <h1 class="page-title">
                <i class="fas fa-history"></i>
                ประวัติการจัดส่ง
            </h1>
            <p class="page-subtitle">
                ดูและจัดการข้อมูลการจัดส่งพัสดุ
            </p>
        </div>
        <a href="{{ route('vehicle.deliveries.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> บันทึกการจัดส่ง
        </a>
    </div>

    <!-- Stats Summary -->
    <div class="stats-summary">
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-calendar-check"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $summary['total_days'] }}</div>
                <div class="stat-label">วันทำงาน</div>
            </div>
        </div>
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-box"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ number_format($summary['total_parcels']) }}</div>
                <div class="stat-label">พัสดุทั้งหมด</div>
            </div>
        </div>
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-coins"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ number_format($summary['total_commission'], 2) }}</div>
                <div class="stat-label">ค่าคอมมิชชั่น (บาท)</div>
            </div>
        </div>
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $summary['total_parcels'] > 0 ? number_format($summary['total_parcels'] / max($summary['total_days'], 1), 1) : 0 }}</div>
                <div class="stat-label">เฉลี่ย/วัน</div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="filter-section">
        <form method="GET" action="{{ route('vehicle.deliveries.index') }}" class="filter-form">
            <div class="filter-group">
                <label class="filter-label">เดือน</label>
                <input type="month" 
                       name="month" 
                       value="{{ $selectedMonth }}" 
                       class="form-control"
                       max="{{ date('Y-m') }}">
            </div>
            <div class="filter-group">
                <label class="filter-label">ค้นหา</label>
                <input type="text" 
                       name="search" 
                       value="{{ request('search') }}" 
                       class="form-control" 
                       placeholder="ค้นหา...">
            </div>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> ค้นหา
            </button>
            @if(request('search'))
            <a href="{{ route('vehicle.deliveries.index', ['month' => $selectedMonth]) }}" class="btn btn-outline">
                <i class="fas fa-times"></i> ล้าง
            </a>
            @endif
        </form>
    </div>

    <!-- Weekly Summary -->
    @if(count($weeklyData) > 0)
    <div class="weekly-summary">
        <h3 class="section-title">
            <i class="fas fa-calendar-week"></i>
            สรุปรายสัปดาห์
        </h3>
        <div class="weekly-grid">
            @foreach($weeklyData as $week => $data)
            <div class="week-card">
                <div class="week-header">สัปดาห์ที่ {{ $week }}</div>
                <div class="week-stats">
                    <div class="week-stat">
                        <span class="week-value">{{ $data['days'] }}</span>
                        <span class="week-label">วัน</span>
                    </div>
                    <div class="week-stat">
                        <span class="week-value">{{ number_format($data['parcels']) }}</span>
                        <span class="week-label">พัสดุ</span>
                    </div>
                    <div class="week-stat">
                        <span class="week-value">{{ number_format($data['commission'], 0) }}</span>
                        <span class="week-label">บาท</span>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Records Table -->
    <div class="table-container">
        <div class="table-header">
            <h3 class="table-title">รายการทั้งหมด</h3>
            <span class="record-count">{{ $records->total() }} รายการ</span>
        </div>
        
        @if($records->count() > 0)
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th width="15%">วันที่</th>
                        <th width="15%">วัน</th>
                        <th width="20%" class="text-center">จำนวนพัสดุ</th>
                        <th width="20%" class="text-right">ค่าคอมมิชชั่น</th>
                        <th width="15%" class="text-center">อัตรา/ชิ้น</th>
                        <th width="15%" class="text-center">จัดการ</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($records as $record)
                    <tr>
                        <td>
                            <span class="date-display">{{ $record->formatted_delivery_date }}</span>
                        </td>
                        <td>
                            <span class="day-name">{{ $record->delivery_day_name }}</span>
                        </td>
                        <td class="text-center">
                            <span class="parcel-count">{{ number_format($record->parcel_count) }}</span>
                        </td>
                        <td class="text-right">
                            <span class="commission-amount">{{ number_format($record->commission_amount, 2) }}</span>
                        </td>
                        <td class="text-center">
                            <span class="rate-per-parcel">{{ number_format($record->commission_rate, 2) }}</span>
                        </td>
                        <td class="text-center">
                            <div class="action-buttons">
                                <a href="{{ route('vehicle.deliveries.show', $record) }}" 
                                   class="btn-action btn-view" 
                                   title="ดูรายละเอียด">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('vehicle.deliveries.edit', $record) }}" 
                                   class="btn-action btn-edit" 
                                   title="แก้ไข">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('vehicle.deliveries.destroy', $record) }}" 
                                      method="POST" 
                                      class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="btn-action btn-delete" 
                                            title="ลบ">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="pagination-wrapper">
            {{ $records->withQueryString()->links('vendor.pagination.custom') }}
        </div>
        @else
        <div class="empty-state">
            <i class="fas fa-inbox"></i>
            <h3>ไม่พบข้อมูลการจัดส่ง</h3>
            <p>ยังไม่มีบันทึกการจัดส่งสำหรับเดือนนี้</p>
            <a href="{{ route('vehicle.deliveries.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> บันทึกการจัดส่งแรก
            </a>
        </div>
        @endif
    </div>
</div><br><br>

@push('styles')
<style>
/* Container */
.deliveries-container {
    max-width: 100%;
    margin: 0;
    padding: 1rem;
    width: 100%;
    box-sizing: border-box;
}

/* Page Header */
.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: var(--white);
    border-radius: var(--radius-lg);
    padding: 1.25rem 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: var(--shadow-sm);
}

.page-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.page-subtitle {
    font-size: 0.9rem;
    color: var(--gray);
    margin: 0.25rem 0 0 0;
}

/* Stats Summary */
.stats-summary {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.stat-item {
    background: var(--white);
    border-radius: var(--radius-md);
    padding: 1.25rem;
    box-shadow: var(--shadow-sm);
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #FFE5D5 0%, #FFD5B3 100%);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary-orange);
    font-size: 1.25rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--dark-gray);
    line-height: 1;
}

.stat-label {
    font-size: 0.85rem;
    color: var(--gray);
    margin-top: 0.25rem;
}

/* Filter Section */
.filter-section {
    background: var(--white);
    border-radius: var(--radius-md);
    padding: 1.25rem;
    margin-bottom: 1.5rem;
    box-shadow: var(--shadow-sm);
}

.filter-form {
    display: flex;
    gap: 1rem;
    align-items: flex-end;
    flex-wrap: wrap;
}

.filter-group {
    flex: 1;
    min-width: 180px;
}

.filter-label {
    display: block;
    font-size: 0.875rem;
    font-weight: 500;
    color: var(--dark-gray);
    margin-bottom: 0.5rem;
}

/* Weekly Summary */
.weekly-summary {
    background: var(--white);
    border-radius: var(--radius-md);
    padding: 1.25rem;
    margin-bottom: 1.5rem;
    box-shadow: var(--shadow-sm);
}

.section-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.weekly-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
}

.week-card {
    background: var(--light-gray);
    border-radius: var(--radius-md);
    padding: 1rem;
    text-align: center;
}

.week-header {
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--primary-orange);
    margin-bottom: 0.75rem;
}

.week-stats {
    display: flex;
    justify-content: space-around;
    gap: 0.5rem;
}

.week-stat {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.week-value {
    font-size: 1.1rem;
    font-weight: 700;
    color: var(--dark-gray);
}

.week-label {
    font-size: 0.75rem;
    color: var(--gray);
}

/* Table */
.table-container {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
}

.table-header {
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid var(--medium-gray);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.table-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.record-count {
    font-size: 0.9rem;
    color: var(--gray);
}

.table-responsive {
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table th {
    background: var(--light-gray);
    padding: 0.75rem 1rem;
    font-weight: 600;
    font-size: 0.875rem;
    color: var(--dark-gray);
    text-align: left;
}

.data-table td {
    padding: 0.75rem 1rem;
    border-bottom: 1px solid var(--medium-gray);
    font-size: 0.9rem;
}

.data-table tbody tr:hover {
    background: rgba(255, 107, 53, 0.02);
}

.text-center {
    text-align: center;
}

.text-right {
    text-align: right;
}

.date-display {
    font-weight: 500;
    color: var(--dark-gray);
}

.day-name {
    color: var(--gray);
}

.parcel-count {
    font-weight: 600;
    color: var(--primary-orange);
}

.commission-amount {
    font-weight: 600;
    color: #10b981;
}

.rate-per-parcel {
    color: var(--gray);
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
}

.btn-action {
    width: 32px;
    height: 32px;
    border-radius: var(--radius-sm);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    transition: var(--transition-fast);
    border: none;
    cursor: pointer;
}

.btn-view {
    background: #e0f2fe;
    color: #2563eb;
}

.btn-view:hover {
    background: #2563eb;
    color: white;
}

.btn-edit {
    background: #f3e8ff;
    color: #9333ea;
}

.btn-edit:hover {
    background: #9333ea;
    color: white;
}

.btn-delete {
    background: #fee2e2;
    color: #dc2626;
}

.btn-delete:hover {
    background: #dc2626;
    color: white;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 4rem 2rem;
}

.empty-state i {
    font-size: 4rem;
    color: var(--medium-gray);
    margin-bottom: 1rem;
}

.empty-state h3 {
    font-size: 1.25rem;
    color: var(--dark-gray);
    margin-bottom: 0.5rem;
}

.empty-state p {
    color: var(--gray);
    margin-bottom: 1.5rem;
}

/* Buttons */
.btn {
    padding: 0.625rem 1.25rem;
    border: none;
    border-radius: var(--radius-md);
    font-weight: 500;
    font-size: 0.9rem;
    cursor: pointer;
    transition: var(--transition-fast);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-primary {
    background: var(--primary-gradient);
    color: var(--white);
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-outline {
    background: var(--white);
    border: 2px solid var(--medium-gray);
    color: var(--gray);
}

.btn-outline:hover {
    border-color: var(--primary-orange);
    color: var(--primary-orange);
}

/* Pagination */
.pagination-wrapper {
    padding: 1rem;
    display: flex;
    justify-content: center;
}

/* Utilities */
.d-inline {
    display: inline;
}

/* Responsive */
@media (max-width: 1200px) {
    .stats-summary {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .deliveries-container {
        padding: 0.75rem;
    }
    
    .page-header {
        flex-direction: column;
        align-items: stretch;
        gap: 1rem;
        padding: 1rem;
    }
    
    .page-title {
        font-size: 1.25rem;
    }
    
    .stats-summary {
        grid-template-columns: repeat(2, 1fr);
        gap: 0.75rem;
    }
    
    .stat-item {
        padding: 1rem;
    }
    
    .stat-icon {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
    
    .stat-value {
        font-size: 1.25rem;
    }
    
    .filter-form {
        flex-direction: column;
    }
    
    .filter-group {
        width: 100%;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
    
    .weekly-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .data-table {
        font-size: 0.85rem;
    }
    
    .data-table th,
    .data-table td {
        padding: 0.5rem;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .btn-action {
        width: 28px;
        height: 28px;
        font-size: 0.875rem;
    }
}

@media (max-width: 576px) {
    .stats-summary {
        grid-template-columns: 1fr;
    }
    
    /* Hide some columns on mobile */
    .data-table th:nth-child(2),
    .data-table td:nth-child(2),
    .data-table th:nth-child(5),
    .data-table td:nth-child(5) {
        display: none;
    }
}

/* Ensure content fits viewport */
* {
    box-sizing: border-box;
}

.main-content {
    overflow-x: hidden;
}
</style>
@endpush

@push('scripts')
<script>
// Delete confirmation
document.querySelectorAll('.delete-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (confirm('คุณแน่ใจหรือไม่ที่จะลบรายการนี้?')) {
            this.submit();
        }
    });
});

// Auto-submit form on month change
document.querySelector('input[name="month"]').addEventListener('change', function() {
    this.form.submit();
});
</script>
@endpush
@endsection