@extends('layouts.app')
@section('title', 'แดชบอร์ด - EasyCom Plus')
@section('content')
<div class="vehicle-dashboard-container"><br><br>
    <!-- Welcome Hero Section -->
    <div class="dashboard-hero">
        <div class="dashboard-hero-blur"></div>
        <div class="dashboard-hero-white1"></div>
        <div class="dashboard-hero-white2"></div>
        <div class="dashboard-hero-main">
            <div class="dashboard-hero-row">
                <div>
                    <div class="dashboard-hero-flex">
                        <div class="dashboard-hero-crown">
                            <i class="fas fa-motorcycle"></i>
                        </div>
                        <div>
                            <h1 class="dashboard-hero-title">สวัสดี, {{ auth()->user()->first_name }}</h1>
                            <p class="dashboard-hero-desc">ยินดีต้อนรับเข้าสู่ระบบจัดการการจัดส่ง</p>
                        </div>
                    </div>
                    <div class="dashboard-hero-date">
                        <i class="fas fa-calendar-alt"></i>
                        {{ now()->locale('th')->translatedFormat('วันl ที่ j F Y') }}
                    </div>
                </div>
                <div class="dashboard-hero-time">
                    <div class="dashboard-hero-time-box">
                        <div class="dashboard-hero-time-label">เวลาปัจจุบัน</div>
                        <div class="dashboard-hero-time-value" id="currentTime">{{ now()->format('H:i:s') }}</div>
                        <div class="dashboard-hero-time-desc">Bangkok, Thailand</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="dashboard-grid">
        <!-- Today's Stats -->
        <div class="dashboard-card dashboard-card-orange">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-orange">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($todayStats['parcels'] ?? 0) }}</div>
                        <div class="dashboard-card-label">พัสดุวันนี้</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status">
                        <i class="fas fa-coins"></i> {{ number_format($todayStats['commission'] ?? 0, 2) }} บาท
                    </div>
                    <a href="{{ route('vehicle.deliveries.create') }}" class="dashboard-card-link">
                        บันทึก <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- This Week Stats -->
        <div class="dashboard-card dashboard-card-blue">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-blue">
                        <i class="fas fa-calendar-week"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($weekStats['parcels'] ?? 0) }}</div>
                        <div class="dashboard-card-label">พัสดุสัปดาห์นี้</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-blue">
                        <i class="fas fa-coins"></i> {{ number_format($weekStats['commission'] ?? 0, 2) }} บาท
                    </div>
                    <div class="dashboard-card-link">
                        {{ $weekStats['days'] ?? 0 }} วัน
                    </div>
                </div>
            </div>
        </div>

        <!-- This Month Stats -->
        <div class="dashboard-card dashboard-card-green">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-green">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($monthStats['parcels'] ?? 0) }}</div>
                        <div class="dashboard-card-label">พัสดุเดือนนี้</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-green">
                        <i class="fas fa-coins"></i> {{ number_format($monthStats['commission'] ?? 0, 2) }} บาท
                    </div>
                    <a href="{{ route('vehicle.deliveries.index') }}" class="dashboard-card-link">
                        ดูทั้งหมด <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Average Per Day -->
        <div class="dashboard-card dashboard-card-purple">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-purple">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($avgStats['parcels_per_day'] ?? 0, 1) }}</div>
                        <div class="dashboard-card-label">เฉลี่ยต่อวัน</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-purple">
                        <i class="fas fa-coins"></i> {{ number_format($avgStats['commission_per_day'] ?? 0, 2) }} บาท
                    </div>
                    <div class="dashboard-card-link">
                        {{ $monthStats['days'] ?? 0 }} วันทำงาน
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions & Charts Section -->
    <div class="dashboard-section-grid">
        <!-- Quick Actions -->
        <div class="modern-card dashboard-quick-actions">
            <div class="modern-card-header">
                <div class="d-flex align-items-center">
                    <div class="quick-action-icon">
                        <i class="fas fa-rocket"></i>
                    </div>
                    <h3>เมนูลัด</h3>
                </div>
            </div>
            <div class="quick-action-list">
                <a href="{{ route('vehicle.deliveries.create') }}" class="quick-action-item orange">
                    <i class="fas fa-plus-circle"></i>
                    บันทึกการจัดส่งวันนี้
                </a>
                <a href="{{ route('vehicle.deliveries.index') }}" class="quick-action-item blue">
                    <i class="fas fa-list"></i>
                    ดูประวัติการจัดส่ง
                </a>
                <a href="{{ route('vehicle.calculator') }}" class="quick-action-item purple">
                    <i class="fas fa-calculator"></i>
                    คำนวณค่าคอมมิชชั่น
                </a>
                <a href="{{ route('finance.dashboard') }}" class="quick-action-item green">
                    <i class="fas fa-wallet"></i>
                    ระบบการเงินส่วนตัว
                </a>
            </div>
        </div>

        <!-- Daily Chart -->
        <div class="modern-card">
            <div class="modern-card-header">
                <div class="d-flex align-items-center">
                    <div class="chart-header-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                    <h3>สถิติการจัดส่ง 7 วันล่าสุด</h3>
                </div>
            </div>
            <div class="modern-card-body">
                <canvas id="dailyChart" height="300"></canvas>
            </div>
        </div>
    </div>

    <!-- Recent Records & Commission Rates -->
    <div class="dashboard-section-grid2">
        <!-- Recent Delivery Records -->
        <div class="modern-card">
            <div class="modern-card-header">
                <div class="d-flex align-items-center">
                    <div class="recent-header-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>บันทึกล่าสุด</h3>
                </div>
                <a href="{{ route('vehicle.deliveries.index') }}" class="see-all-link">
                    ดูทั้งหมด <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            <div class="recent-records-list">
                @forelse($recentRecords as $record)
                <div class="recent-record-item">
                    <div class="d-flex align-items-center">
                        <div class="recent-icon">
                            <i class="fas fa-box"></i>
                        </div>
                        <div class="recent-info">
                            <div class="recent-date">{{ $record->delivery_date->format('d/m/Y') }}</div>
                            <div class="recent-detail">{{ $record->parcel_count }} พัสดุ</div>
                        </div>
                    </div>
                    <div class="recent-amount">฿{{ number_format($record->commission_amount, 2) }}</div>
                </div>
                @empty
                <div class="recent-empty">
                    <i class="fas fa-inbox"></i>
                    <p>ยังไม่มีบันทึกการจัดส่ง</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Commission Rate Info -->
        <div class="modern-card">
            <div class="modern-card-header">
                <div class="d-flex align-items-center">
                    <div class="status-header-icon">
                        <i class="fas fa-info-circle"></i>
                    </div>
                    <h3>อัตราค่าคอมมิชชั่น</h3>
                </div>
            </div>
            <div class="commission-info">
                <div class="commission-warehouse">
                    <i class="fas fa-warehouse"></i>
                    คลัง: <strong>{{ auth()->user()->warehouse->name ?? auth()->user()->warehouse_code }}</strong>
                </div>
                <div class="commission-vehicle">
                    <i class="fas fa-{{ auth()->user()->role == '2wheel' ? 'motorcycle' : 'truck' }}"></i>
                    ประเภท: <strong>{{ auth()->user()->role == '2wheel' ? 'รถ 2 ล้อ' : 'รถ 4 ล้อ' }}</strong>
                </div>
                
                @if($commissionRates->count() > 0)
                <div class="rate-table">
                    <table>
                        <thead>
                            <tr>
                                <th>ช่วงพัสดุ</th>
                                <th>อัตรา/ชิ้น</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($commissionRates as $rate)
                            <tr>
                                <td>{{ $rate->range_display }}</td>
                                <td class="rate-amount">{{ number_format($rate->rate_per_package, 2) }} บาท</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="recent-empty">
                    <i class="fas fa-exclamation-circle"></i>
                    <p>ยังไม่มีการตั้งค่าอัตราค่าคอมมิชชั่น</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div><br><br>

@push('styles')
<style>
/* Vehicle Dashboard Responsive Styles */
.vehicle-dashboard-container {
    max-width: 100%;
    margin: 0;
    padding: 1rem;
    width: 100%;
    box-sizing: border-box;
}

/* Stats grid responsive */
.dashboard-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
    width: 100%;
}

.dashboard-card {
    padding: 1.25rem;
    min-height: 150px;
}

.dashboard-card-num {
    font-size: 1.8rem;
}

.dashboard-card-icon {
    width: 45px;
    height: 45px;
    font-size: 1.4rem;
}

/* Section grids responsive */
.dashboard-section-grid {
    display: grid;
    grid-template-columns: minmax(280px, 350px) 1fr;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.dashboard-section-grid2 {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 1.5rem;
}

/* Hero adjustments */
.dashboard-hero {
    margin-bottom: 1.5rem;
    padding: 1.5rem;
}

.dashboard-hero-title {
    font-size: 1.6rem;
}

.dashboard-hero-time-box {
    padding: 1rem 1.25rem;
}

.dashboard-hero-time-value {
    font-size: 1.6rem;
}

/* Additional styles */
.d-flex {
    display: flex;
}

.align-items-center {
    align-items: center;
}

.modern-card {
    background: var(--white);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
    height: 100%;
}

.modern-card-header {
    padding: 1.25rem;
    border-bottom: 1px solid var(--medium-gray);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modern-card-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--dark-gray);
    margin: 0;
}

.modern-card-body {
    padding: 1.25rem;
    overflow: hidden;
}

#dailyChart {
    max-height: 280px !important;
}

/* Quick actions compact */
.quick-action-list {
    padding: 1rem;
    gap: 0.75rem;
}

.quick-action-item {
    padding: 0.7rem 1rem;
    font-size: 0.95rem;
}

.see-all-link {
    color: var(--primary-orange);
    text-decoration: none;
    font-size: 0.9rem;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    transition: var(--transition-fast);
}

.see-all-link:hover {
    color: var(--primary-dark);
    transform: translateX(2px);
}

.recent-records-list {
    padding: 0.5rem;
}

.recent-record-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    border-bottom: 1px solid var(--medium-gray);
    transition: var(--transition-fast);
}

.recent-record-item:last-child {
    border-bottom: none;
}

.recent-record-item:hover {
    background: var(--light-gray);
}

.recent-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #FFE5D5 0%, #FFD5B3 100%);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary-orange);
    margin-right: 1rem;
}

.recent-info {
    flex: 1;
}

.recent-date {
    font-weight: 600;
    color: var(--dark-gray);
}

.recent-detail {
    font-size: 0.9rem;
    color: var(--gray);
}

.recent-amount {
    font-size: 1.1rem;
    font-weight: 700;
    color: var(--primary-orange);
}

.commission-info {
    padding: 1.5rem;
}

.commission-warehouse,
.commission-vehicle {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 0;
    font-size: 1rem;
    color: var(--dark-gray);
}

.commission-warehouse i,
.commission-vehicle i {
    color: var(--primary-orange);
    width: 20px;
}

.rate-table {
    margin-top: 1rem;
    overflow: hidden;
    border-radius: var(--radius-md);
    border: 1px solid var(--medium-gray);
}

.rate-table table {
    width: 100%;
    border-collapse: collapse;
}

.rate-table th {
    background: var(--light-gray);
    padding: 0.75rem 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--dark-gray);
    font-size: 0.9rem;
}

.rate-table td {
    padding: 0.75rem 1rem;
    border-top: 1px solid var(--medium-gray);
}

.rate-table tr:hover {
    background: var(--light-gray);
}

.rate-amount {
    text-align: right;
    font-weight: 600;
    color: var(--primary-orange);
}

.green {
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    color: #10b981;
}

/* Responsive breakpoints */
@media (max-width: 1200px) {
    .dashboard-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .dashboard-section-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .vehicle-dashboard-container {
        padding: 0.75rem;
    }
    
    .dashboard-hero {
        padding: 1rem;
    }
    
    .dashboard-hero-title {
        font-size: 1.3rem;
    }
    
    .dashboard-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 0.75rem;
    }
    
    .dashboard-card {
        padding: 1rem;
        min-height: 130px;
    }
    
    .dashboard-card-num {
        font-size: 1.5rem;
    }
    
    .dashboard-section-grid,
    .dashboard-section-grid2 {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 576px) {
    .dashboard-grid {
        grid-template-columns: 1fr;
    }
}

/* Ensure content fits viewport */
.main-content {
    overflow-x: hidden;
    max-width: 100vw;
}

.content-container {
    overflow-x: hidden;
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Update current time
function updateTime() {
    const now = new Date();
    const timeString = now.toLocaleTimeString('th-TH', { hour12: false });
    document.getElementById('currentTime').textContent = timeString;
}
setInterval(updateTime, 1000);

// Daily Chart
const ctx = document.getElementById('dailyChart').getContext('2d');
const chartData = @json($chartData ?? []);

new Chart(ctx, {
    type: 'bar',
    data: {
        labels: chartData.labels || [],
        datasets: [{
            label: 'จำนวนพัสดุ',
            data: chartData.parcels || [],
            backgroundColor: '#FF6B35',
            borderColor: '#FF6B35',
            borderWidth: 1,
            borderRadius: 8,
            yAxisID: 'y'
        }, {
            label: 'ค่าคอมมิชชั่น (บาท)',
            data: chartData.commissions || [],
            type: 'line',
            borderColor: '#3B82F6',
            backgroundColor: 'rgba(59, 130, 246, 0.1)',
            borderWidth: 3,
            pointRadius: 5,
            pointBackgroundColor: '#3B82F6',
            tension: 0.3,
            yAxisID: 'y1'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        interaction: {
            mode: 'index',
            intersect: false,
        },
        plugins: {
            legend: {
                display: true,
                position: 'top',
                labels: {
                    padding: 15,
                    font: {
                        size: 12,
                        family: "'Kanit', sans-serif"
                    }
                }
            },
            tooltip: {
                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                padding: 12,
                cornerRadius: 8,
                titleFont: {
                    size: 14,
                    family: "'Kanit', sans-serif"
                },
                bodyFont: {
                    size: 13,
                    family: "'Kanit', sans-serif"
                },
                callbacks: {
                    label: function(context) {
                        let label = context.dataset.label || '';
                        if (context.parsed.y !== null) {
                            if (context.datasetIndex === 0) {
                                label += ': ' + context.parsed.y + ' ชิ้น';
                            } else {
                                label += ': ' + new Intl.NumberFormat('th-TH').format(context.parsed.y) + ' บาท';
                            }
                        }
                        return label;
                    }
                }
            }
        },
        scales: {
            x: {
                grid: {
                    display: false
                },
                ticks: {
                    font: {
                        family: "'Kanit', sans-serif"
                    }
                }
            },
            y: {
                type: 'linear',
                display: true,
                position: 'left',
                beginAtZero: true,
                grid: {
                    color: 'rgba(0, 0, 0, 0.05)'
                },
                ticks: {
                    font: {
                        family: "'Kanit', sans-serif"
                    }
                }
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                beginAtZero: true,
                grid: {
                    drawOnChartArea: false,
                },
                ticks: {
                    font: {
                        family: "'Kanit', sans-serif"
                    }
                }
            }
        }
    }
});
</script>
@endpush
@endsection