@extends('layouts.admin')

@section('title', 'รายงานคลังสินค้า')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">รายงานคลังสินค้า</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">หน้าหลัก</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.reports.index') }}">รายงาน</a></li>
                    <li class="breadcrumb-item active">รายงานคลังสินค้า</li>
                </ol>
            </nav>
        </div>
        <div>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exportModal">
                <i class="fas fa-download"></i> ส่งออกรายงาน
            </button>
            <button type="button" class="btn btn-secondary" onclick="window.print()">
                <i class="fas fa-print"></i> พิมพ์
            </button>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form id="filterForm" method="GET" action="{{ route('admin.reports.warehouse') }}">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">คลังสินค้า</label>
                        <select class="form-select" name="warehouse_id">
                            <option value="">ทั้งหมด</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->id }}" {{ request('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                    {{ $warehouse->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">ช่วงเวลา</label>
                        <select class="form-select" name="period">
                            <option value="month" {{ request('period', 'month') == 'month' ? 'selected' : '' }}>เดือนนี้</option>
                            <option value="quarter" {{ request('period') == 'quarter' ? 'selected' : '' }}>ไตรมาสนี้</option>
                            <option value="year" {{ request('period') == 'year' ? 'selected' : '' }}>ปีนี้</option>
                            <option value="custom" {{ request('period') == 'custom' ? 'selected' : '' }}>กำหนดเอง</option>
                        </select>
                    </div>
                    <div class="col-md-3" id="customStartDate" style="display: none;">
                        <label class="form-label">วันที่เริ่มต้น</label>
                        <input type="date" class="form-control" name="start_date" value="{{ request('start_date') }}">
                    </div>
                    <div class="col-md-3" id="customEndDate" style="display: none;">
                        <label class="form-label">วันที่สิ้นสุด</label>
                        <input type="date" class="form-control" name="end_date" value="{{ request('end_date') }}">
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-filter"></i> กรองข้อมูล
                        </button>
                        <a href="{{ route('admin.reports.warehouse') }}" class="btn btn-secondary">
                            <i class="fas fa-redo"></i> รีเซ็ต
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Overall Performance Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                จำนวนคลังทั้งหมด
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $overallStats['total_warehouses'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                การจัดส่งรวม
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($overallStats['total_deliveries']) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-truck fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                ประสิทธิภาพเฉลี่ย
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $overallStats['average_efficiency'] }}%
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                พนักงานทั้งหมด
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($overallStats['total_employees']) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Performance Metrics per Warehouse -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">ประสิทธิภาพของแต่ละคลังสินค้า</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>คลังสินค้า</th>
                            <th>จำนวนการจัดส่ง</th>
                            <th>อัตราความสำเร็จ</th>
                            <th>เวลาเฉลี่ย</th>
                            <th>จำนวนพนักงาน</th>
                            <th>ประสิทธิภาพ</th>
                            <th>คะแนน</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($warehouseMetrics as $metric)
                            <tr>
                                <td>
                                    <strong>{{ $metric->name }}</strong>
                                    <br>
                                    <small class="text-muted">{{ $metric->location }}</small>
                                </td>
                                <td>{{ number_format($metric->total_deliveries) }}</td>
                                <td>
                                    <div class="progress">
                                        <div class="progress-bar bg-success" role="progressbar" 
                                             style="width: {{ $metric->success_rate }}%">
                                            {{ $metric->success_rate }}%
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $metric->average_time }} นาที</td>
                                <td>{{ $metric->employee_count }}</td>
                                <td>
                                    @if($metric->efficiency >= 90)
                                        <span class="badge bg-success">ดีเยี่ยม</span>
                                    @elseif($metric->efficiency >= 75)
                                        <span class="badge bg-primary">ดี</span>
                                    @elseif($metric->efficiency >= 60)
                                        <span class="badge bg-warning">พอใช้</span>
                                    @else
                                        <span class="badge bg-danger">ต้องปรับปรุง</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="text-warning">
                                        @for($i = 1; $i <= 5; $i++)
                                            @if($i <= $metric->rating)
                                                <i class="fas fa-star"></i>
                                            @else
                                                <i class="far fa-star"></i>
                                            @endif
                                        @endfor
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <!-- 6-Month Trend Comparison -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">แนวโน้มการจัดส่ง 6 เดือนล่าสุด</h6>
                </div>
                <div class="card-body">
                    <canvas id="trendChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Employee Distribution -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">การกระจายพนักงาน</h6>
                </div>
                <div class="card-body">
                    <canvas id="employeeDistributionChart"></canvas>
                    <div class="mt-4 text-center small">
                        @foreach($employeeDistribution as $dist)
                            <span class="mr-2">
                                <i class="fas fa-circle" style="color: {{ $dist->color }}"></i> 
                                {{ $dist->name }}
                            </span>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Warehouse Ranking -->
    <div class="row mb-4">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">อันดับคลังสินค้า (ตามประสิทธิภาพ)</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>อันดับ</th>
                                    <th>คลังสินค้า</th>
                                    <th>คะแนนประสิทธิภาพ</th>
                                    <th>การเปลี่ยนแปลง</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($warehouseRanking as $index => $warehouse)
                                    <tr>
                                        <td>
                                            @if($index == 0)
                                                <i class="fas fa-trophy text-warning"></i>
                                            @elseif($index == 1)
                                                <i class="fas fa-medal text-secondary"></i>
                                            @elseif($index == 2)
                                                <i class="fas fa-medal" style="color: #CD7F32;"></i>
                                            @else
                                                {{ $index + 1 }}
                                            @endif
                                        </td>
                                        <td>{{ $warehouse->name }}</td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar bg-primary" role="progressbar" 
                                                     style="width: {{ $warehouse->efficiency_score }}%">
                                                    {{ $warehouse->efficiency_score }}%
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @if($warehouse->rank_change > 0)
                                                <span class="text-success">
                                                    <i class="fas fa-arrow-up"></i> {{ $warehouse->rank_change }}
                                                </span>
                                            @elseif($warehouse->rank_change < 0)
                                                <span class="text-danger">
                                                    <i class="fas fa-arrow-down"></i> {{ abs($warehouse->rank_change) }}
                                                </span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Efficiency Comparison -->
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">เปรียบเทียบประสิทธิภาพ</h6>
                </div>
                <div class="card-body">
                    <canvas id="efficiencyComparisonChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Performance Analysis -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">การวิเคราะห์ประสิทธิภาพโดยละเอียด</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="font-weight-bold mb-3">ปัจจัยที่ส่งผลต่อประสิทธิภาพ</h6>
                    <canvas id="factorsChart"></canvas>
                </div>
                <div class="col-md-6">
                    <h6 class="font-weight-bold mb-3">คำแนะนำในการปรับปรุง</h6>
                    <div class="alert alert-info">
                        <h6 class="alert-heading">คลังที่ควรเร่งปรับปรุง</h6>
                        <ul class="mb-0">
                            @foreach($improvementSuggestions as $suggestion)
                                <li>
                                    <strong>{{ $suggestion->warehouse_name }}:</strong>
                                    {{ $suggestion->suggestion }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="alert alert-success">
                        <h6 class="alert-heading">คลังที่มีผลงานดีเด่น</h6>
                        <ul class="mb-0">
                            @foreach($topPerformers as $performer)
                                <li>
                                    <strong>{{ $performer->name }}:</strong>
                                    {{ $performer->achievement }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Monthly Comparison Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">สรุปผลการดำเนินงานรายเดือน</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>เดือน</th>
                            @foreach($warehouses as $warehouse)
                                <th class="text-center">{{ $warehouse->name }}</th>
                            @endforeach
                            <th class="text-center">รวม</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($monthlyComparison as $month)
                            <tr>
                                <td>{{ $month->month_name }}</td>
                                @foreach($month->warehouse_data as $data)
                                    <td class="text-center">
                                        {{ number_format($data->deliveries) }}
                                        <br>
                                        <small class="text-muted">({{ $data->success_rate }}%)</small>
                                    </td>
                                @endforeach
                                <td class="text-center font-weight-bold">
                                    {{ number_format($month->total) }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Export Modal -->
<div class="modal fade" id="exportModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">ส่งออกรายงานคลังสินค้า</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.reports.warehouse.export') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">รูปแบบไฟล์</label>
                        <select class="form-select" name="format" required>
                            <option value="excel">Excel (.xlsx)</option>
                            <option value="pdf">PDF</option>
                            <option value="csv">CSV</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">คลังสินค้า</label>
                        <select class="form-select" name="warehouse_id">
                            <option value="">ทั้งหมด</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">ช่วงเวลา</label>
                        <select class="form-select" name="period" required>
                            <option value="current">ตามตัวกรองปัจจุบัน</option>
                            <option value="month">เดือนนี้</option>
                            <option value="quarter">ไตรมาสนี้</option>
                            <option value="year">ปีนี้</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">เลือกข้อมูลที่ต้องการ</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="summary" checked>
                            <label class="form-check-label">สรุปภาพรวม</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="performance_metrics" checked>
                            <label class="form-check-label">ตัวชี้วัดประสิทธิภาพ</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="trend_analysis" checked>
                            <label class="form-check-label">การวิเคราะห์แนวโน้ม</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="ranking" checked>
                            <label class="form-check-label">การจัดอันดับ</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="monthly_comparison" checked>
                            <label class="form-check-label">เปรียบเทียบรายเดือน</label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download"></i> ส่งออก
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    @media print {
        .btn, .breadcrumb, .card {
            break-inside: avoid;
        }
        
        .no-print {
            display: none !important;
        }
    }
    
    .table-responsive {
        max-height: 500px;
        overflow-y: auto;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // 6-Month Trend Chart
    const trendCtx = document.getElementById('trendChart').getContext('2d');
    new Chart(trendCtx, {
        type: 'line',
        data: {
            labels: @json($trendData->pluck('month')),
            datasets: [
                @foreach($warehouses as $warehouse)
                {
                    label: '{{ $warehouse->name }}',
                    data: @json($trendData->pluck('warehouse_' . $warehouse->id)),
                    borderColor: '{{ $warehouse->color }}',
                    backgroundColor: '{{ $warehouse->color }}20',
                    tension: 0.4
                },
                @endforeach
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Employee Distribution Chart
    const employeeCtx = document.getElementById('employeeDistributionChart').getContext('2d');
    new Chart(employeeCtx, {
        type: 'pie',
        data: {
            labels: @json($employeeDistribution->pluck('name')),
            datasets: [{
                data: @json($employeeDistribution->pluck('count')),
                backgroundColor: @json($employeeDistribution->pluck('color'))
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });

    // Efficiency Comparison Chart
    const efficiencyCtx = document.getElementById('efficiencyComparisonChart').getContext('2d');
    new Chart(efficiencyCtx, {
        type: 'radar',
        data: {
            labels: ['อัตราความสำเร็จ', 'ความเร็ว', 'ความแม่นยำ', 'การใช้ทรัพยากร', 'ความพึงพอใจ'],
            datasets: [
                @foreach($warehouses->take(3) as $warehouse)
                {
                    label: '{{ $warehouse->name }}',
                    data: @json($warehouse->efficiency_metrics),
                    borderColor: '{{ $warehouse->color }}',
                    backgroundColor: '{{ $warehouse->color }}20'
                },
                @endforeach
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                r: {
                    beginAtZero: true,
                    max: 100
                }
            }
        }
    });

    // Factors Chart
    const factorsCtx = document.getElementById('factorsChart').getContext('2d');
    new Chart(factorsCtx, {
        type: 'horizontalBar',
        data: {
            labels: ['จำนวนพนักงาน', 'ขนาดพื้นที่', 'อุปกรณ์', 'ระบบจัดการ', 'การฝึกอบรม'],
            datasets: [{
                label: 'ระดับความสำคัญ',
                data: [85, 70, 90, 95, 80],
                backgroundColor: [
                    'rgba(255, 99, 132, 0.5)',
                    'rgba(54, 162, 235, 0.5)',
                    'rgba(255, 206, 86, 0.5)',
                    'rgba(75, 192, 192, 0.5)',
                    'rgba(153, 102, 255, 0.5)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: {
                    beginAtZero: true,
                    max: 100
                }
            }
        }
    });

    // Period toggle
    document.querySelector('select[name="period"]').addEventListener('change', function() {
        const isCustom = this.value === 'custom';
        document.getElementById('customStartDate').style.display = isCustom ? 'block' : 'none';
        document.getElementById('customEndDate').style.display = isCustom ? 'block' : 'none';
    });

    // Initialize period display
    if (document.querySelector('select[name="period"]').value === 'custom') {
        document.getElementById('customStartDate').style.display = 'block';
        document.getElementById('customEndDate').style.display = 'block';
    }
});
</script>
@endpush