<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FinanceCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $incomeCategories = [
            ['name' => 'เงินเดือน', 'slug' => 'salary', 'icon' => 'fa-money-bill-wave', 'color' => '#10B981'],
            ['name' => 'ค่าคอมมิชชั่นจัดส่ง', 'slug' => 'delivery-commission', 'icon' => 'fa-truck', 'color' => '#FF6B35'],
            ['name' => 'รายได้เสริม', 'slug' => 'side-income', 'icon' => 'fa-coins', 'color' => '#3B82F6'],
            ['name' => 'โบนัส', 'slug' => 'bonus', 'icon' => 'fa-gift', 'color' => '#8B5CF6'],
            ['name' => 'ดอกเบี้ย/เงินปันผล', 'slug' => 'interest-dividend', 'icon' => 'fa-percentage', 'color' => '#EC4899'],
            ['name' => 'อื่นๆ', 'slug' => 'other-income', 'icon' => 'fa-plus-circle', 'color' => '#6B7280'],
        ];

        $expenseCategories = [
            ['name' => 'ค่าที่พัก/บ้าน', 'slug' => 'housing', 'icon' => 'fa-home', 'color' => '#DC2626'],
            ['name' => 'ค่าอาหาร', 'slug' => 'food', 'icon' => 'fa-utensils', 'color' => '#F59E0B'],
            ['name' => 'ค่าเดินทาง/น้ำมัน', 'slug' => 'transport', 'icon' => 'fa-gas-pump', 'color' => '#EF4444'],
            ['name' => 'ค่าสาธารณูปโภค', 'slug' => 'utilities', 'icon' => 'fa-bolt', 'color' => '#F97316'],
            ['name' => 'ค่าใช้จ่ายส่วนตัว', 'slug' => 'personal', 'icon' => 'fa-user', 'color' => '#8B5CF6'],
            ['name' => 'สุขภาพ/ยา', 'slug' => 'health', 'icon' => 'fa-heartbeat', 'color' => '#EC4899'],
            ['name' => 'ความบันเทิง', 'slug' => 'entertainment', 'icon' => 'fa-film', 'color' => '#6366F1'],
            ['name' => 'การศึกษา', 'slug' => 'education', 'icon' => 'fa-graduation-cap', 'color' => '#0EA5E9'],
            ['name' => 'ประกัน', 'slug' => 'insurance', 'icon' => 'fa-shield-alt', 'color' => '#14B8A6'],
            ['name' => 'ผ่อนชำระ/หนี้สิน', 'slug' => 'debt', 'icon' => 'fa-credit-card', 'color' => '#A78BFA'],
            ['name' => 'ช้อปปิ้ง', 'slug' => 'shopping', 'icon' => 'fa-shopping-bag', 'color' => '#F472B6'],
            ['name' => 'อื่นๆ', 'slug' => 'other-expense', 'icon' => 'fa-ellipsis-h', 'color' => '#9CA3AF'],
        ];

        // Insert income categories
        foreach ($incomeCategories as $index => $category) {
            DB::table('finance_categories')->insert([
                'name' => $category['name'],
                'slug' => $category['slug'],
                'type' => 'income',
                'icon' => $category['icon'],
                'color' => $category['color'],
                'sort_order' => $index + 1,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // Insert expense categories
        foreach ($expenseCategories as $index => $category) {
            DB::table('finance_categories')->insert([
                'name' => $category['name'],
                'slug' => $category['slug'],
                'type' => 'expense',
                'icon' => $category['icon'],
                'color' => $category['color'],
                'sort_order' => $index + 1,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}