<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('warehouse_id')->nullable()->constrained()->onDelete('set null');
            $table->date('delivery_date');
            $table->integer('parcel_count');
            $table->decimal('commission_amount', 10, 2);
            $table->timestamps();

            // Indexes for performance
            $table->index(['user_id', 'delivery_date']);
            $table->index(['delivery_date']);
            $table->index(['user_id', 'created_at']);

            // Unique constraint to prevent duplicate entries per user per day
            $table->unique(['user_id', 'delivery_date'], 'unique_user_delivery_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delivery_records');
    }
};